/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.execution;

import com.intellij.compiler.OutputParser;
import com.intellij.compiler.impl.javaCompiler.FileObject;
import com.intellij.compiler.impl.javaCompiler.javac.JavacOutputParser;
import com.intellij.compiler.impl.javaCompiler.jikes.JikesOutputParser;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.execution.AntBuildMessageView;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.text.StringTokenizer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class OutputParser {
    @NonNls
    private static final String JAVAC = "javac";
    @NonNls
    private static final String ECHO = "echo";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ant.execution.OutputParser");
    private final Project myProject;
    private final AntBuildMessageView myMessageView;
    private final WeakReference<ProgressIndicator> myProgress;
    private final String myBuildName;
    private final OSProcessHandler myProcessHandler;
    private volatile boolean isStopped;
    private List<String> myJavacMessages;
    private boolean myFirstLineProcessed;
    private boolean myStartedSuccessfully;
    private boolean myIsEcho;

    public OutputParser(Project project, OSProcessHandler processHandler, AntBuildMessageView errorsView, ProgressIndicator progress, String buildName) {
        this.myProject = project;
        this.myProcessHandler = processHandler;
        this.myMessageView = errorsView;
        this.myProgress = new WeakReference<ProgressIndicator>(progress);
        this.myBuildName = buildName;
        this.myMessageView.setParsingThread(this);
    }

    public final void stopProcess() {
        this.myProcessHandler.destroyProcess();
    }

    public boolean isTerminateInvoked() {
        return this.myProcessHandler.isProcessTerminating() || this.myProcessHandler.isProcessTerminated();
    }

    protected Project getProject() {
        return this.myProject;
    }

    protected OSProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    public final boolean isStopped() {
        return this.isStopped;
    }

    public final void setStopped(boolean stopped) {
        this.isStopped = stopped;
    }

    private void setProgressStatistics(String s) {
        ProgressIndicator progress = (ProgressIndicator)this.myProgress.get();
        if (progress != null) {
            progress.setText2(s);
        }
    }

    private void setProgressText(String s) {
        ProgressIndicator progress = (ProgressIndicator)this.myProgress.get();
        if (progress != null) {
            progress.setText(s);
        }
    }

    private void printRawError(String text) {
        this.myMessageView.outputError(text, 0);
    }

    public final void readErrorOutput(String text) {
        if (!this.myFirstLineProcessed) {
            this.myFirstLineProcessed = true;
            this.myStartedSuccessfully = false;
            this.myMessageView.buildFailed(this.myBuildName);
        }
        if (!this.myStartedSuccessfully) {
            this.printRawError(text);
        }
    }

    protected final void processTag(char tagName, String tagValue, int priority) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.valueOf(tagName) + priority + "=" + tagValue);
        }
        if ('G' == tagName) {
            this.setProgressStatistics(AntBundle.message("target.tag.name.status.text", tagValue));
        } else if ('T' == tagName) {
            this.setProgressText(AntBundle.message("executing.task.tag.value.status.text", tagValue));
            if (JAVAC.equals(tagValue)) {
                this.myJavacMessages = new ArrayList<String>();
            } else if (ECHO.equals(tagValue)) {
                this.myIsEcho = true;
            }
        }
        if (this.myJavacMessages != null && ('M' == tagName || 'E' == tagName)) {
            this.myJavacMessages.add(tagValue);
            return;
        }
        if ('M' == tagName) {
            if (this.myIsEcho) {
                this.myMessageView.outputMessage(tagValue, 3);
            } else {
                this.myMessageView.outputMessage(tagValue, priority);
            }
        } else if ('G' == tagName) {
            this.myMessageView.startTarget(tagValue);
        } else if ('T' == tagName) {
            this.myMessageView.startTask(tagValue);
        } else if ('E' == tagName) {
            this.myMessageView.outputError(tagValue, priority);
        } else if ('X' == tagName) {
            String exceptionText = tagValue.replace('\u0000', '\n');
            this.myMessageView.outputException(exceptionText);
        } else if ('B' == tagName) {
            this.myMessageView.startBuild(this.myBuildName);
        } else if ('g' == tagName || 't' == tagName) {
            List<String> javacMessages = this.myJavacMessages;
            this.myJavacMessages = null;
            OutputParser.processJavacMessages(javacMessages, this.myMessageView, this.myProject);
            this.myIsEcho = false;
            if ('g' == tagName) {
                this.myMessageView.finishTarget();
            } else {
                this.myMessageView.finishTask();
            }
        }
    }

    private static boolean isJikesMessage(String errorMessage) {
        for (int j = 0; j < errorMessage.length(); ++j) {
            int offset;
            if (errorMessage.charAt(j) != ':' || (offset = OutputParser.getNextTwoPoints(j, errorMessage)) < 0 || (offset = OutputParser.getNextTwoPoints(offset, errorMessage)) < 0 || (offset = OutputParser.getNextTwoPoints(offset, errorMessage)) < 0 || (offset = OutputParser.getNextTwoPoints(offset, errorMessage)) < 0) continue;
            return true;
        }
        return false;
    }

    private static int getNextTwoPoints(int offset, String message) {
        for (int i = offset + 1; i < message.length(); ++i) {
            char c = message.charAt(i);
            if (c == ':') {
                return i;
            }
            if (Character.isDigit(c)) continue;
            return -1;
        }
        return -1;
    }

    private static void processJavacMessages(final List<String> javacMessages, final AntBuildMessageView messageView, Project project) {
        if (javacMessages == null) {
            return;
        }
        boolean isJikes = false;
        for (String errorMessage : javacMessages) {
            if (!OutputParser.isJikesMessage(errorMessage)) continue;
            isJikes = true;
            break;
        }
        Object outputParser = isJikes ? new JikesOutputParser(project) : new JavacOutputParser(project);
        OutputParser.Callback callback = new OutputParser.Callback(){
            private int myIndex = -1;

            @Nullable
            public String getCurrentLine() {
                if (javacMessages == null || this.myIndex >= javacMessages.size()) {
                    return null;
                }
                return (String)javacMessages.get(this.myIndex);
            }

            public String getNextLine() {
                int next;
                int size = javacMessages.size();
                this.myIndex = next = Math.min(this.myIndex + 1, javacMessages.size());
                if (next >= size) {
                    return null;
                }
                return (String)javacMessages.get(next);
            }

            public void pushBack(String line) {
                --this.myIndex;
            }

            public void message(final CompilerMessageCategory category, String message, final String url, final int lineNum, final int columnNum) {
                StringTokenizer tokenizer = new StringTokenizer(message, "\n", false);
                final String[] strings = new String[tokenizer.countTokens()];
                int idx = 0;
                while (tokenizer.hasMoreTokens()) {
                    strings[idx] = tokenizer.nextToken();
                    ++idx;
                }
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        VirtualFile file = url == null ? null : VirtualFileManager.getInstance().findFileByUrl(url);
                        messageView.outputJavacMessage(OutputParser.convertCategory(category), strings, file, url, lineNum, columnNum);
                    }
                });
            }

            public void setProgressText(String text) {
            }

            public void fileProcessed(String path) {
            }

            public void fileGenerated(FileObject path) {
            }
        };
        try {
            while (outputParser.processMessageLine(callback)) {
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private static AntBuildMessageView.MessageType convertCategory(CompilerMessageCategory category) {
        if (CompilerMessageCategory.ERROR.equals((Object)category)) {
            return AntBuildMessageView.MessageType.ERROR;
        }
        return AntBuildMessageView.MessageType.MESSAGE;
    }
}

