/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.actions;

import com.intellij.lang.ant.AntSupport;
import com.intellij.lang.ant.config.AntBuildFileBase;
import com.intellij.lang.ant.config.AntBuildListener;
import com.intellij.lang.ant.config.AntConfigurationBase;
import com.intellij.lang.ant.config.execution.ExecutionHandler;
import com.intellij.lang.ant.config.impl.BuildFileProperty;
import com.intellij.lang.ant.dom.AntDomElement;
import com.intellij.lang.ant.dom.AntDomTarget;
import com.intellij.lang.ant.resources.AntActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunTargetAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        Pair<AntBuildFileBase, AntDomTarget> antTarget = RunTargetAction.findAntTarget(e);
        if (antTarget == null) {
            return;
        }
        ExecutionHandler.runBuild((AntBuildFileBase)antTarget.first, new String[]{(String)((AntDomTarget)antTarget.second).getName().getValue()}, null, e.getDataContext(), Collections.<BuildFileProperty>emptyList(), AntBuildListener.NULL);
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        Pair<AntBuildFileBase, AntDomTarget> antTarget = RunTargetAction.findAntTarget(e);
        if (antTarget == null) {
            presentation.setEnabled(false);
            presentation.setText(AntActionsBundle.message("action.RunTargetAction.text", ""));
        } else {
            presentation.setEnabled(true);
            presentation.setText(AntActionsBundle.message("action.RunTargetAction.text", "'" + (String)((AntDomTarget)antTarget.second).getName().getValue() + "'"));
        }
    }

    @Nullable
    private static Pair<AntBuildFileBase, AntDomTarget> findAntTarget(@NotNull AnActionEvent e) {
        AntDomElement dom;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/ant/config/actions/RunTargetAction", "findAntTarget"));
        }
        DataContext dataContext = e.getDataContext();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null || editor == null) {
            return null;
        }
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (file == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (!(psiFile instanceof XmlFile)) {
            return null;
        }
        XmlFile xmlFile = (XmlFile)psiFile;
        AntBuildFileBase antFile = AntConfigurationBase.getInstance(project).getAntBuildFile((PsiFile)xmlFile);
        if (antFile == null) {
            return null;
        }
        PsiElement element = xmlFile.findElementAt(editor.getCaretModel().getOffset());
        if (element == null) {
            return null;
        }
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        if (xmlTag == null) {
            return null;
        }
        for (dom = AntSupport.getAntDomElement(xmlTag); dom != null && !(dom instanceof AntDomTarget); dom = dom.getParent()) {
        }
        AntDomTarget domTarget = (AntDomTarget)dom;
        if (domTarget == null) {
            return null;
        }
        return Pair.create((Object)antFile, (Object)domTarget);
    }
}

