/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.RemovePropertyLocalFix;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.BidirectionalMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InconsistentResourceBundleInspection
extends GlobalSimpleInspectionTool {
    public boolean REPORT_MISSING_TRANSLATIONS = true;
    public boolean REPORT_INCONSISTENT_PROPERTIES = true;
    public boolean REPORT_DUPLICATED_PROPERTIES = true;
    private static final Key<Set<ResourceBundle>> VISITED_BUNDLES_KEY = Key.create((String)"VISITED_BUNDLES_KEY");

    @NotNull
    public String getGroupDisplayName() {
        String string = PropertiesBundle.message((String)"properties.files.inspection.group.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/i18n/InconsistentResourceBundleInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inconsistent.resource.bundle.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/i18n/InconsistentResourceBundleInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("InconsistentResourceBundle" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/i18n/InconsistentResourceBundleInspection", "getShortName"));
        }
        return "InconsistentResourceBundle";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/i18n/InconsistentResourceBundleInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox(InspectionsBundle.message((String)"inconsistent.bundle.report.inconsistent.properties", (Object[])new Object[0]), "REPORT_INCONSISTENT_PROPERTIES");
        panel.addCheckbox(InspectionsBundle.message((String)"inconsistent.bundle.report.missing.translations", (Object[])new Object[0]), "REPORT_MISSING_TRANSLATIONS");
        panel.addCheckbox(InspectionsBundle.message((String)"inconsistent.bundle.report.duplicate.properties.values", (Object[])new Object[0]), "REPORT_DUPLICATED_PROPERTIES");
        return panel;
    }

    public void inspectionStarted(@NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/i18n/InconsistentResourceBundleInspection", "inspectionStarted"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/i18n/InconsistentResourceBundleInspection", "inspectionStarted"));
        }
        if (problemDescriptionsProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInspection/i18n/InconsistentResourceBundleInspection", "inspectionStarted"));
        }
        globalContext.putUserData(VISITED_BUNDLES_KEY, (Object)new THashSet());
    }

    public void checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, @NotNull ProblemsHolder problemsHolder, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/i18n/InconsistentResourceBundleInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/i18n/InconsistentResourceBundleInspection", "checkFile"));
        }
        if (problemsHolder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInspection/i18n/InconsistentResourceBundleInspection", "checkFile"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInspection/i18n/InconsistentResourceBundleInspection", "checkFile"));
        }
        if (problemDescriptionsProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/codeInspection/i18n/InconsistentResourceBundleInspection", "checkFile"));
        }
        Set visitedBundles = (Set)globalContext.getUserData(VISITED_BUNDLES_KEY);
        this.checkFile(file, manager, visitedBundles, globalContext.getRefManager(), problemDescriptionsProcessor);
    }

    private void checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, @NotNull Set<ResourceBundle> visitedBundles, RefManager refManager, ProblemDescriptionsProcessor processor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/i18n/InconsistentResourceBundleInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/i18n/InconsistentResourceBundleInspection", "checkFile"));
        }
        if (visitedBundles == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInspection/i18n/InconsistentResourceBundleInspection", "checkFile"));
        }
        if (!(file instanceof PropertiesFile)) {
            return;
        }
        PropertiesFile propertiesFile = (PropertiesFile)file;
        ResourceBundle resourceBundle = propertiesFile.getResourceBundle();
        if (!visitedBundles.add(resourceBundle)) {
            return;
        }
        List files = resourceBundle.getPropertiesFiles(manager.getProject());
        if (files.size() < 2) {
            return;
        }
        BidirectionalMap parents = new BidirectionalMap();
        for (PropertiesFile f : files) {
            PropertiesFile parent = PropertiesUtil.getParent((PropertiesFile)f, (List)files);
            if (parent == null) continue;
            parents.put((Object)f, (Object)parent);
        }
        THashMap keysUpToParent = new THashMap();
        for (PropertiesFile f : files) {
            THashSet keys = new THashSet(f.getNamesMap().keySet());
            PropertiesFile parent = (PropertiesFile)parents.get((Object)f);
            while (parent != null) {
                keys.addAll(parent.getNamesMap().keySet());
                parent = (PropertiesFile)parents.get((Object)parent);
            }
            keysUpToParent.put(f, keys);
        }
        if (this.REPORT_MISSING_TRANSLATIONS) {
            InconsistentResourceBundleInspection.checkMissingTranslations((BidirectionalMap<PropertiesFile, PropertiesFile>)parents, files, (Map<PropertiesFile, Set<String>>)keysUpToParent, manager, refManager, processor);
        }
        if (this.REPORT_INCONSISTENT_PROPERTIES) {
            InconsistentResourceBundleInspection.checkConsistency((BidirectionalMap<PropertiesFile, PropertiesFile>)parents, files, (Map<PropertiesFile, Set<String>>)keysUpToParent, manager, refManager, processor);
        }
        if (this.REPORT_DUPLICATED_PROPERTIES) {
            InconsistentResourceBundleInspection.checkDuplicatedProperties((BidirectionalMap<PropertiesFile, PropertiesFile>)parents, files, (Map<PropertiesFile, Set<String>>)keysUpToParent, manager, refManager, processor);
        }
    }

    private static void checkDuplicatedProperties(BidirectionalMap<PropertiesFile, PropertiesFile> parents, List<PropertiesFile> files, Map<PropertiesFile, Set<String>> keysUpToParent, InspectionManager manager, RefManager refManager, ProblemDescriptionsProcessor processor) {
        for (PropertiesFile file : files) {
            PropertiesFile parent = (PropertiesFile)parents.get((Object)file);
            if (parent == null) continue;
            Set<String> parentKeys = keysUpToParent.get(parent);
            THashSet overriddenKeys = new THashSet(file.getNamesMap().keySet());
            overriddenKeys.retainAll(parentKeys);
            for (String overriddenKey : overriddenKeys) {
                IProperty property = file.findPropertyByKey(overriddenKey);
                assert (property != null);
                while (parent != null) {
                    IProperty parentProperty = parent.findPropertyByKey(overriddenKey);
                    if (parentProperty != null && Comparing.strEqual((String)property.getValue(), (String)parentProperty.getValue())) {
                        String message = InspectionsBundle.message((String)"inconsistent.bundle.property.inherited.with.the.same.value", (Object[])new Object[]{parent.getName()});
                        ProblemDescriptor descriptor = manager.createProblemDescriptor(property.getPsiElement(), message, (LocalQuickFix)RemovePropertyLocalFix.INSTANCE, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false);
                        processor.addProblemElement((RefEntity)refManager.getReference((PsiElement)file.getContainingFile()), new CommonProblemDescriptor[]{descriptor});
                    }
                    parent = (PropertiesFile)parents.get((Object)parent);
                }
            }
        }
    }

    private static void checkConsistency(BidirectionalMap<PropertiesFile, PropertiesFile> parents, List<PropertiesFile> files, Map<PropertiesFile, Set<String>> keysUpToParent, InspectionManager manager, RefManager refManager, ProblemDescriptionsProcessor processor) {
        for (PropertiesFile file : files) {
            PropertiesFile parent = (PropertiesFile)parents.get((Object)file);
            THashSet parentKeys = keysUpToParent.get(parent);
            if (parent == null) {
                parentKeys = new THashSet();
                for (PropertiesFile otherTopLevelFile : files) {
                    if (otherTopLevelFile == file || parents.get((Object)otherTopLevelFile) != null) continue;
                    parent = otherTopLevelFile;
                    parentKeys.addAll(otherTopLevelFile.getNamesMap().keySet());
                }
                if (parent == null) continue;
            }
            THashSet keys = new THashSet(file.getNamesMap().keySet());
            keys.removeAll((Collection<?>)parentKeys);
            for (String inconsistentKey : keys) {
                IProperty property = file.findPropertyByKey(inconsistentKey);
                assert (property != null);
                String message = InspectionsBundle.message((String)"inconsistent.bundle.property.error", (Object[])new Object[]{inconsistentKey, parent.getName()});
                ProblemDescriptor descriptor = manager.createProblemDescriptor(property.getPsiElement(), message, false, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                processor.addProblemElement((RefEntity)refManager.getReference((PsiElement)file.getContainingFile()), new CommonProblemDescriptor[]{descriptor});
            }
        }
    }

    private static void checkMissingTranslations(BidirectionalMap<PropertiesFile, PropertiesFile> parents, List<PropertiesFile> files, Map<PropertiesFile, Set<String>> keysUpToParent, InspectionManager manager, RefManager refManager, ProblemDescriptionsProcessor processor) {
        for (PropertiesFile file : files) {
            boolean isLeaf;
            PropertiesFile parent = (PropertiesFile)parents.get((Object)file);
            if (parent == null) continue;
            List children = parents.getKeysByValue((Object)file);
            boolean bl = isLeaf = children == null || children.isEmpty();
            if (!isLeaf) continue;
            THashSet keys = file.getNamesMap().keySet();
            THashSet parentKeys = new THashSet((Collection)keysUpToParent.get(parent));
            if (parent.getLocale().getLanguage().equals(file.getLocale().getLanguage())) {
                keys = new THashSet(keys);
                keys.addAll(parent.getNamesMap().keySet());
                parent = (PropertiesFile)parents.get((Object)parent);
                if (parent == null) continue;
                parentKeys = new THashSet((Collection)keysUpToParent.get(parent));
            }
            parentKeys.removeAll((Collection<?>)keys);
            for (String untranslatedKey : parentKeys) {
                IProperty untranslatedProperty = null;
                PropertiesFile untranslatedFile = parent;
                while (untranslatedFile != null && (untranslatedProperty = untranslatedFile.findPropertyByKey(untranslatedKey)) == null) {
                    untranslatedFile = (PropertiesFile)parents.get((Object)untranslatedFile);
                }
                assert (untranslatedProperty != null);
                String message = InspectionsBundle.message((String)"inconsistent.bundle.untranslated.property.error", (Object[])new Object[]{untranslatedKey, file.getName()});
                ProblemDescriptor descriptor = manager.createProblemDescriptor(untranslatedProperty.getPsiElement(), message, false, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                processor.addProblemElement((RefEntity)refManager.getReference((PsiElement)untranslatedFile.getContainingFile()), new CommonProblemDescriptor[]{descriptor});
            }
        }
    }
}

