/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.windows;

import com.pty4j.PtyException;
import com.pty4j.WinSize;
import com.pty4j.util.PtyUtil;
import com.pty4j.windows.NamedPipe;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.nio.Buffer;
import jtermios.windows.WinAPI;

public class WinPty {
    private final winpty_t myWinpty;
    private NamedPipe myNamedPipe;
    private boolean myClosed = false;
    public static final Kern32 KERNEL32 = (Kern32)Native.loadLibrary((String)"kernel32", Kern32.class);
    public static WinPtyLib INSTANCE = (WinPtyLib)Native.loadLibrary((String)WinPty.getLibraryPath(), WinPtyLib.class);

    public WinPty(String cmdline, String cwd, String env) throws PtyException {
        char[] envArray;
        char[] cwdArray;
        int cols = Integer.getInteger("win.pty.cols", 80);
        int rows = Integer.getInteger("win.pty.rows", 25);
        this.myWinpty = INSTANCE.winpty_open(cols, rows);
        if (this.myWinpty == null) {
            throw new PtyException("winpty is null");
        }
        char[] cmdlineArray = cmdline != null ? WinPty.toCharArray(cmdline) : null;
        int c = INSTANCE.winpty_start_process(this.myWinpty, null, cmdlineArray, cwdArray = cwd != null ? WinPty.toCharArray(cwd) : null, envArray = env != null ? WinPty.toCharArray(env) : null);
        if (c != 0) {
            throw new PtyException("Error running process:" + c);
        }
        this.myNamedPipe = new NamedPipe(this.myWinpty.dataPipe);
    }

    private static char[] toCharArray(String string) {
        char[] array = new char[string.length() + 1];
        System.arraycopy(string.toCharArray(), 0, array, 0, string.length());
        array[string.length()] = '\u0000';
        return array;
    }

    public void setWinSize(WinSize winSize) {
        if (this.myClosed) {
            return;
        }
        INSTANCE.winpty_set_size(this.myWinpty, winSize.ws_col, winSize.ws_row);
    }

    public void close() {
        if (this.myClosed) {
            return;
        }
        INSTANCE.winpty_close(this.myWinpty);
        this.myNamedPipe.markClosed();
        this.myClosed = true;
    }

    public int exitValue() {
        if (this.myClosed) {
            return -2;
        }
        return INSTANCE.winpty_get_exit_code(this.myWinpty);
    }

    public int read(byte[] buf, int len) throws IOException {
        if (this.myClosed) {
            return 0;
        }
        return this.myNamedPipe.read(buf, len);
    }

    public int available() throws IOException {
        return this.myNamedPipe.available();
    }

    public void write(byte[] buf, int len) throws IOException {
        if (this.myClosed) {
            return;
        }
        this.myNamedPipe.write(buf, len);
    }

    private static String getLibraryPath() {
        try {
            return PtyUtil.resolveNativeLibrary().getAbsolutePath();
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't detect jar containing folder", e);
        }
    }

    static interface WinPtyLib
    extends Library {
        public winpty_t winpty_open(int var1, int var2);

        public int winpty_start_process(winpty_t var1, char[] var2, char[] var3, char[] var4, char[] var5);

        public int winpty_get_exit_code(winpty_t var1);

        public WinAPI.HANDLE winpty_get_data_pipe(winpty_t var1);

        public int winpty_set_size(winpty_t var1, int var2, int var3);

        public void winpty_close(winpty_t var1);
    }

    static interface Kern32
    extends Library {
        public boolean PeekNamedPipe(WinNT.HANDLE var1, Buffer var2, int var3, IntByReference var4, IntByReference var5, IntByReference var6);

        public boolean ReadFile(WinNT.HANDLE var1, Buffer var2, int var3, IntByReference var4, WinBase.OVERLAPPED var5);
    }

    public static class winpty_t
    extends Structure {
        public WinNT.HANDLE controlPipe;
        public WinNT.HANDLE dataPipe;
        public boolean open;
    }
}

