/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.windows;

import com.pty4j.windows.WinPty;
import java.io.IOException;
import java.io.OutputStream;

public class WinPTYOutputStream
extends OutputStream {
    private final WinPty myWinPty;

    public WinPTYOutputStream(WinPty winPty) {
        this.myWinPty = winPty;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        byte[] tmpBuf = new byte[len];
        System.arraycopy(b, off, tmpBuf, off, len);
        this.myWinPty.write(tmpBuf, len);
    }

    public void write(int b) throws IOException {
        byte[] buf = new byte[]{(byte)b};
        this.write(buf, 0, 1);
    }

    public void close() throws IOException {
        this.myWinPty.close();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

