/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxImportClassFix;

public class JavaFxTagNameReference
extends TagNameReference {
    private static final Logger LOGGER = Logger.getInstance((String)("#" + JavaFxTagNameReference.class.getName()));

    public JavaFxTagNameReference(ASTNode element, boolean startTagFlag) {
        super(element, startTagFlag);
    }

    public TextRange getRangeInElement() {
        TextRange rangeInElement = super.getRangeInElement();
        XmlTag tagElement = this.getTagElement();
        if (tagElement != null) {
            String tagElementName = tagElement.getName();
            int dotIdx = tagElementName.indexOf(".");
            int startOffset = rangeInElement.getStartOffset();
            if (dotIdx > -1 && startOffset + dotIdx + 2 < rangeInElement.getEndOffset()) {
                return new TextRange(startOffset + dotIdx + 1, rangeInElement.getEndOffset());
            }
        }
        return rangeInElement;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        String qualifiedName;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxTagNameReference", "bindToElement"));
        }
        if (element instanceof PsiClass && (qualifiedName = ((PsiClass)element).getQualifiedName()) != null) {
            String shortName = StringUtil.getShortName((String)qualifiedName);
            XmlTag tagElement = this.getTagElement();
            if (tagElement != null) {
                String oldTagName = tagElement.getName();
                if (oldTagName.contains(".")) {
                    return tagElement.setName(qualifiedName);
                }
                return tagElement.setName(shortName);
            }
            return this.getElement();
        }
        return super.bindToElement(element);
    }

    public static class JavaFxUnresolvedTagRefsProvider
    extends UnresolvedReferenceQuickFixProvider<JavaFxTagNameReference> {
        public void registerFixes(@NotNull JavaFxTagNameReference ref, @NotNull QuickFixActionRegistrar registrar) {
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxTagNameReference$JavaFxUnresolvedTagRefsProvider", "registerFixes"));
            }
            if (registrar == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxTagNameReference$JavaFxUnresolvedTagRefsProvider", "registerFixes"));
            }
            XmlTag element = ref.getTagElement();
            if (element != null) {
                registrar.register((IntentionAction)new JavaFxImportClassFix(ref, element){

                    @Override
                    protected XmlTag getTagElement(JavaFxTagNameReference ref) {
                        return ref.getTagElement();
                    }
                });
            }
        }

        @NotNull
        public Class<JavaFxTagNameReference> getReferenceClass() {
            if (JavaFxTagNameReference.class == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxTagNameReference$JavaFxUnresolvedTagRefsProvider", "getReferenceClass"));
            }
            return JavaFxTagNameReference.class;
        }
    }
}

