/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.codeInsight.daemon.impl.quickfix.ImportClassFixBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxTagNameReference;

abstract class JavaFxImportClassFix
extends ImportClassFixBase<XmlTag, JavaFxTagNameReference> {
    public JavaFxImportClassFix(@NotNull JavaFxTagNameReference ref, @NotNull XmlTag element) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxImportClassFix", "<init>"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxImportClassFix", "<init>"));
        }
        super((PsiElement)element, (PsiReference)ref);
    }

    protected abstract XmlTag getTagElement(JavaFxTagNameReference var1);

    @Nullable
    protected String getReferenceName(@NotNull JavaFxTagNameReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxImportClassFix", "getReferenceName"));
        }
        XmlTag tagElement = this.getTagElement(reference);
        return tagElement != null ? tagElement.getName() : null;
    }

    protected PsiElement getReferenceNameElement(@NotNull JavaFxTagNameReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxImportClassFix", "getReferenceNameElement"));
        }
        XmlTag tagElement = this.getTagElement(reference);
        return tagElement != null ? tagElement.getNavigationElement() : null;
    }

    protected void bindReference(PsiReference reference, PsiClass targetClass) {
        PsiFile file = reference.getElement().getContainingFile();
        super.bindReference(reference, targetClass);
        String qualifiedName = targetClass.getQualifiedName();
        if (qualifiedName != null) {
            String shortName = StringUtil.getShortName((String)qualifiedName);
            JavaFxPsiUtil.insertImportWhenNeeded((XmlFile)file, shortName, qualifiedName);
        }
    }

    protected boolean hasTypeParameters(@NotNull JavaFxTagNameReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxImportClassFix", "hasTypeParameters"));
        }
        return false;
    }

    protected boolean isAccessible(PsiMember member, XmlTag reference) {
        return member instanceof PsiClass && JavaFxPsiUtil.isClassAcceptable(reference.getParentTag(), (PsiClass)member) == null;
    }

    protected String getQualifiedName(XmlTag tag) {
        return tag.getDescriptor().getQualifiedName();
    }

    protected boolean isQualified(JavaFxTagNameReference reference) {
        return false;
    }

    protected boolean hasUnresolvedImportWhichCanImport(PsiFile psiFile, String name) {
        return false;
    }

    protected int getStartOffset(XmlTag element, JavaFxTagNameReference ref) {
        return element.getTextOffset() + ref.getRangeInElement().getStartOffset();
    }

    protected int getEndOffset(XmlTag element, JavaFxTagNameReference ref) {
        return element.getTextOffset() + ref.getRangeInElement().getEndOffset();
    }
}

