/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.JavaFxControllerClassIndex;

public class JavaFxControllerFieldSearcher
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    public boolean execute(final @NotNull ReferencesSearch.SearchParameters queryParameters, final @NotNull Processor<PsiReference> consumer) {
        String qualifiedName;
        PsiField field;
        PsiClass containingClass;
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxControllerFieldSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxControllerFieldSearcher", "execute"));
        }
        PsiElement elementToSearch = queryParameters.getElementToSearch();
        if (elementToSearch instanceof PsiField && (containingClass = (field = (PsiField)elementToSearch).getContainingClass()) != null && (qualifiedName = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return containingClass.getQualifiedName();
            }
        })) != null) {
            List<PsiFile> fxmlWithController = JavaFxControllerClassIndex.findFxmlWithController(containingClass.getProject(), qualifiedName);
            final String fieldName = field.getName();
            for (final PsiFile file : fxmlWithController) {
                VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
                SearchScope searchScope = (SearchScope)ApplicationManager.getApplication().runReadAction((Computable)new Computable<SearchScope>(){

                    public SearchScope compute() {
                        return queryParameters.getEffectiveSearchScope();
                    }
                });
                if (searchScope instanceof LocalSearchScope ? !((LocalSearchScope)searchScope).isInScope(virtualFile) : searchScope instanceof GlobalSearchScope && !((GlobalSearchScope)searchScope).contains(virtualFile)) continue;
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        file.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                            public void visitXmlAttributeValue(XmlAttributeValue value) {
                                XmlAttribute attribute;
                                PsiElement parent;
                                PsiElement resolve;
                                PsiReference reference = value.getReference();
                                if (reference != null && (resolve = reference.resolve()) instanceof XmlAttributeValue && (parent = resolve.getParent()) instanceof XmlAttribute && "fx:id".equals((attribute = (XmlAttribute)parent).getName()) && fieldName.equals(attribute.getValue())) {
                                    consumer.process((Object)reference);
                                }
                            }
                        });
                    }
                };
                ApplicationManager.getApplication().runReadAction(runnable);
            }
        }
        return true;
    }
}

