/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.descriptors;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.BasicXmlAttributeDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.JavaFxCommonClassNames;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxClassBackedElementDescriptor;

public class JavaFxPropertyAttributeDescriptor
extends BasicXmlAttributeDescriptor {
    private final String myName;
    private final PsiClass myPsiClass;

    public JavaFxPropertyAttributeDescriptor(String name, PsiClass psiClass) {
        this.myName = name;
        this.myPsiClass = psiClass;
    }

    public PsiClass getPsiClass() {
        return this.myPsiClass;
    }

    public boolean isRequired() {
        return false;
    }

    public boolean isFixed() {
        return false;
    }

    public boolean hasIdType() {
        return false;
    }

    public boolean hasIdRefType() {
        return false;
    }

    @Nullable
    public String getDefaultValue() {
        return null;
    }

    public boolean isEnumerated() {
        return this.getEnumeratedValues() != null;
    }

    @Nullable
    public String[] getEnumeratedValues() {
        PsiClass enumClass = this.getEnum();
        if (enumClass != null) {
            PsiField[] fields = enumClass.getFields();
            ArrayList<String> enumConstants = new ArrayList<String>();
            for (PsiField enumField : fields) {
                if (!this.isConstant(enumField)) continue;
                enumConstants.add(enumField.getName());
            }
            return ArrayUtil.toStringArray(enumConstants);
        }
        String propertyQName = JavaFxPropertyAttributeDescriptor.getBoxedPropertyType(this.getDeclaration());
        if ("java.lang.Float".equals(propertyQName) || "java.lang.Double".equals(propertyQName)) {
            return new String[]{"Infinity", "-Infinity", "NaN", "-NaN"};
        }
        if ("java.lang.Boolean".equals(propertyQName)) {
            return new String[]{"true", "false"};
        }
        return null;
    }

    protected boolean isConstant(PsiField enumField) {
        return enumField instanceof PsiEnumConstant;
    }

    protected PsiClass getEnum() {
        PsiClass aClass = JavaFxPsiUtil.getPropertyClass(this.getDeclaration());
        return aClass != null && aClass.isEnum() ? aClass : null;
    }

    public PsiElement getEnumeratedValueDeclaration(XmlElement xmlElement, String value) {
        PsiClass aClass = this.getEnum();
        if (aClass != null) {
            PsiField fieldByName = aClass.findFieldByName(value, false);
            return fieldByName != null ? fieldByName : aClass.findFieldByName(value.toUpperCase(), false);
        }
        return xmlElement;
    }

    @Nullable
    public String validateValue(XmlElement context, String value) {
        XmlAttributeValue xmlAttributeValue;
        PsiElement parent;
        if (context instanceof XmlAttributeValue && (parent = (xmlAttributeValue = (XmlAttributeValue)context).getParent()) instanceof XmlAttribute) {
            if (JavaFxPsiUtil.checkIfAttributeHandler((XmlAttribute)parent)) {
                if (value.startsWith("#")) {
                    if (JavaFxPsiUtil.getControllerClass(context.getContainingFile()) == null) {
                        return "No controller specified for top level element";
                    }
                } else if (JavaFxPsiUtil.parseInjectedLanguages((XmlFile)context.getContainingFile()).isEmpty()) {
                    return "Page language not specified.";
                }
            } else if ("fx:id".equals(((XmlAttribute)parent).getName())) {
                PsiField fieldByName;
                PsiElement declaration;
                XmlElementDescriptor descriptor;
                XmlTag xmlTag;
                PsiClass controllerClass = JavaFxPsiUtil.getControllerClass(context.getContainingFile());
                if (controllerClass != null && (xmlTag = ((XmlAttribute)parent).getParent()) != null && (descriptor = xmlTag.getDescriptor()) instanceof JavaFxClassBackedElementDescriptor && (declaration = descriptor.getDeclaration()) instanceof PsiClass && (fieldByName = controllerClass.findFieldByName(xmlAttributeValue.getValue(), false)) != null && !InheritanceUtil.isInheritorOrSelf((PsiClass)((PsiClass)declaration), (PsiClass)PsiUtil.resolveClassInType((PsiType)fieldByName.getType()), (boolean)true)) {
                    return "Cannot set " + ((PsiClass)declaration).getQualifiedName() + " to field '" + fieldByName.getName() + "'";
                }
            } else {
                PsiElement declaration;
                String boxedQName;
                XmlAttributeDescriptor attributeDescriptor = ((XmlAttribute)parent).getDescriptor();
                if (attributeDescriptor != null && (boxedQName = JavaFxPropertyAttributeDescriptor.getBoxedPropertyType(declaration = attributeDescriptor.getDeclaration())) != null) {
                    try {
                        Class<?> aClass = Class.forName(boxedQName);
                        Method method = aClass.getMethod("valueOf", String.class);
                        method.invoke(aClass, ((XmlAttributeValue)context).getValue());
                    }
                    catch (InvocationTargetException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof NumberFormatException) {
                            return "Invalid value: unable to coerce to " + boxedQName;
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    private static String getBoxedPropertyType(PsiElement declaration) {
        PsiType attrType = null;
        if (declaration instanceof PsiField) {
            attrType = JavaFxPsiUtil.getWrappedPropertyType((PsiField)declaration, declaration.getProject(), JavaFxCommonClassNames.ourWritableMap);
        } else if (declaration instanceof PsiMethod) {
            PsiParameter[] parameters = ((PsiMethod)declaration).getParameterList().getParameters();
            boolean isStatic = ((PsiMethod)declaration).hasModifierProperty("static");
            if (isStatic && parameters.length == 2 || !isStatic && parameters.length == 1) {
                attrType = parameters[parameters.length - 1].getType();
            }
        }
        String boxedQName = null;
        if (attrType instanceof PsiPrimitiveType) {
            boxedQName = ((PsiPrimitiveType)attrType).getBoxedTypeName();
        } else if (PsiPrimitiveType.getUnboxedType((PsiType)attrType) != null) {
            PsiClass attrClass = PsiUtil.resolveClassInType((PsiType)attrType);
            boxedQName = attrClass != null ? attrClass.getQualifiedName() : null;
        }
        return boxedQName;
    }

    public PsiElement getDeclaration() {
        if (this.myPsiClass != null) {
            PsiField field = this.myPsiClass.findFieldByName(this.myName, true);
            if (field != null) {
                return field;
            }
            return JavaFxPsiUtil.findPropertySetter(this.myName, this.myPsiClass);
        }
        return null;
    }

    public PsiReference[] getValueReferences(XmlElement element, @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/javaFX/fxml/descriptors/JavaFxPropertyAttributeDescriptor", "getValueReferences"));
        }
        return !text.startsWith("${") ? super.getValueReferences(element, text) : PsiReference.EMPTY_ARRAY;
    }

    public String getName(PsiElement context) {
        return this.getName();
    }

    public String getName() {
        return this.myName;
    }

    public void init(PsiElement element) {
    }

    public Object[] getDependences() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }
}

