/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.XmlElementPattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlText;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;

public class ScriptLanguageInjector
implements MultiHostInjector {
    private static final XmlElementPattern.XmlTextPattern SCRIPT_PATTERN = (XmlElementPattern.XmlTextPattern)XmlPatterns.xmlText().withParent((ElementPattern)XmlPatterns.xmlTag().withName("fx:script"));

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/javaFX/fxml/ScriptLanguageInjector", "getLanguagesToInject"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/javaFX/fxml/ScriptLanguageInjector", "getLanguagesToInject"));
        }
        if (SCRIPT_PATTERN.accepts((Object)host)) {
            List<String> registeredLanguages = JavaFxPsiUtil.parseInjectedLanguages((XmlFile)host.getContainingFile());
            block0: for (Language language : Language.getRegisteredLanguages()) {
                for (String registeredLanguage : registeredLanguages) {
                    if (!StringUtil.equalsIgnoreCase((CharSequence)language.getID(), (CharSequence)registeredLanguage)) continue;
                    registrar.startInjecting(language).addPlace(null, null, (PsiLanguageInjectionHost)host, TextRange.from((int)0, (int)(host.getTextLength() - 1))).doneInjecting();
                    continue block0;
                }
            }
        }
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<XmlText>> list = Collections.singletonList(XmlText.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/ScriptLanguageInjector", "elementsToInjectIn"));
        }
        return list;
    }
}

