/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProcessingInstruction;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.Processor;
import com.intellij.xml.XmlElementDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxClassBackedElementDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxDefaultPropertyElementDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxPropertyElementDescriptor;

public class JavaFxPsiUtil {
    private static final Logger LOG = Logger.getInstance((String)("#" + JavaFxPsiUtil.class.getName()));
    private static final Key<CachedValue<PsiClass>> INJECTED_CONTROLLER = Key.create((String)"javafx.injected.controller");
    private static final RecursionGuard ourGuard = RecursionManager.createGuard((String)"javafx.controller");

    public static XmlProcessingInstruction createSingleImportInstruction(String qualifiedName, Project project) {
        String importText = "<?import " + qualifiedName + "?>";
        PsiElement child = PsiFileFactory.getInstance((Project)project).createFileFromText("a.fxml", (Language)XMLLanguage.INSTANCE, (CharSequence)importText).getFirstChild();
        return (XmlProcessingInstruction)PsiTreeUtil.findChildOfType((PsiElement)child, XmlProcessingInstruction.class);
    }

    public static List<String> parseImports(XmlFile file) {
        return JavaFxPsiUtil.parseInstructions(file, "import");
    }

    public static List<String> parseInjectedLanguages(XmlFile file) {
        return JavaFxPsiUtil.parseInstructions(file, "language");
    }

    private static List<String> parseInstructions(XmlFile file, String instructionName) {
        ArrayList<String> definedImports = new ArrayList<String>();
        XmlDocument document = file.getDocument();
        if (document != null) {
            XmlProlog prolog = document.getProlog();
            ArrayList instructions = new ArrayList(PsiTreeUtil.findChildrenOfType((PsiElement)prolog, XmlProcessingInstruction.class));
            for (XmlProcessingInstruction instruction : instructions) {
                String instructionTarget = JavaFxPsiUtil.getInstructionTarget(instructionName, instruction);
                if (instructionTarget == null) continue;
                definedImports.add(instructionTarget);
            }
        }
        return definedImports;
    }

    @Nullable
    public static String getInstructionTarget(String instructionName, XmlProcessingInstruction instruction) {
        ASTNode node = instruction.getNode();
        ASTNode xmlNameNode = node.findChildByType(XmlTokenType.XML_NAME);
        ASTNode importNode = node.findChildByType(XmlTokenType.XML_TAG_CHARACTERS);
        if (xmlNameNode != null && instructionName.equals(xmlNameNode.getText()) && importNode != null) {
            return importNode.getText();
        }
        return null;
    }

    public static PsiClass findPsiClass(String name, XmlTag tag) {
        Project project = tag.getProject();
        if (!StringUtil.getShortName((String)name).equals(name)) {
            return JavaPsiFacade.getInstance((Project)project).findClass(name, GlobalSearchScope.allScope((Project)project));
        }
        return JavaFxPsiUtil.findPsiClass(name, JavaFxPsiUtil.parseImports((XmlFile)tag.getContainingFile()), tag, project);
    }

    private static PsiClass findPsiClass(String name, List<String> imports, XmlTag tag, Project project) {
        PsiClass psiClass = null;
        if (imports != null) {
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiFile file = tag.getContainingFile();
            for (String anImport : imports) {
                if (StringUtil.getShortName((String)anImport).equals(name)) {
                    psiClass = psiFacade.findClass(anImport, file.getResolveScope());
                } else if (StringUtil.endsWith((CharSequence)anImport, (CharSequence)".*")) {
                    psiClass = psiFacade.findClass(StringUtil.trimEnd((String)anImport, (String)"*") + name, file.getResolveScope());
                }
                if (psiClass == null) continue;
                return psiClass;
            }
        }
        return psiClass;
    }

    public static void insertImportWhenNeeded(XmlFile xmlFile, String shortName, String qualifiedName) {
        XmlDocument document;
        if (shortName != null && JavaFxPsiUtil.findPsiClass(shortName, xmlFile.getRootTag()) == null && (document = xmlFile.getDocument()) != null) {
            XmlProcessingInstruction processingInstruction = JavaFxPsiUtil.createSingleImportInstruction(qualifiedName, xmlFile.getProject());
            XmlProlog prolog = document.getProlog();
            if (prolog != null) {
                prolog.add((PsiElement)processingInstruction);
            } else {
                document.addBefore((PsiElement)processingInstruction, (PsiElement)document.getRootTag());
            }
            PostprocessReformattingAspect.getInstance((Project)xmlFile.getProject()).doPostponedFormatting(xmlFile.getViewProvider());
        }
    }

    public static PsiClass getPropertyClass(PsiElement field) {
        PsiClassType classType = JavaFxPsiUtil.getPropertyClassType(field);
        return classType != null ? classType.resolve() : null;
    }

    public static PsiClassType getPropertyClassType(PsiElement field) {
        return JavaFxPsiUtil.getPropertyClassType(field, "javafx.beans.property.ObjectProperty");
    }

    public static PsiClassType getPropertyClassType(PsiElement field, String superTypeFQN) {
        PsiClass objectProperty;
        PsiClassType.ClassResolveResult resolveResult;
        PsiClass attributeClass;
        PsiType type;
        if (field instanceof PsiMember && (type = PropertyUtil.getPropertyType((PsiMember)((PsiMember)field))) instanceof PsiClassType && (attributeClass = (resolveResult = ((PsiClassType)type).resolveGenerics()).getElement()) != null && (objectProperty = JavaPsiFacade.getInstance((Project)attributeClass.getProject()).findClass(superTypeFQN, attributeClass.getResolveScope())) != null) {
            PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)objectProperty, (PsiClass)attributeClass, (PsiSubstitutor)resolveResult.getSubstitutor());
            if (superClassSubstitutor != null) {
                PsiType propertyType = superClassSubstitutor.substitute(objectProperty.getTypeParameters()[0]);
                if (propertyType instanceof PsiClassType) {
                    return (PsiClassType)propertyType;
                }
            } else {
                return (PsiClassType)type;
            }
        }
        return null;
    }

    public static PsiMethod findPropertySetter(String attributeName, XmlTag context) {
        PsiClass classWithStaticProperty;
        String packageName = StringUtil.getPackageName((String)attributeName);
        if (context != null && !StringUtil.isEmptyOrSpaces((String)packageName) && (classWithStaticProperty = JavaFxPsiUtil.findPsiClass(packageName, context)) != null) {
            return JavaFxPsiUtil.findPropertySetter(attributeName, classWithStaticProperty);
        }
        return null;
    }

    public static PsiMethod findPropertySetter(String attributeName, PsiClass classWithStaticProperty) {
        String setterName = PropertyUtil.suggestSetterName((String)StringUtil.getShortName((String)attributeName));
        PsiMethod[] setters = classWithStaticProperty.findMethodsByName(setterName, true);
        if (setters.length >= 1) {
            return setters[0];
        }
        return null;
    }

    public static PsiMethod findPropertyGetter(String attributeName, PsiClass classWithStaticProperty) {
        PsiMethod getter = JavaFxPsiUtil.findPropertyGetter(attributeName, classWithStaticProperty, null);
        if (getter != null) {
            return getter;
        }
        return JavaFxPsiUtil.findPropertyGetter(attributeName, classWithStaticProperty, (PsiType)PsiType.BOOLEAN);
    }

    private static PsiMethod findPropertyGetter(String attributeName, PsiClass classWithStaticProperty, PsiType propertyType) {
        String getterName = PropertyUtil.suggestGetterName((String)StringUtil.getShortName((String)attributeName), (PsiType)propertyType);
        PsiMethod[] getters = classWithStaticProperty.findMethodsByName(getterName, true);
        if (getters.length >= 1) {
            return getters[0];
        }
        return null;
    }

    public static PsiClass getControllerClass(final PsiFile containingFile) {
        if (containingFile instanceof XmlFile) {
            XmlAttribute rootTypeAttr;
            PsiClass controllerClass;
            XmlAttribute attribute;
            XmlTag rootTag = ((XmlFile)containingFile).getRootTag();
            Project project = containingFile.getProject();
            if (rootTag != null && (attribute = rootTag.getAttribute("fx:controller")) != null && (controllerClass = JavaFxPsiUtil.findControllerClass(containingFile, project, attribute)) != null) {
                return controllerClass;
            }
            final CachedValuesManager manager = CachedValuesManager.getManager((Project)containingFile.getProject());
            PsiClass injectedControllerClass = (PsiClass)ourGuard.doPreventingRecursion((Object)containingFile, true, (Computable)new Computable<PsiClass>(){

                public PsiClass compute() {
                    return (PsiClass)manager.getCachedValue((UserDataHolder)containingFile, INJECTED_CONTROLLER, (CachedValueProvider)new JavaFxControllerCachedValueProvider(containingFile.getProject(), containingFile), true);
                }
            });
            if (injectedControllerClass != null) {
                return injectedControllerClass;
            }
            if (rootTag != null && "fx:root".equals(rootTag.getName()) && (rootTypeAttr = rootTag.getAttribute("type")) != null) {
                return JavaFxPsiUtil.findControllerClass(containingFile, project, rootTypeAttr);
            }
        }
        return null;
    }

    private static PsiClass findControllerClass(PsiFile containingFile, Project project, XmlAttribute attribute) {
        String attributeValue = attribute.getValue();
        if (!StringUtil.isEmptyOrSpaces((String)attributeValue)) {
            GlobalSearchScope customScope = GlobalSearchScope.projectScope((Project)project).intersectWith(containingFile.getResolveScope());
            return JavaPsiFacade.getInstance((Project)project).findClass(attributeValue, customScope);
        }
        return null;
    }

    public static boolean checkIfAttributeHandler(XmlAttribute attribute) {
        String attributeName = attribute.getName();
        XmlTag xmlTag = attribute.getParent();
        XmlElementDescriptor descriptor = xmlTag.getDescriptor();
        if (descriptor == null) {
            return false;
        }
        PsiElement currentTagClass = descriptor.getDeclaration();
        if (!(currentTagClass instanceof PsiClass)) {
            return false;
        }
        PsiField handlerField = ((PsiClass)currentTagClass).findFieldByName(attributeName, true);
        if (handlerField == null) {
            return false;
        }
        PsiClass objectPropertyClass = JavaFxPsiUtil.getPropertyClass((PsiElement)handlerField);
        return objectPropertyClass != null && InheritanceUtil.isInheritor((PsiClass)objectPropertyClass, (String)"javafx.event.EventHandler");
    }

    @Nullable
    public static PsiClass getTagClass(XmlAttributeValue xmlAttributeValue) {
        if (xmlAttributeValue == null) {
            return null;
        }
        PsiElement xmlAttribute = xmlAttributeValue.getParent();
        XmlTag xmlTag = ((XmlAttribute)xmlAttribute).getParent();
        if (xmlTag != null) {
            return JavaFxPsiUtil.getTagClass(xmlTag);
        }
        return null;
    }

    public static PsiClass getTagClass(XmlTag xmlTag) {
        PsiElement declaration;
        XmlElementDescriptor descriptor = xmlTag.getDescriptor();
        if (descriptor != null && (declaration = descriptor.getDeclaration()) instanceof PsiClass) {
            return (PsiClass)declaration;
        }
        return null;
    }

    public static boolean isVisibleInFxml(PsiMember psiMember) {
        return psiMember.hasModifierProperty("public") || AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMember, (String)"javafx.fxml.FXML", (boolean)false);
    }

    public static PsiMethod findValueOfMethod(@NotNull PsiClass tagClass) {
        PsiMethod[] methods;
        if (tagClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "findValueOfMethod"));
        }
        for (PsiMethod method : methods = tagClass.findMethodsByName("valueOf", false)) {
            PsiType type;
            PsiParameter[] parameters;
            if (!method.hasModifierProperty("static") || (parameters = method.getParameterList().getParameters()).length != 1 || !(type = parameters[0].getType()).equalsToText("java.lang.String") && !type.equalsToText("java.lang.Object") || !method.hasModifierProperty("static") || !tagClass.equals(PsiUtil.resolveClassInType((PsiType)method.getReturnType()))) continue;
            return method;
        }
        return null;
    }

    public static boolean isReadOnly(String attributeName, XmlTag tag) {
        PsiClass psiClass;
        PsiField psiField;
        PsiElement declaration;
        XmlElementDescriptor descriptor = tag.getDescriptor();
        if (descriptor != null && (declaration = descriptor.getDeclaration()) instanceof PsiClass && (psiField = (psiClass = (PsiClass)declaration).findFieldByName(attributeName, true)) != null) {
            return JavaFxPsiUtil.isReadOnly(psiClass, psiField);
        }
        return false;
    }

    public static boolean isReadOnly(PsiClass psiClass, PsiField psiField) {
        String name = psiField.getName();
        if (JavaFxPsiUtil.findPropertySetter(name, psiClass) == null && !InheritanceUtil.isInheritor((PsiType)psiField.getType(), (String)"javafx.collections.ObservableList")) {
            PsiMethod[] constructors;
            for (PsiMethod constructor : constructors = psiClass.getConstructors()) {
                for (PsiParameter parameter : constructor.getParameterList().getParameters()) {
                    if (!psiField.getType().equals(parameter.getType())) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean isExpressionBinding(String value) {
        if (!value.startsWith("$")) {
            return false;
        }
        return (value = value.substring(1)).startsWith("{") && value.endsWith("}") && value.contains(".");
    }

    @Nullable
    public static PsiType getPropertyType(PsiType type, Project project) {
        PsiSubstitutor substitutor;
        PsiClass propertyClass;
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)type);
        PsiClass psiClass = resolveResult.getElement();
        if (psiClass != null && (propertyClass = JavaPsiFacade.getInstance((Project)project).findClass("javafx.beans.property.Property", GlobalSearchScope.allScope((Project)project))) != null && (substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)propertyClass, (PsiClass)psiClass, (PsiSubstitutor)resolveResult.getSubstitutor())) != null) {
            return substitutor.substitute(propertyClass.getTypeParameters()[0]);
        }
        return null;
    }

    public static PsiType getDefaultPropertyExpectedType(PsiClass aClass) {
        String propertyName;
        PsiMethod getter;
        PsiAnnotationMemberValue memberValue;
        PsiAnnotation annotation = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)aClass, Collections.singleton("javafx.beans.DefaultProperty"));
        if (annotation != null && (memberValue = annotation.findAttributeValue(null)) != null && (getter = JavaFxPsiUtil.findPropertyGetter(propertyName = StringUtil.stripQuotesAroundValue((String)memberValue.getText()), aClass)) != null) {
            return getter.getReturnType();
        }
        return null;
    }

    public static String getDefaultPropertyName(PsiClass aClass) {
        PsiAnnotationMemberValue memberValue;
        PsiAnnotation annotation = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)aClass, Collections.singleton("javafx.beans.DefaultProperty"));
        if (annotation != null && (memberValue = annotation.findAttributeValue(null)) != null) {
            return StringUtil.stripQuotesAroundValue((String)memberValue.getText());
        }
        return null;
    }

    public static String isAbleToInstantiate(PsiClass psiClass) {
        if (psiClass.getConstructors().length > 0) {
            for (PsiMethod constr : psiClass.getConstructors()) {
                if (constr.getParameterList().getParametersCount() != 0) continue;
                return null;
            }
            PsiMethod valueOf = JavaFxPsiUtil.findValueOfMethod(psiClass);
            if (valueOf == null && !JavaFxPsiUtil.hasBuilder(psiClass)) {
                return "Unable to instantiate";
            }
        }
        return null;
    }

    public static boolean hasBuilder(final @NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "hasBuilder"));
        }
        final Project project = psiClass.getProject();
        CachedValuesManager.getManager((Project)project);
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiClass, (CachedValueProvider)new CachedValueProvider<Boolean>(){

            @Nullable
            public CachedValueProvider.Result<Boolean> compute() {
                PsiMethod[] buildMethods;
                PsiClass builderClass = JavaPsiFacade.getInstance((Project)project).findClass("javafx.util.Builder", GlobalSearchScope.allScope((Project)project));
                if (builderClass != null && (buildMethods = builderClass.findMethodsByName("build", false)).length == 1 && buildMethods[0].getParameterList().getParametersCount() == 0 && ClassInheritorsSearch.search((PsiClass)builderClass).forEach((Processor)new Processor<PsiClass>(){

                    public boolean process(PsiClass aClass) {
                        PsiType returnType = null;
                        PsiMethod method = MethodSignatureUtil.findMethodBySuperMethod((PsiClass)aClass, (PsiMethod)buildMethods[0], (boolean)false);
                        if (method != null) {
                            returnType = method.getReturnType();
                        }
                        return !Comparing.equal((Object)psiClass, (Object)PsiUtil.resolveClassInClassTypeOnly((PsiType)returnType));
                    }
                })) {
                    return CachedValueProvider.Result.create((Object)false, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
                }
                return CachedValueProvider.Result.create((Object)true, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
        });
    }

    public static String isClassAcceptable(@Nullable XmlTag parentTag, PsiClass aClass) {
        if (parentTag == null) {
            return null;
        }
        if (aClass != null && aClass.isValid()) {
            PsiType type;
            PsiElement declaration;
            XmlElementDescriptor descriptor = parentTag.getDescriptor();
            if (descriptor instanceof JavaFxDefaultPropertyElementDescriptor) {
                descriptor = ((JavaFxDefaultPropertyElementDescriptor)descriptor).getRootTagDescriptor(parentTag);
            }
            if (descriptor instanceof JavaFxPropertyElementDescriptor) {
                PsiElement declaration2 = descriptor.getDeclaration();
                if (declaration2 instanceof PsiField) {
                    return JavaFxPsiUtil.canCoerce(aClass, ((PsiField)declaration2).getType());
                }
            } else if (descriptor instanceof JavaFxClassBackedElementDescriptor && (declaration = descriptor.getDeclaration()) instanceof PsiClass && (type = JavaFxPsiUtil.getDefaultPropertyExpectedType((PsiClass)declaration)) != null) {
                return JavaFxPsiUtil.canCoerce(aClass, type);
            }
        }
        return null;
    }

    private static String canCoerce(PsiClass aClass, PsiType type) {
        String qualifiedName;
        PsiClass baseClass;
        PsiType collectionItemType = JavaGenericsUtil.getCollectionItemType((PsiType)type, (GlobalSearchScope)aClass.getResolveScope());
        if (collectionItemType == null && InheritanceUtil.isInheritor((PsiType)type, (String)"javafx.beans.property.Property")) {
            collectionItemType = JavaFxPsiUtil.getPropertyType(type, aClass.getProject());
        }
        if (collectionItemType != null && PsiPrimitiveType.getUnboxedType((PsiType)collectionItemType) == null && (baseClass = PsiUtil.resolveClassInType((PsiType)collectionItemType)) != null && (qualifiedName = baseClass.getQualifiedName()) != null && !Comparing.strEqual((String)qualifiedName, (String)"java.lang.String") && !InheritanceUtil.isInheritor((PsiClass)aClass, (String)qualifiedName)) {
            return JavaFxPsiUtil.unableToCoerceMessage(aClass, qualifiedName);
        }
        return null;
    }

    private static String unableToCoerceMessage(PsiClass aClass, String qualifiedName) {
        return "Unable to coerce " + HighlightUtil.formatClass((PsiClass)aClass) + " to " + qualifiedName;
    }

    public static boolean isOutOfHierarchy(XmlAttributeValue element) {
        for (XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class); tag != null; tag = tag.getParentTag()) {
            if (!"fx:define".equals(tag.getName())) continue;
            return true;
        }
        return false;
    }

    public static PsiType getWrappedPropertyType(PsiField field, final Project project, final Map<String, PsiType> typeMap) {
        final PsiType fieldType = field.getType();
        final PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)fieldType);
        final PsiClass fieldClass = resolveResult.getElement();
        if (fieldClass == null) {
            return fieldType;
        }
        CachedValuesManager.getManager((Project)project);
        return (PsiType)CachedValuesManager.getCachedValue((PsiElement)field, (CachedValueProvider)new CachedValueProvider<PsiType>(){

            @Nullable
            public CachedValueProvider.Result<PsiType> compute() {
                PsiType substitute = null;
                for (String typeName : typeMap.keySet()) {
                    if (!InheritanceUtil.isInheritor((PsiType)fieldType, (String)typeName)) continue;
                    substitute = (PsiType)typeMap.get(typeName);
                    break;
                }
                if (substitute == null) {
                    if (!InheritanceUtil.isInheritor((PsiType)fieldType, (String)"javafx.beans.value.ObservableValue")) {
                        return CachedValueProvider.Result.create((Object)fieldType, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
                    }
                    PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass("javafx.beans.value.ObservableValue", GlobalSearchScope.allScope((Project)project));
                    LOG.assertTrue(aClass != null);
                    PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)aClass, (PsiClass)fieldClass, (PsiSubstitutor)resolveResult.getSubstitutor());
                    PsiMethod[] values = aClass.findMethodsByName("getValue", false);
                    substitute = substitutor.substitute(values[0].getReturnType());
                }
                return CachedValueProvider.Result.create(substitute, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
        });
    }

    private static class JavaFxControllerCachedValueProvider
    implements CachedValueProvider<PsiClass> {
        private final Project myProject;
        private final PsiFile myContainingFile;

        public JavaFxControllerCachedValueProvider(Project project, PsiFile containingFile) {
            this.myProject = project;
            this.myContainingFile = containingFile;
        }

        @Nullable
        public CachedValueProvider.Result<PsiClass> compute() {
            PsiMethod[] injectControllerMethods;
            final Ref injectedController = new Ref();
            final Ref dep = new Ref();
            PsiClass fxmlLoader = JavaPsiFacade.getInstance((Project)this.myProject).findClass("javafx.fxml.FXMLLoader", GlobalSearchScope.allScope((Project)this.myProject));
            if (fxmlLoader != null && (injectControllerMethods = fxmlLoader.findMethodsByName("setController", false)).length == 1) {
                final JavaFxRetrieveControllerProcessor processor = new JavaFxRetrieveControllerProcessor(){

                    @Override
                    protected boolean isResolveToSetter(PsiMethodCallExpression methodCallExpression) {
                        return methodCallExpression.resolveMethod() == injectControllerMethods[0];
                    }
                };
                GlobalSearchScope globalSearchScope = GlobalSearchScope.notScope((GlobalSearchScope)GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)this.myContainingFile.getResolveScope(), (FileType[])new FileType[]{StdFileTypes.XML}));
                ReferencesSearch.search((PsiElement)this.myContainingFile, (SearchScope)globalSearchScope).forEach((Processor)new Processor<PsiReference>(){

                    public boolean process(PsiReference reference) {
                        PsiElement parent;
                        PsiType type;
                        PsiNewExpression expression;
                        PsiElement element = reference.getElement();
                        if (element instanceof PsiLiteralExpression && (expression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiNewExpression.class)) != null && (type = expression.getType()) != null && type.equalsToText("javafx.fxml.FXMLLoader") && (parent = expression.getParent()) instanceof PsiLocalVariable) {
                            ReferencesSearch.search((PsiElement)parent).forEach((Processor)processor);
                            PsiClass controller = processor.getInjectedController();
                            if (controller != null) {
                                injectedController.set((Object)controller);
                                dep.set((Object)processor.getContainingFile());
                                return false;
                            }
                        }
                        return true;
                    }
                });
            }
            return new CachedValueProvider.Result(injectedController.get(), new Object[]{dep.get() != null ? dep.get() : PsiModificationTracker.MODIFICATION_COUNT});
        }

        private static abstract class JavaFxRetrieveControllerProcessor
        implements Processor<PsiReference> {
            private final Ref<PsiClass> myInjectedController = new Ref();
            private final Ref<PsiFile> myContainingFile = new Ref();

            private JavaFxRetrieveControllerProcessor() {
            }

            protected abstract boolean isResolveToSetter(PsiMethodCallExpression var1);

            public boolean process(PsiReference reference) {
                PsiClass psiClass;
                PsiExpression[] expressions;
                PsiMethodCallExpression methodCallExpression;
                PsiElement element = reference.getElement();
                if (element instanceof PsiReferenceExpression && (methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class)) != null && this.isResolveToSetter(methodCallExpression) && (expressions = methodCallExpression.getArgumentList().getExpressions()).length > 0 && (psiClass = PsiUtil.resolveClassInType((PsiType)expressions[0].getType())) != null) {
                    this.myInjectedController.set((Object)psiClass);
                    this.myContainingFile.set((Object)methodCallExpression.getContainingFile());
                    return false;
                }
                return true;
            }

            private PsiClass getInjectedController() {
                return (PsiClass)this.myInjectedController.get();
            }

            private PsiFile getContainingFile() {
                return (PsiFile)this.myContainingFile.get();
            }
        }
    }
}

