/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.junit;

import com.intellij.rt.execution.junit.ForkedVMWrapper;
import com.intellij.rt.execution.junit.IdeaTestRunner;
import com.intellij.rt.execution.junit.JUnitStarter;
import com.intellij.rt.execution.junit.ProcessBuilder;
import com.intellij.rt.execution.junit.TimeSender;
import com.intellij.rt.execution.junit.TreeSender;
import com.intellij.rt.execution.junit.segments.SegmentedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JUnitForkedStarter {
    static /* synthetic */ Class class$com$intellij$rt$execution$junit$JUnitForkedStarter;

    private JUnitForkedStarter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String testOutputPath = args[0];
        int lastIdx = Integer.parseInt(args[1]);
        boolean isJUnit4 = args[2].equalsIgnoreCase("true");
        String[] childTestDescription = new String[]{args[3]};
        ArrayList<String> listeners = new ArrayList<String>();
        int argsLength = args.length;
        for (int i = 4; i < argsLength; ++i) {
            listeners.add(args[i]);
        }
        File file = new File(testOutputPath);
        if (!file.exists() && !file.createNewFile()) {
            return;
        }
        FileOutputStream stream = new FileOutputStream(testOutputPath);
        PrintStream oldOut = System.out;
        PrintStream oldErr = System.err;
        try {
            PrintStream out = new PrintStream(new ForkedVMWrapper(stream, false));
            PrintStream err = new PrintStream(new ForkedVMWrapper(stream, true));
            System.setOut(out);
            System.setErr(err);
            IdeaTestRunner testRunner = (IdeaTestRunner)JUnitStarter.getAgentClass(isJUnit4).newInstance();
            testRunner.setStreams(new SegmentedOutputStream(out, true), new SegmentedOutputStream(err, true), lastIdx);
            System.exit(testRunner.startRunnerWithArgs(childTestDescription, listeners, null, false));
        }
        finally {
            System.setOut(oldOut);
            System.setErr(oldErr);
            stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int startForkedVMs(String workingDirsPath, String[] args, boolean isJUnit4, List listeners, String params, SegmentedOutputStream out, SegmentedOutputStream err, String forkMode, String path) throws Exception {
        int result;
        long time;
        IdeaTestRunner testRunner;
        block21: {
            Object description;
            ArrayList<String> parameters;
            block22: {
                parameters = new ArrayList<String>();
                BufferedReader bufferedReader = new BufferedReader(new FileReader(path));
                try {
                    String line;
                    while ((line = bufferedReader.readLine()) != null) {
                        parameters.add(line);
                    }
                }
                finally {
                    bufferedReader.close();
                }
                testRunner = (IdeaTestRunner)JUnitStarter.getAgentClass(isJUnit4).newInstance();
                testRunner.setStreams(out, err, 0);
                description = testRunner.getTestToStart(args, params);
                if (description == null) {
                    return -1;
                }
                TreeSender.sendTree(testRunner, description, true);
                time = System.currentTimeMillis();
                result = 0;
                if (workingDirsPath != null && new File(workingDirsPath).length() != 0L) break block22;
                List children = testRunner.getChildTests(description);
                boolean forkTillMethod = forkMode.equalsIgnoreCase("method");
                result = JUnitForkedStarter.processChildren(isJUnit4, listeners, out, err, parameters, testRunner, children, 0, forkTillMethod, null);
                break block21;
            }
            BufferedReader perDirReader = new BufferedReader(new FileReader(workingDirsPath));
            try {
                String workingDir;
                String packageName = perDirReader.readLine();
                while ((workingDir = perDirReader.readLine()) != null) {
                    try {
                        int childResult;
                        block25: {
                            File dir;
                            ArrayList<String> classNames;
                            block23: {
                                Object rootDescriptor;
                                File tempFile;
                                block24: {
                                    tempFile = File.createTempFile("idea_junit", ".tmp");
                                    tempFile.deleteOnExit();
                                    FileOutputStream writer = new FileOutputStream(tempFile);
                                    classNames = new ArrayList<String>();
                                    int classNamesSize = Integer.parseInt(perDirReader.readLine());
                                    writer.write((packageName + ", working directory: '" + workingDir + "'\n").getBytes("UTF-8"));
                                    for (int i = 0; i < classNamesSize; ++i) {
                                        String className = perDirReader.readLine();
                                        if (className == null) {
                                            System.err.println("Class name is expected. Working dir: " + workingDir);
                                            int n = -1;
                                            return n;
                                        }
                                        classNames.add(className);
                                        writer.write((className + "\n").getBytes("UTF-8"));
                                    }
                                    rootDescriptor = JUnitForkedStarter.findByClassName(testRunner, (String)classNames.get(0), description);
                                    dir = new File(workingDir);
                                    if (!forkMode.equals("none")) break block23;
                                    break block24;
                                    finally {
                                        writer.close();
                                    }
                                }
                                childResult = JUnitForkedStarter.runChild(isJUnit4, listeners, out, err, parameters, "@" + tempFile.getAbsolutePath(), dir, String.valueOf(testRunner.getRegistry().getKnownObject(rootDescriptor) - 1));
                                break block25;
                            }
                            ArrayList children = new ArrayList(testRunner.getChildTests(description));
                            Iterator iterator = children.iterator();
                            while (iterator.hasNext()) {
                                if (classNames.contains(testRunner.getTestClassName(iterator.next()))) continue;
                                iterator.remove();
                            }
                            boolean forkTillMethod = forkMode.equalsIgnoreCase("method");
                            childResult = JUnitForkedStarter.processChildren(isJUnit4, listeners, out, err, parameters, testRunner, children, result, forkTillMethod, dir);
                        }
                        result = Math.min(childResult, result);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                perDirReader.close();
            }
        }
        time = System.currentTimeMillis() - time;
        new TimeSender(testRunner.getRegistry()).printHeader(time);
        return result;
    }

    private static Object findByClassName(IdeaTestRunner testRunner, String className, Object rootDescription) {
        int i;
        List children = testRunner.getChildTests(rootDescription);
        for (i = 0; i < children.size(); ++i) {
            Object child = children.get(i);
            if (!className.equals(testRunner.getTestClassName(child))) continue;
            return child;
        }
        for (i = 0; i < children.size(); ++i) {
            Object byName = JUnitForkedStarter.findByClassName(testRunner, className, children.get(i));
            if (byName == null) continue;
            return byName;
        }
        return null;
    }

    private static int processChildren(boolean isJUnit4, List listeners, SegmentedOutputStream out, SegmentedOutputStream err, List parameters, IdeaTestRunner testRunner, List children, int result, boolean forkTillMethod, File workingDir) throws IOException, InterruptedException {
        int argsLength = children.size();
        for (int i = 0; i < argsLength; ++i) {
            int childResult;
            Object child = children.get(i);
            List childTests = testRunner.getChildTests(child);
            if (childTests.isEmpty() || !forkTillMethod) {
                int startIndex = testRunner.getRegistry().getKnownObject(child);
                childResult = JUnitForkedStarter.runChild(isJUnit4, listeners, out, err, parameters, testRunner.getStartDescription(child), workingDir, String.valueOf(startIndex));
            } else {
                childResult = JUnitForkedStarter.processChildren(isJUnit4, listeners, out, err, parameters, testRunner, childTests, result, forkTillMethod, workingDir);
            }
            result = Math.min(childResult, result);
        }
        return result;
    }

    private static int runChild(boolean isJUnit4, List listeners, SegmentedOutputStream out, SegmentedOutputStream err, List parameters, String description, File workingDir, String startIndex) throws IOException, InterruptedException {
        File tempFile = File.createTempFile("fork", "test");
        String testOutputPath = tempFile.getAbsolutePath();
        ProcessBuilder builder = new ProcessBuilder();
        builder.add(parameters);
        builder.add((class$com$intellij$rt$execution$junit$JUnitForkedStarter == null ? (class$com$intellij$rt$execution$junit$JUnitForkedStarter = JUnitForkedStarter.class$("com.intellij.rt.execution.junit.JUnitForkedStarter")) : class$com$intellij$rt$execution$junit$JUnitForkedStarter).getName());
        builder.add(testOutputPath);
        builder.add(startIndex);
        builder.add(String.valueOf(isJUnit4));
        builder.add(description);
        builder.add(listeners);
        builder.setWorkingDir(workingDir);
        Process exec = builder.createProcess();
        int result = exec.waitFor();
        ForkedVMWrapper.readWrapped(testOutputPath, out.getPrintStream(), err.getPrintStream());
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

