/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit4;

import com.intellij.junit3.TestRunnerUtil;
import com.intellij.junit4.JUnit45ClassesRequestBuilder;
import com.intellij.junit4.JUnit46ClassesRequestBuilder;
import com.intellij.junit4.JUnit4ClassesRequestBuilder;
import com.intellij.junit4.JUnit4ReflectionUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.requests.ClassRequest;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Parameterized;
import org.junit.runners.model.FrameworkMethod;

public class JUnit4TestRunnerUtil {
    private static final ResourceBundle ourBundle = ResourceBundle.getBundle("RuntimeBundle");
    static /* synthetic */ Class class$org$junit$runner$RunWith;
    static /* synthetic */ Class class$org$junit$Ignore;
    static /* synthetic */ Class class$org$junit$runners$Parameterized;
    static /* synthetic */ Class class$com$intellij$junit4$JUnit4TestRunnerUtil;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$org$junit$runners$BlockJUnit4ClassRunner;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Request buildRequest(String[] suiteClassNames, String name, boolean notForked) {
        if (suiteClassNames.length == 0) {
            return null;
        }
        Vector result = new Vector();
        for (int i = 0; i < suiteClassNames.length; ++i) {
            RunWith clazzAnnotation;
            Request request;
            Class clazz;
            String suiteClassName = suiteClassNames[i];
            if (suiteClassName.charAt(0) == '@') {
                try {
                    final HashMap<String, HashSet<String>> classMethods = new HashMap<String, HashSet<String>>();
                    BufferedReader reader = new BufferedReader(new FileReader(suiteClassName.substring(1)));
                    try {
                        Request allClasses;
                        HashSet<String> methodNames;
                        String line;
                        String packageName = reader.readLine();
                        if (packageName == null) {
                            Request request2 = null;
                            return request2;
                        }
                        while ((line = reader.readLine()) != null) {
                            String className = line;
                            int idx = line.indexOf(44);
                            if (idx != -1) {
                                className = line.substring(0, idx);
                                methodNames = (HashSet<String>)classMethods.get(className);
                                if (methodNames == null) {
                                    methodNames = new HashSet<String>();
                                    classMethods.put(className, methodNames);
                                }
                                methodNames.add(line.substring(idx + 1));
                            }
                            JUnit4TestRunnerUtil.appendTestClass(result, className);
                        }
                        String suiteName = packageName.length() == 0 ? "<default package>" : packageName;
                        Class[] classes = JUnit4TestRunnerUtil.getArrayOfClasses(result);
                        if (classes.length == 0) {
                            System.out.println(TestRunnerUtil.testsFoundInPackageMesage(0, suiteName));
                            methodNames = null;
                            return methodNames;
                        }
                        try {
                            Class.forName("org.junit.runner.Computer");
                            allClasses = JUnit46ClassesRequestBuilder.getClassesRequest(suiteName, classes, classMethods);
                        }
                        catch (ClassNotFoundException e) {
                            allClasses = JUnit4TestRunnerUtil.getClassRequestsUsing44API(suiteName, classes);
                        }
                        catch (NoSuchMethodError e) {
                            allClasses = JUnit4TestRunnerUtil.getClassRequestsUsing44API(suiteName, classes);
                        }
                        Request e = classMethods.isEmpty() ? allClasses : allClasses.filterWith(new Filter(){

                            public boolean shouldRun(Description description) {
                                if (description.isTest()) {
                                    Set methods = (Set)classMethods.get(JUnit4ReflectionUtil.getClassName(description));
                                    return methods == null || methods.contains(JUnit4ReflectionUtil.getMethodName(description));
                                }
                                return true;
                            }

                            public String describe() {
                                return "Tests";
                            }
                        });
                        return e;
                    }
                    finally {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.exit(1);
                    continue;
                }
            }
            int index = suiteClassName.indexOf(44);
            if (index != -1) {
                clazz = JUnit4TestRunnerUtil.loadTestClass(suiteClassName.substring(0, index));
                final String methodName = suiteClassName.substring(index + 1);
                RunWith clazzAnnotation2 = (RunWith)clazz.getAnnotation(class$org$junit$runner$RunWith == null ? (class$org$junit$runner$RunWith = JUnit4TestRunnerUtil.class$("org.junit.runner.RunWith")) : class$org$junit$runner$RunWith);
                Description testMethodDescription = Description.createTestDescription((Class)clazz, (String)methodName);
                if (clazzAnnotation2 == null) {
                    try {
                        Method method = clazz.getMethod(methodName, null);
                        if (method != null && notForked && (method.getAnnotation(class$org$junit$Ignore == null ? (class$org$junit$Ignore = JUnit4TestRunnerUtil.class$("org.junit.Ignore")) : class$org$junit$Ignore) != null || clazz.getAnnotation(class$org$junit$Ignore == null ? (class$org$junit$Ignore = JUnit4TestRunnerUtil.class$("org.junit.Ignore")) : class$org$junit$Ignore) != null)) {
                            Request classRequest = JUnit4TestRunnerUtil.createIgnoreIgnoredClassRequest(clazz, true);
                            final Filter ignoredTestFilter = Filter.matchMethodDescription((Description)testMethodDescription);
                            return classRequest.filterWith(new Filter(){

                                public boolean shouldRun(Description description) {
                                    return ignoredTestFilter.shouldRun(description);
                                }

                                public String describe() {
                                    return "Ignored " + methodName;
                                }
                            });
                        }
                    }
                    catch (Exception ignored) {}
                } else {
                    Request request3 = JUnit4TestRunnerUtil.getParameterizedRequest(name, clazz, methodName, clazzAnnotation2);
                    if (request3 != null) {
                        return request3;
                    }
                }
                try {
                    if (clazz.getMethod("suite", new Class[0]) != null && !methodName.equals("suite")) {
                        return Request.classWithoutSuiteMethod((Class)clazz).filterWith(testMethodDescription);
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
                try {
                    final Filter methodFilter = Filter.matchMethodDescription((Description)testMethodDescription);
                    return Request.aClass((Class)clazz).filterWith(new Filter(){

                        public boolean shouldRun(Description description) {
                            if (description.isTest() && description.getDisplayName().startsWith("warning(junit.framework.TestSuite$")) {
                                return true;
                            }
                            return methodFilter.shouldRun(description);
                        }

                        public String describe() {
                            return methodFilter.describe();
                        }
                    });
                }
                catch (NoSuchMethodError e) {
                    return Request.method((Class)clazz, (String)methodName);
                }
            }
            if (name != null && suiteClassNames.length == 1 && (clazz = JUnit4TestRunnerUtil.loadTestClass(suiteClassName)) != null && (request = JUnit4TestRunnerUtil.getParameterizedRequest(name, clazz, null, clazzAnnotation = (RunWith)clazz.getAnnotation(class$org$junit$runner$RunWith == null ? JUnit4TestRunnerUtil.class$("org.junit.runner.RunWith") : class$org$junit$runner$RunWith))) != null) {
                return request;
            }
            JUnit4TestRunnerUtil.appendTestClass(result, suiteClassName);
        }
        if (result.size() != 1) return Request.classes((Class[])JUnit4TestRunnerUtil.getArrayOfClasses(result));
        Class clazz = (Class)result.get(0);
        try {
            if (clazz.getAnnotation(class$org$junit$Ignore == null ? (class$org$junit$Ignore = JUnit4TestRunnerUtil.class$("org.junit.Ignore")) : class$org$junit$Ignore) == null) return Request.aClass((Class)clazz);
            return JUnit4TestRunnerUtil.createIgnoreIgnoredClassRequest(clazz, false);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        return Request.aClass((Class)clazz);
    }

    private static Request getParameterizedRequest(String name, Class clazz, String methodName, RunWith clazzAnnotation) {
        Class runnerClass;
        if (clazzAnnotation == null) {
            return null;
        }
        if ((class$org$junit$runners$Parameterized == null ? (class$org$junit$runners$Parameterized = JUnit4TestRunnerUtil.class$("org.junit.runners.Parameterized")) : class$org$junit$runners$Parameterized).isAssignableFrom(runnerClass = clazzAnnotation.value())) {
            try {
                Class.forName("org.junit.runners.BlockJUnit4ClassRunner");
                return Request.runner((Runner)new SelectedParameterizedRunner(clazz, name, methodName, runnerClass));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private static Request createIgnoreIgnoredClassRequest(final Class clazz, final boolean recursively) throws ClassNotFoundException {
        Class.forName("org.junit.runners.BlockJUnit4ClassRunner");
        return new ClassRequest(clazz){

            public Runner getRunner() {
                try {
                    return new IgnoreIgnoredTestJUnit4ClassRunner(clazz, recursively);
                }
                catch (Exception exception) {
                    return super.getRunner();
                }
            }
        };
    }

    private static Request getClassRequestsUsing44API(String suiteName, Class[] classes) {
        Request allClasses;
        try {
            Class.forName("org.junit.internal.requests.ClassesRequest");
            allClasses = JUnit4ClassesRequestBuilder.getClassesRequest(suiteName, classes);
        }
        catch (ClassNotFoundException e1) {
            allClasses = JUnit45ClassesRequestBuilder.getClassesRequest(suiteName, classes);
        }
        return allClasses;
    }

    private static void appendTestClass(Vector result, String className) {
        Class aClass = JUnit4TestRunnerUtil.loadTestClass(className);
        if (!result.contains(aClass)) {
            result.addElement(aClass);
        }
    }

    private static Class[] getArrayOfClasses(Vector result) {
        Class[] classes = new Class[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            classes[i] = (Class)result.get(i);
        }
        return classes;
    }

    private static Class loadTestClass(String suiteClassName) {
        try {
            return Class.forName(suiteClassName, false, (class$com$intellij$junit4$JUnit4TestRunnerUtil == null ? (class$com$intellij$junit4$JUnit4TestRunnerUtil = JUnit4TestRunnerUtil.class$("com.intellij.junit4.JUnit4TestRunnerUtil")) : class$com$intellij$junit4$JUnit4TestRunnerUtil).getClassLoader());
        }
        catch (ClassNotFoundException e) {
            String clazz = e.getMessage();
            if (clazz == null) {
                clazz = suiteClassName;
            }
            System.err.print(MessageFormat.format(ourBundle.getString("junit.class.not.found"), clazz));
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println(MessageFormat.format(ourBundle.getString("junit.cannot.instantiate.tests"), e.toString()));
            System.exit(1);
        }
        return null;
    }

    public static String testsFoundInPackageMesage(int testCount, String name) {
        return MessageFormat.format(ourBundle.getString("tests.found.in.package"), new Integer(testCount), name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class SelectedParameterizedRunner
    extends Parameterized {
        private final String myName;
        private final String myMethodName;
        private Parameterized myRunnerClass;

        public SelectedParameterizedRunner(Class clazz, String name, String methodName, Class runnerClass) throws Throwable {
            super(clazz);
            this.myName = name;
            this.myMethodName = methodName;
            this.myRunnerClass = (Parameterized)runnerClass.getConstructor(class$java$lang$Class == null ? (class$java$lang$Class = JUnit4TestRunnerUtil.class$("java.lang.Class")) : class$java$lang$Class).newInstance(clazz);
        }

        protected List getChildren() {
            Object child;
            List children;
            try {
                Method getChildren = (class$org$junit$runners$Parameterized == null ? (class$org$junit$runners$Parameterized = JUnit4TestRunnerUtil.class$("org.junit.runners.Parameterized")) : class$org$junit$runners$Parameterized).getDeclaredMethod("getChildren", new Class[0]);
                getChildren.setAccessible(true);
                children = (List)getChildren.invoke((Object)this.myRunnerClass, new Object[0]);
            }
            catch (Throwable e) {
                children = super.getChildren();
            }
            if (this.myName != null) {
                Iterator iterator = children.iterator();
                while (iterator.hasNext()) {
                    child = iterator.next();
                    try {
                        Field f;
                        try {
                            f = child.getClass().getDeclaredField("fName");
                        }
                        catch (NoSuchFieldException e) {
                            continue;
                        }
                        f.setAccessible(true);
                        String fName = (String)f.get(child);
                        if (this.myName.equals(fName)) continue;
                        iterator.remove();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (children.isEmpty()) {
                    System.err.println("No tests were found by passed name: " + this.myName);
                    System.exit(1);
                }
            }
            if (this.myMethodName != null) {
                for (int i = 0; i < children.size(); ++i) {
                    try {
                        child = (BlockJUnit4ClassRunner)children.get(i);
                        Method getChildrenMethod = (class$org$junit$runners$BlockJUnit4ClassRunner == null ? JUnit4TestRunnerUtil.class$("org.junit.runners.BlockJUnit4ClassRunner") : class$org$junit$runners$BlockJUnit4ClassRunner).getDeclaredMethod("getChildren", new Class[0]);
                        getChildrenMethod.setAccessible(true);
                        List list = (List)getChildrenMethod.invoke(child, new Object[0]);
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            FrameworkMethod description = (FrameworkMethod)iterator.next();
                            if (description.getName().equals(this.myMethodName)) continue;
                            iterator.remove();
                        }
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            return children;
        }
    }

    private static class IgnoreIgnoredTestJUnit4ClassRunner
    extends BlockJUnit4ClassRunner {
        private final boolean myRecursively;

        public IgnoreIgnoredTestJUnit4ClassRunner(Class clazz, boolean recursively) throws Exception {
            super(clazz);
            this.myRecursively = recursively;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void runChild(FrameworkMethod method, RunNotifier notifier) {
            if (!this.myRecursively) {
                super.runChild(method, notifier);
                return;
            }
            Description description = this.describeChild(method);
            EachTestNotifier eachNotifier = new EachTestNotifier(notifier, description);
            eachNotifier.fireTestStarted();
            try {
                this.methodBlock(method).evaluate();
            }
            catch (AssumptionViolatedException e) {
                eachNotifier.addFailedAssumption(e);
            }
            catch (Throwable e) {
                eachNotifier.addFailure(e);
            }
            finally {
                eachNotifier.fireTestFinished();
            }
        }
    }
}

