/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.PluginPathManager;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public abstract class GroovyUtils {
    public static final String PLUGIN_MODULE_ID = "PLUGIN_MODULE";

    public static File[] getFilesInDirectoryByPattern(String dirPath, String patternString) {
        Pattern pattern = Pattern.compile(patternString);
        return GroovyUtils.getFilesInDirectoryByPattern(dirPath, pattern);
    }

    public static File[] getFilesInDirectoryByPattern(String dirPath, final Pattern pattern) {
        File distDir = new File(dirPath);
        File[] files = distDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return pattern.matcher(name).matches();
            }
        });
        return files != null ? files : new File[]{};
    }

    public static <E> List<E> flatten(Collection<? extends Collection<E>> collections) {
        ArrayList<E> result = new ArrayList<E>();
        for (Collection<E> list : collections) {
            result.addAll(list);
        }
        return result;
    }

    public static boolean isSuitableModule(Module module) {
        if (module == null) {
            return false;
        }
        return GroovyUtils.isAcceptableModuleType(ModuleType.get((Module)module));
    }

    public static boolean isAcceptableModuleType(ModuleType type) {
        return type instanceof JavaModuleType || PLUGIN_MODULE_ID.equals(type.getId()) || "ANDROID_MODULE".equals(type.getId());
    }

    @Nullable
    public static GrTypeDefinition getPublicClass(@Nullable VirtualFile virtualFile, PsiManager manager) {
        if (virtualFile == null) {
            return null;
        }
        PsiFile psiFile = manager.findFile(virtualFile);
        if (psiFile instanceof GroovyFile) {
            return GroovyUtils.getClassDefinition((GroovyFile)psiFile);
        }
        return null;
    }

    @Nullable
    public static GrTypeDefinition getClassDefinition(@NotNull GroovyFile groovyFile) {
        if (groovyFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/util/GroovyUtils", "getClassDefinition"));
        }
        String fileName = groovyFile.getName();
        int idx = fileName.lastIndexOf(46);
        if (idx < 0) {
            return null;
        }
        return GroovyUtils.getClassDefinition(groovyFile, fileName.substring(0, idx));
    }

    @Nullable
    public static GrTypeDefinition getClassDefinition(@NotNull GroovyFile groovyFile, @NotNull String classSimpleName) {
        if (groovyFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/util/GroovyUtils", "getClassDefinition"));
        }
        if (classSimpleName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/util/GroovyUtils", "getClassDefinition"));
        }
        for (GrTypeDefinition definition : groovyFile.getTypeDefinitions()) {
            if (!classSimpleName.equals(definition.getName())) continue;
            return definition;
        }
        return null;
    }

    public static File getBundledGroovyJar() {
        String root = new File(PathUtil.getJarPathForClass(GroovyUtils.class)).isDirectory() ? PluginPathManager.getPluginHomePath((String)"groovy") + "/../../lib/" : PathManager.getHomePath() + "/lib/";
        File[] groovyJars = GroovyConfigUtils.getGroovyAllJars(root);
        assert (groovyJars.length == 1);
        return groovyJars[0];
    }
}

