/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.springloaded;

import com.intellij.debugger.PositionManager;
import com.intellij.debugger.PositionManagerFactory;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.springloaded.SpringLoadedPositionManager;

public class SpringLoadedPositionManagerFactory
extends PositionManagerFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PositionManager createPositionManager(@NotNull DebugProcess process) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/springloaded/SpringLoadedPositionManagerFactory", "createPositionManager"));
        }
        AccessToken accessToken = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)process.getProject());
            if (facade.findPackage("com.springsource.loaded") != null || facade.findPackage("org.springsource.loaded") != null) {
                SpringLoadedPositionManager springLoadedPositionManager = new SpringLoadedPositionManager(process);
                return springLoadedPositionManager;
            }
        }
        finally {
            accessToken.finish();
        }
        try {
            if (process.getVirtualMachineProxy().classesByName("com.springsource.loaded.agent.SpringLoadedAgent").size() > 0 || process.getVirtualMachineProxy().classesByName("org.springsource.loaded.agent.SpringLoadedAgent").size() > 0) {
                return new SpringLoadedPositionManager(process);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

