/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.parameter;

import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Function;
import com.intellij.util.PairFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrParametersOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.refactoring.GrRefactoringError;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.extract.GroovyExtractChooser;
import org.jetbrains.plugins.groovy.refactoring.extract.InitialInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceContext;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceHandlerBase;
import org.jetbrains.plugins.groovy.refactoring.introduce.IntroduceOccurrencesChooser;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GrInplaceParameterIntroducer;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GrIntroduceParameterDialog;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GroovyIntroduceParameterUtil;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.IntroduceParameterInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.IntroduceParameterInfoImpl;
import org.jetbrains.plugins.groovy.refactoring.introduce.variable.GrIntroduceVariableHandler;
import org.jetbrains.plugins.groovy.refactoring.ui.MethodOrClosureScopeChooser;

public class GrIntroduceParameterHandler
implements RefactoringActionHandler,
MethodOrClosureScopeChooser.JBPopupOwner {
    static final String REFACTORING_NAME = RefactoringBundle.message((String)"introduce.parameter.title");
    private JBPopup myEnclosingMethodsPopup;

    public void invoke(final @NotNull Project project, final @NotNull Editor editor, final @NotNull PsiFile file, @Nullable DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrIntroduceParameterHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrIntroduceParameterHandler", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrIntroduceParameterHandler", "invoke"));
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection()) {
            int offset = editor.getCaretModel().getOffset();
            List<GrExpression> expressions = GrIntroduceHandlerBase.collectExpressions(file, editor, offset, false);
            if (expressions.isEmpty()) {
                GrIntroduceHandlerBase.updateSelectionForVariable(editor, file, selectionModel, offset);
            } else if (expressions.size() == 1) {
                TextRange textRange = expressions.get(0).getTextRange();
                selectionModel.setSelection(textRange.getStartOffset(), textRange.getEndOffset());
            } else {
                IntroduceTargetChooser.showChooser((Editor)editor, expressions, (Pass)new Pass<GrExpression>(){

                    public void pass(GrExpression selectedValue) {
                        GrIntroduceParameterHandler.this.invoke(project, editor, file, selectedValue.getTextRange().getStartOffset(), selectedValue.getTextRange().getEndOffset());
                    }
                }, (Function)new Function<GrExpression, String>(){

                    public String fun(GrExpression grExpression) {
                        return grExpression.getText();
                    }
                });
                return;
            }
        }
        this.invoke(project, editor, file, selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
    }

    private void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, int startOffset, int endOffset) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrIntroduceParameterHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrIntroduceParameterHandler", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrIntroduceParameterHandler", "invoke"));
        }
        try {
            InitialInfo initialInfo = GroovyExtractChooser.invoke(project, editor, file, startOffset, endOffset, false);
            this.chooseScopeAndRun(initialInfo, editor);
        }
        catch (GrRefactoringError e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw e;
            }
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)e.getMessage(), (String)RefactoringBundle.message((String)"introduce.parameter.title"), (String)"refactoring.introduceParameter.groovy");
        }
    }

    private void chooseScopeAndRun(final @NotNull InitialInfo initialInfo, final @NotNull Editor editor) {
        if (initialInfo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrIntroduceParameterHandler", "chooseScopeAndRun"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrIntroduceParameterHandler", "chooseScopeAndRun"));
        }
        List<GrParametersOwner> scopes = GrIntroduceParameterHandler.findScopes(initialInfo);
        if (scopes.size() == 0) {
            throw new GrRefactoringError(GroovyRefactoringBundle.message("there.is.no.method.or.closure", new Object[0]));
        }
        if (scopes.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
            GrVariable toSearchFor;
            GrParametersOwner owner = scopes.get(0);
            if (owner instanceof GrMethod) {
                toSearchFor = SuperMethodWarningUtil.checkSuperMethod((PsiMethod)((PsiMethod)owner), (String)RefactoringBundle.message((String)"to.refactor"));
                if (toSearchFor == null) {
                    return;
                }
            } else {
                toSearchFor = MethodOrClosureScopeChooser.findVariableToUse(owner);
            }
            this.showDialogOrStartInplace(new IntroduceParameterInfoImpl(initialInfo, owner, toSearchFor), editor);
        } else {
            this.myEnclosingMethodsPopup = MethodOrClosureScopeChooser.create(scopes, editor, this, new PairFunction<GrParametersOwner, PsiElement, Object>(){

                public Object fun(GrParametersOwner owner, PsiElement element) {
                    GrIntroduceParameterHandler.this.showDialogOrStartInplace(new IntroduceParameterInfoImpl(initialInfo, owner, element), editor);
                    return null;
                }
            });
            this.myEnclosingMethodsPopup.showInBestPositionFor(editor);
        }
    }

    @NotNull
    private static List<GrParametersOwner> findScopes(@NotNull InitialInfo initialInfo) {
        GrParametersOwner parent;
        if (initialInfo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrIntroduceParameterHandler", "findScopes"));
        }
        PsiElement place = initialInfo.getContext();
        ArrayList<GrParametersOwner> scopes = new ArrayList<GrParametersOwner>();
        while ((parent = (GrParametersOwner)PsiTreeUtil.getParentOfType((PsiElement)place, (Class[])new Class[]{GrMethod.class, GrClosableBlock.class})) != null) {
            scopes.add(parent);
            place = parent;
        }
        ArrayList<GrParametersOwner> arrayList = scopes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrIntroduceParameterHandler", "findScopes"));
        }
        return arrayList;
    }

    @Override
    public JBPopup get() {
        return this.myEnclosingMethodsPopup;
    }

    protected void showDialogOrStartInplace(final @NotNull IntroduceParameterInfo info, @NotNull Editor editor) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrIntroduceParameterHandler", "showDialogOrStartInplace"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrIntroduceParameterHandler", "showDialogOrStartInplace"));
        }
        if (GrIntroduceParameterHandler.isInplace(info, editor)) {
            final GrIntroduceContext context = GrIntroduceParameterHandler.createContext(info, editor);
            Map<OccurrencesChooser.ReplaceChoice, List<Object>> occurrencesMap = GrIntroduceHandlerBase.fillChoice(context);
            new IntroduceOccurrencesChooser(editor).showChooser((Pass)new Pass<OccurrencesChooser.ReplaceChoice>(){

                public void pass(OccurrencesChooser.ReplaceChoice choice) {
                    GrIntroduceParameterHandler.startInplace(info, context, choice);
                }
            }, occurrencesMap);
        } else {
            this.showDialog(info);
        }
    }

    protected void showDialog(IntroduceParameterInfo info) {
        new GrIntroduceParameterDialog(info).show();
    }

    private static void startInplace(@NotNull IntroduceParameterInfo info, @NotNull GrIntroduceContext context, OccurrencesChooser.ReplaceChoice replaceChoice) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrIntroduceParameterHandler", "startInplace"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrIntroduceParameterHandler", "startInplace"));
        }
        new GrInplaceParameterIntroducer(info, context, replaceChoice).startInplaceIntroduceTemplate();
    }

    private static boolean isInplace(@NotNull IntroduceParameterInfo info, @NotNull Editor editor) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrIntroduceParameterHandler", "isInplace"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrIntroduceParameterHandler", "isInplace"));
        }
        return GroovyIntroduceParameterUtil.findExpr(info) != null && info.getToReplaceIn() instanceof GrMethod && info.getToSearchFor() instanceof PsiMethod && GrIntroduceHandlerBase.isInplace(editor, info.getContext());
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrIntroduceParameterHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrIntroduceParameterHandler", "invoke"));
        }
    }

    private static GrIntroduceContext createContext(@NotNull IntroduceParameterInfo info, @NotNull Editor editor) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrIntroduceParameterHandler", "createContext"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrIntroduceParameterHandler", "createContext"));
        }
        GrExpression expr = GroovyIntroduceParameterUtil.findExpr(info);
        GrVariable var = GroovyIntroduceParameterUtil.findVar(info);
        StringPartInfo stringPart = info.getStringPartInfo();
        return new GrIntroduceVariableHandler().getContext(info.getProject(), editor, expr, var, stringPart, info.getToReplaceIn());
    }
}

