/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceContext;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceHandlerBase;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;

public class GrIntroduceContextImpl
implements GrIntroduceContext {
    private static final Logger LOG = Logger.getInstance(GrIntroduceContextImpl.class);
    private final Project myProject;
    private final Editor myEditor;
    @Nullable
    private final GrExpression myExpression;
    private final PsiElement[] myOccurrences;
    private final PsiElement myScope;
    @Nullable
    private final GrVariable myVar;
    @NotNull
    private final PsiElement myPlace;
    private final StringPartInfo myStringPart;

    public GrIntroduceContextImpl(@NotNull Project project, Editor editor, @Nullable GrExpression expression, @Nullable GrVariable var, @Nullable StringPartInfo stringPart, @NotNull PsiElement[] occurrences, PsiElement scope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceContextImpl", "<init>"));
        }
        if (occurrences == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceContextImpl", "<init>"));
        }
        this.myStringPart = stringPart;
        LOG.assertTrue(expression != null || var != null || stringPart != null);
        this.myProject = project;
        this.myEditor = editor;
        this.myExpression = expression;
        this.myOccurrences = occurrences;
        this.myScope = scope;
        this.myVar = var;
        this.myPlace = GrIntroduceHandlerBase.getCurrentPlace(expression, var, stringPart);
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceContextImpl", "getProject"));
        }
        return project;
    }

    @Override
    public Editor getEditor() {
        return this.myEditor;
    }

    @Override
    @Nullable
    public GrExpression getExpression() {
        return this.myExpression;
    }

    @Override
    @NotNull
    public PsiElement[] getOccurrences() {
        if (this.myOccurrences == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceContextImpl", "getOccurrences"));
        }
        return this.myOccurrences;
    }

    @Override
    public PsiElement getScope() {
        return this.myScope;
    }

    @Override
    @Nullable
    public GrVariable getVar() {
        return this.myVar;
    }

    @Override
    @Nullable
    public StringPartInfo getStringPart() {
        return this.myStringPart;
    }

    @Override
    @NotNull
    public PsiElement getPlace() {
        PsiElement psiElement = this.myPlace;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceContextImpl", "getPlace"));
        }
        return psiElement;
    }
}

