/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.encapsulateFields;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.encapsulateFields.EncapsulateFieldHelper;
import com.intellij.refactoring.encapsulateFields.EncapsulateFieldUsageInfo;
import com.intellij.refactoring.encapsulateFields.EncapsulateFieldsDescriptor;
import com.intellij.refactoring.encapsulateFields.FieldDescriptor;
import com.intellij.refactoring.encapsulateFields.JavaEncapsulateFieldHelper;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.JavaStylePropertiesUtil;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyEncapsulateFieldHelper
extends EncapsulateFieldHelper {
    private static final Logger LOG = Logger.getInstance(GroovyEncapsulateFieldHelper.class);

    @NotNull
    public PsiField[] getApplicableFields(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/encapsulateFields/GroovyEncapsulateFieldHelper", "getApplicableFields"));
        }
        if (aClass instanceof GrTypeDefinition) {
            PsiField[] psiFieldArray = ((GrTypeDefinition)aClass).getCodeFields();
            if (psiFieldArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/encapsulateFields/GroovyEncapsulateFieldHelper", "getApplicableFields"));
            }
            return psiFieldArray;
        }
        PsiField[] psiFieldArray = aClass.getFields();
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/encapsulateFields/GroovyEncapsulateFieldHelper", "getApplicableFields"));
        }
        return psiFieldArray;
    }

    @NotNull
    public String suggestSetterName(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/encapsulateFields/GroovyEncapsulateFieldHelper", "suggestSetterName"));
        }
        String string = PropertyUtil.suggestSetterName((PsiField)field);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/encapsulateFields/GroovyEncapsulateFieldHelper", "suggestSetterName"));
        }
        return string;
    }

    @NotNull
    public String suggestGetterName(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/encapsulateFields/GroovyEncapsulateFieldHelper", "suggestGetterName"));
        }
        String string = PropertyUtil.suggestGetterName((PsiField)field);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/encapsulateFields/GroovyEncapsulateFieldHelper", "suggestGetterName"));
        }
        return string;
    }

    @Nullable
    public PsiMethod generateMethodPrototype(@NotNull PsiField field, @NotNull String methodName, boolean isGetter) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/encapsulateFields/GroovyEncapsulateFieldHelper", "generateMethodPrototype"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/refactoring/encapsulateFields/GroovyEncapsulateFieldHelper", "generateMethodPrototype"));
        }
        GrMethod prototype = isGetter ? GroovyPropertyUtils.generateGetterPrototype(field) : GroovyPropertyUtils.generateSetterPrototype(field);
        try {
            prototype.setName(methodName);
            return prototype;
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Nullable
    public EncapsulateFieldUsageInfo createUsage(@NotNull EncapsulateFieldsDescriptor descriptor, @NotNull FieldDescriptor fieldDescriptor, @NotNull PsiReference reference) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/encapsulateFields/GroovyEncapsulateFieldHelper", "createUsage"));
        }
        if (fieldDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/refactoring/encapsulateFields/GroovyEncapsulateFieldHelper", "createUsage"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/refactoring/encapsulateFields/GroovyEncapsulateFieldHelper", "createUsage"));
        }
        if (!(reference instanceof GrReferenceExpression)) {
            return null;
        }
        boolean findSet = descriptor.isToEncapsulateSet();
        boolean findGet = descriptor.isToEncapsulateGet();
        GrReferenceExpression ref = (GrReferenceExpression)reference;
        if (findGet && JavaEncapsulateFieldHelper.isUsedInExistingAccessor((PsiClass)descriptor.getTargetClass(), (PsiMethod)fieldDescriptor.getGetterPrototype(), (PsiElement)ref)) {
            return null;
        }
        if (findSet && JavaEncapsulateFieldHelper.isUsedInExistingAccessor((PsiClass)descriptor.getTargetClass(), (PsiMethod)fieldDescriptor.getSetterPrototype(), (PsiElement)ref)) {
            return null;
        }
        if (!findGet && !PsiUtil.isAccessedForWriting(ref)) {
            return null;
        }
        if (!(findSet && !fieldDescriptor.getField().hasModifierProperty("final") || PsiUtil.isAccessedForReading(ref))) {
            return null;
        }
        return new EncapsulateFieldUsageInfo((PsiReference)ref, fieldDescriptor);
    }

    @Nullable
    private static PsiClass getAccessObject(@NotNull GrReferenceExpression ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/encapsulateFields/GroovyEncapsulateFieldHelper", "getAccessObject"));
        }
        GrExpression qualifier = ref.getQualifierExpression();
        if (qualifier != null) {
            return (PsiClass)PsiUtil.getAccessObjectClass(qualifier).getElement();
        }
        return null;
    }

    public boolean processUsage(@NotNull EncapsulateFieldUsageInfo usage, @NotNull EncapsulateFieldsDescriptor descriptor, PsiMethod setter, PsiMethod getter) {
        boolean processSet;
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/encapsulateFields/GroovyEncapsulateFieldHelper", "processUsage"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/refactoring/encapsulateFields/GroovyEncapsulateFieldHelper", "processUsage"));
        }
        PsiElement element = usage.getElement();
        if (!(element instanceof GrReferenceExpression)) {
            return false;
        }
        FieldDescriptor fieldDescriptor = usage.getFieldDescriptor();
        PsiField field = fieldDescriptor.getField();
        boolean processGet = descriptor.isToEncapsulateGet();
        boolean bl = processSet = descriptor.isToEncapsulateSet() && !field.hasModifierProperty("final");
        if (!processGet && !processSet) {
            return true;
        }
        GrReferenceExpression expr = (GrReferenceExpression)element;
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(descriptor.getTargetClass().getProject());
        try {
            PsiElement parent;
            if (!descriptor.isToUseAccessorsWhenAccessible()) {
                PsiModifierList newModifierList = JavaEncapsulateFieldHelper.createNewModifierList((EncapsulateFieldsDescriptor)descriptor);
                PsiClass accessObjectClass = GroovyEncapsulateFieldHelper.getAccessObject(expr);
                PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)expr.getProject()).getResolveHelper();
                if (helper.isAccessible((PsiMember)fieldDescriptor.getField(), newModifierList, (PsiElement)expr, accessObjectClass, null)) {
                    if (expr.resolve() instanceof PsiMethod) {
                        GroovyEncapsulateFieldHelper.addMemberOperator(expr, field);
                    }
                    return true;
                }
            }
            if ((parent = expr.getParent()) instanceof GrAssignmentExpression && expr.equals(((GrAssignmentExpression)parent).getLValue())) {
                GrAssignmentExpression assignment = (GrAssignmentExpression)parent;
                if (assignment.getRValue() != null) {
                    PsiElement opSign = assignment.getOperationToken();
                    IElementType opType = assignment.getOperationTokenType();
                    if (opType == GroovyTokenTypes.mASSIGN) {
                        if (!processSet || GroovyEncapsulateFieldHelper.checkSetterIsSimple(field, setter) && GroovyEncapsulateFieldHelper.checkFieldIsInaccessible(field, expr)) {
                            return true;
                        }
                        GrExpression setterArgument = assignment.getRValue();
                        GrMethodCallExpression methodCall = GroovyEncapsulateFieldHelper.createSetterCall(fieldDescriptor, setterArgument, expr, descriptor.getTargetClass(), setter);
                        if (methodCall != null) {
                            GroovyEncapsulateFieldHelper.tryToSimplify((GrMethodCallExpression)assignment.replaceWithExpression(methodCall, true));
                        }
                    } else {
                        GrExpression setExpr;
                        GrMethodCallExpression getterCall;
                        if (GroovyEncapsulateFieldHelper.checkAccessorsAreSimpleAndFieldIsInaccessible(field, setter, getter, expr)) {
                            return true;
                        }
                        String opName = opSign.getText();
                        LOG.assertTrue(StringUtil.endsWithChar((CharSequence)opName, (char)'='));
                        opName = opName.substring(0, opName.length() - 1);
                        GrExpression getExpr = expr;
                        if (processGet && (getterCall = GroovyEncapsulateFieldHelper.createGetterCall(fieldDescriptor, expr, descriptor.getTargetClass(), getter)) != null) {
                            getExpr = getterCall;
                        }
                        String text = "a" + opName + "b";
                        GrBinaryExpression binExpr = (GrBinaryExpression)factory.createExpressionFromText(text, expr);
                        GroovyEncapsulateFieldHelper.tryToSimplify((GrMethodCallExpression)binExpr.getLeftOperand().replaceWithExpression(getExpr, true));
                        binExpr.getRightOperand().replaceWithExpression(assignment.getRValue(), true);
                        if (processSet) {
                            setExpr = GroovyEncapsulateFieldHelper.createSetterCall(fieldDescriptor, binExpr, expr, descriptor.getTargetClass(), setter);
                        } else {
                            text = "a = b";
                            GrAssignmentExpression newAssignment = (GrAssignmentExpression)factory.createExpressionFromText(text, null);
                            newAssignment.getLValue().replaceWithExpression(expr, true);
                            newAssignment.getRValue().replaceWithExpression(binExpr, true);
                            setExpr = newAssignment;
                        }
                        GroovyEncapsulateFieldHelper.tryToSimplify((GrMethodCallExpression)assignment.replaceWithExpression(setExpr, true));
                    }
                }
            } else if (parent instanceof GrUnaryExpression && (((GrUnaryExpression)parent).getOperationTokenType() == GroovyTokenTypes.mINC || ((GrUnaryExpression)parent).getOperationTokenType() == GroovyTokenTypes.mDEC)) {
                GrExpression setExpr;
                GrMethodCallExpression getterCall;
                if (GroovyEncapsulateFieldHelper.checkAccessorsAreSimpleAndFieldIsInaccessible(field, setter, getter, expr)) {
                    return true;
                }
                IElementType sign = ((GrUnaryExpression)parent).getOperationTokenType();
                GrExpression getExpr = expr;
                if (processGet && (getterCall = GroovyEncapsulateFieldHelper.createGetterCall(fieldDescriptor, expr, descriptor.getTargetClass(), getter)) != null) {
                    getExpr = getterCall;
                }
                String text = sign == GroovyTokenTypes.mINC ? "a+1" : "a-1";
                GrBinaryExpression binExpr = (GrBinaryExpression)factory.createExpressionFromText(text, parent);
                GroovyEncapsulateFieldHelper.tryToSimplify((GrMethodCallExpression)binExpr.getLeftOperand().replaceWithExpression(getExpr, true));
                if (processSet) {
                    setExpr = GroovyEncapsulateFieldHelper.createSetterCall(fieldDescriptor, binExpr, expr, descriptor.getTargetClass(), setter);
                } else {
                    text = "a = b";
                    GrAssignmentExpression assignment = (GrAssignmentExpression)factory.createExpressionFromText(text, null);
                    assignment.getLValue().replaceWithExpression(expr, true);
                    assignment.getRValue().replaceWithExpression(binExpr, true);
                    setExpr = assignment;
                }
                GroovyEncapsulateFieldHelper.tryToSimplify((GrMethodCallExpression)((GrUnaryExpression)parent).replaceWithExpression(setExpr, true));
            } else {
                if (!processGet || GroovyEncapsulateFieldHelper.checkGetterIsSimple(field, getter) && GroovyEncapsulateFieldHelper.checkFieldIsInaccessible(field, expr)) {
                    return true;
                }
                GrMethodCallExpression methodCall = GroovyEncapsulateFieldHelper.createGetterCall(fieldDescriptor, expr, descriptor.getTargetClass(), getter);
                if (methodCall != null) {
                    GroovyEncapsulateFieldHelper.tryToSimplify((GrMethodCallExpression)expr.replaceWithExpression(methodCall, true));
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return true;
    }

    private static void addMemberOperator(@NotNull GrReferenceExpression ref, @NotNull PsiField field) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/encapsulateFields/GroovyEncapsulateFieldHelper", "addMemberOperator"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/refactoring/encapsulateFields/GroovyEncapsulateFieldHelper", "addMemberOperator"));
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(ref.getProject());
        GrExpression qualifier = (GrExpression)ref.getQualifier();
        if (qualifier == null) {
            PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiClass.class);
            PsiClass containingClass = GroovyEncapsulateFieldHelper.findContainingClass(ref, field);
            GrReferenceExpression thisRef = !ref.getManager().areElementsEquivalent((PsiElement)parentClass, (PsiElement)containingClass) ? factory.createThisExpression(containingClass) : factory.createThisExpression(null);
            ref.setQualifier(thisRef);
        }
        ref.getNode().addLeaf(GroovyTokenTypes.mAT, (CharSequence)"@", ref.getDotToken().getNode().getTreeNext());
    }

    private static PsiClass findContainingClass(@NotNull GrReferenceExpression ref, @NotNull PsiField field) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/encapsulateFields/GroovyEncapsulateFieldHelper", "findContainingClass"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/refactoring/encapsulateFields/GroovyEncapsulateFieldHelper", "findContainingClass"));
        }
        GrReferenceExpression context = ref;
        PsiClass aClass;
        while ((aClass = PsiUtil.getContextClass(context)) != null) {
            PsiField found;
            PsiManager manager = context.getManager();
            if (manager.areElementsEquivalent((PsiElement)(found = aClass.findFieldByName(field.getName(), true)), (PsiElement)field)) {
                return aClass;
            }
            if (context instanceof GroovyScriptClass) {
                return null;
            }
            if (context.getParent() instanceof GroovyFile) {
                return null;
            }
            context = aClass.getParent();
        }
        return null;
    }

    private static boolean checkAccessorsAreSimpleAndFieldIsInaccessible(@NotNull PsiField field, @Nullable PsiMethod setter, @Nullable PsiMethod getter, @NotNull GrReferenceExpression place) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/encapsulateFields/GroovyEncapsulateFieldHelper", "checkAccessorsAreSimpleAndFieldIsInaccessible"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/groovy/refactoring/encapsulateFields/GroovyEncapsulateFieldHelper", "checkAccessorsAreSimpleAndFieldIsInaccessible"));
        }
        return !(setter != null && !GroovyEncapsulateFieldHelper.checkSetterIsSimple(field, setter) || getter != null && !GroovyEncapsulateFieldHelper.checkGetterIsSimple(field, getter) || !GroovyEncapsulateFieldHelper.checkFieldIsInaccessible(field, place));
    }

    private static boolean checkSetterIsSimple(@NotNull PsiField field, @NotNull PsiMethod setter) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/encapsulateFields/GroovyEncapsulateFieldHelper", "checkSetterIsSimple"));
        }
        if (setter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/refactoring/encapsulateFields/GroovyEncapsulateFieldHelper", "checkSetterIsSimple"));
        }
        String nameBySetter = GroovyPropertyUtils.getPropertyNameBySetterName(setter.getName());
        return field.getName().equals(nameBySetter);
    }

    private static boolean checkGetterIsSimple(@NotNull PsiField field, @NotNull PsiMethod getter) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/encapsulateFields/GroovyEncapsulateFieldHelper", "checkGetterIsSimple"));
        }
        if (getter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/refactoring/encapsulateFields/GroovyEncapsulateFieldHelper", "checkGetterIsSimple"));
        }
        String nameByGetter = GroovyPropertyUtils.getPropertyNameByGetterName(getter.getName(), true);
        return field.getName().equals(nameByGetter);
    }

    private static boolean checkFieldIsInaccessible(PsiField field, @NotNull GrReferenceExpression place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/refactoring/encapsulateFields/GroovyEncapsulateFieldHelper", "checkFieldIsInaccessible"));
        }
        PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)field.getProject()).getResolveHelper();
        return helper.isAccessible((PsiMember)field, (PsiElement)place, GroovyEncapsulateFieldHelper.getAccessObject(place));
    }

    private static void tryToSimplify(@NotNull GrMethodCallExpression methodCall) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/encapsulateFields/GroovyEncapsulateFieldHelper", "tryToSimplify"));
        }
        if (JavaStylePropertiesUtil.isPropertyAccessor(methodCall)) {
            JavaStylePropertiesUtil.fixJavaStyleProperty(methodCall);
        }
    }

    private static GrMethodCallExpression createSetterCall(FieldDescriptor fieldDescriptor, GrExpression setterArgument, GrReferenceExpression expr, PsiClass aClass, PsiMethod setter) throws IncorrectOperationException {
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(fieldDescriptor.getField().getProject());
        String setterName = fieldDescriptor.getSetterName();
        String text = setterName + "(a)";
        GrExpression qualifier = expr.getQualifierExpression();
        if (qualifier != null) {
            text = "q." + text;
        }
        GrMethodCallExpression methodCall = (GrMethodCallExpression)factory.createExpressionFromText(text, expr);
        methodCall.getArgumentList().getExpressionArguments()[0].replace(setterArgument);
        if (qualifier != null) {
            ((GrReferenceExpression)methodCall.getInvokedExpression()).getQualifierExpression().replace(qualifier);
        }
        if ((methodCall = GroovyEncapsulateFieldHelper.checkMethodResolvable(methodCall, setter, expr, aClass)) == null) {
            VisibilityUtil.escalateVisibility((PsiMember)fieldDescriptor.getField(), (PsiElement)expr);
        }
        return methodCall;
    }

    @Nullable
    private static GrMethodCallExpression createGetterCall(FieldDescriptor fieldDescriptor, GrReferenceExpression expr, PsiClass aClass, PsiMethod getter) throws IncorrectOperationException {
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(fieldDescriptor.getField().getProject());
        String getterName = fieldDescriptor.getGetterName();
        String text = getterName + "()";
        GrExpression qualifier = expr.getQualifierExpression();
        if (qualifier != null) {
            text = "q." + text;
        }
        GrMethodCallExpression methodCall = (GrMethodCallExpression)factory.createExpressionFromText(text, expr);
        if (qualifier != null) {
            ((GrReferenceExpression)methodCall.getInvokedExpression()).getQualifierExpression().replace(qualifier);
        }
        if ((methodCall = GroovyEncapsulateFieldHelper.checkMethodResolvable(methodCall, getter, expr, aClass)) == null) {
            VisibilityUtil.escalateVisibility((PsiMember)fieldDescriptor.getField(), (PsiElement)expr);
        }
        return methodCall;
    }

    @Nullable
    private static GrMethodCallExpression checkMethodResolvable(GrMethodCallExpression methodCall, PsiMethod targetMethod, GrReferenceExpression context, PsiClass aClass) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)targetMethod.getProject()).getElementFactory();
        PsiElement resolved = ((GrReferenceExpression)methodCall.getInvokedExpression()).resolve();
        if (resolved != targetMethod) {
            PsiClass containingClass;
            if (resolved instanceof PsiMethod) {
                containingClass = ((PsiMethod)resolved).getContainingClass();
            } else if (resolved instanceof PsiClass) {
                containingClass = (PsiClass)resolved;
            } else {
                return null;
            }
            if (containingClass != null && containingClass.isInheritor(aClass, false)) {
                PsiExpression newMethodExpression = factory.createExpressionFromText("super." + targetMethod.getName(), (PsiElement)context);
                methodCall.getInvokedExpression().replace((PsiElement)newMethodExpression);
            } else {
                methodCall = null;
            }
        }
        return methodCall;
    }
}

