/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToJava;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnonymousClassType;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ClassNameProvider;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GenerationUtil;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GeneratorClassNameProvider;

public class TypeWriter
extends PsiTypeVisitor<Object> {
    private final boolean acceptEllipsis;
    private final StringBuilder builder;
    private final ClassNameProvider classNameProvider;
    private final PsiElement context;

    public static void writeTypeForNew(@NotNull StringBuilder builder, @Nullable PsiType type, @NotNull PsiElement context) {
        PsiType erased;
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/convertToJava/TypeWriter", "writeTypeForNew"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/refactoring/convertToJava/TypeWriter", "writeTypeForNew"));
        }
        if (type instanceof PsiArrayType && (erased = TypeConversionUtil.erasure((PsiType)type)) != null) {
            type = erased;
        }
        TypeWriter.writeType(builder, type, context, new GeneratorClassNameProvider());
    }

    public static void writeType(@NotNull StringBuilder builder, @Nullable PsiType type, @NotNull PsiElement context) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/convertToJava/TypeWriter", "writeType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/refactoring/convertToJava/TypeWriter", "writeType"));
        }
        TypeWriter.writeType(builder, type, context, new GeneratorClassNameProvider());
    }

    public static void writeType(@NotNull StringBuilder builder, @Nullable PsiType type, @NotNull PsiElement context, @NotNull ClassNameProvider classNameProvider) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/convertToJava/TypeWriter", "writeType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/refactoring/convertToJava/TypeWriter", "writeType"));
        }
        if (classNameProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/groovy/refactoring/convertToJava/TypeWriter", "writeType"));
        }
        if (type == null || PsiType.NULL.equals((Object)type)) {
            builder.append("java.lang.Object");
            return;
        }
        if (type instanceof PsiPrimitiveType) {
            builder.append(type.getCanonicalText());
            return;
        }
        if (type instanceof GrAnonymousClassType) {
            type = ((GrAnonymousClassType)type).getSimpleClassType();
        }
        boolean acceptEllipsis = TypeWriter.isLastParameter(context);
        type.accept((PsiTypeVisitor)new TypeWriter(builder, classNameProvider, acceptEllipsis, context));
    }

    private TypeWriter(@NotNull StringBuilder builder, @NotNull ClassNameProvider classNameProvider, boolean acceptEllipsis, @NotNull PsiElement context) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/convertToJava/TypeWriter", "<init>"));
        }
        if (classNameProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/refactoring/convertToJava/TypeWriter", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/groovy/refactoring/convertToJava/TypeWriter", "<init>"));
        }
        this.acceptEllipsis = acceptEllipsis;
        this.builder = builder;
        this.classNameProvider = classNameProvider;
        this.context = context;
    }

    public Object visitEllipsisType(@NotNull PsiEllipsisType ellipsisType) {
        if (ellipsisType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/convertToJava/TypeWriter", "visitEllipsisType"));
        }
        PsiType componentType = ellipsisType.getComponentType();
        componentType.accept((PsiTypeVisitor)this);
        if (this.acceptEllipsis) {
            this.builder.append("...");
        } else {
            this.builder.append("[]");
        }
        return this;
    }

    public Object visitPrimitiveType(@NotNull PsiPrimitiveType primitiveType) {
        if (primitiveType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/convertToJava/TypeWriter", "visitPrimitiveType"));
        }
        if (this.classNameProvider.forStubs()) {
            this.builder.append(primitiveType.getCanonicalText());
            return this;
        }
        PsiType boxed = TypesUtil.boxPrimitiveType((PsiType)primitiveType, this.context.getManager(), this.context.getResolveScope());
        boxed.accept((PsiTypeVisitor)this);
        return this;
    }

    public Object visitArrayType(@NotNull PsiArrayType arrayType) {
        if (arrayType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/convertToJava/TypeWriter", "visitArrayType"));
        }
        arrayType.getComponentType().accept((PsiTypeVisitor)this);
        this.builder.append("[]");
        return this;
    }

    public Object visitClassType(@NotNull PsiClassType classType) {
        if (classType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/convertToJava/TypeWriter", "visitClassType"));
        }
        PsiType[] parameters = classType.getParameters();
        PsiClass psiClass = classType.resolve();
        if (psiClass == null) {
            this.builder.append(classType.getClassName());
        } else {
            String qname = this.classNameProvider.getQualifiedClassName(psiClass, this.context);
            this.builder.append(qname);
        }
        GenerationUtil.writeTypeParameters(this.builder, parameters, this.context, this.classNameProvider);
        return this;
    }

    public Object visitCapturedWildcardType(@NotNull PsiCapturedWildcardType capturedWildcardType) {
        if (capturedWildcardType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/convertToJava/TypeWriter", "visitCapturedWildcardType"));
        }
        capturedWildcardType.getWildcard().accept((PsiTypeVisitor)this);
        return this;
    }

    public Object visitWildcardType(@NotNull PsiWildcardType wildcardType) {
        if (wildcardType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/convertToJava/TypeWriter", "visitWildcardType"));
        }
        this.builder.append('?');
        PsiType bound = wildcardType.getBound();
        if (bound == null) {
            return this;
        }
        if (wildcardType.isExtends()) {
            this.builder.append(" extends ");
        } else {
            this.builder.append(" super ");
        }
        bound.accept((PsiTypeVisitor)this);
        return this;
    }

    public Object visitDisjunctionType(@NotNull PsiDisjunctionType disjunctionType) {
        if (disjunctionType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/convertToJava/TypeWriter", "visitDisjunctionType"));
        }
        throw new UnsupportedOperationException();
    }

    public Object visitType(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/convertToJava/TypeWriter", "visitType"));
        }
        throw new UnsupportedOperationException();
    }

    private static boolean isLastParameter(@NotNull PsiElement context) {
        PsiElement scope;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/convertToJava/TypeWriter", "isLastParameter"));
        }
        if (context instanceof PsiParameter && (scope = ((PsiParameter)context).getDeclarationScope()) instanceof PsiMethod) {
            PsiParameter[] parameters = ((PsiMethod)scope).getParameterList().getParameters();
            return parameters.length > 0 && parameters[parameters.length - 1] == context;
        }
        return false;
    }
}

