/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToJava;

import com.intellij.codeInsight.daemon.impl.quickfix.MoveClassToSeparateFileFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.hash.HashSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ClassGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ClassItemGeneratorImpl;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionContext;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GeneratorClassNameProvider;

public class ConvertToJavaProcessor
extends BaseRefactoringProcessor {
    private static Logger LOG = Logger.getInstance(ConvertToJavaProcessor.class);
    private GroovyFile[] myFiles;

    protected ConvertToJavaProcessor(Project project, GroovyFile ... files) {
        super(project);
        this.myFiles = files;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
        UsageViewDescriptorAdapter usageViewDescriptorAdapter = new UsageViewDescriptorAdapter(){

            @NotNull
            public PsiElement[] getElements() {
                PsiElement[] psiElementArray = ConvertToJavaProcessor.this.myFiles;
                if (psiElementArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ConvertToJavaProcessor$1", "getElements"));
                }
                return psiElementArray;
            }

            public String getProcessedElementsHeader() {
                return GroovyRefactoringBundle.message("files.to.be.converted", new Object[0]);
            }
        };
        if (usageViewDescriptorAdapter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ConvertToJavaProcessor", "createUsageViewDescriptor"));
        }
        return usageViewDescriptorAdapter;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        if (UsageInfo.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ConvertToJavaProcessor", "findUsages"));
        }
        return UsageInfo.EMPTY_ARRAY;
    }

    protected void performRefactoring(UsageInfo[] usages) {
        GeneratorClassNameProvider classNameProvider = new GeneratorClassNameProvider();
        ExpressionContext context = new ExpressionContext(this.myProject, this.myFiles);
        ClassGenerator classGenerator = new ClassGenerator(classNameProvider, new ClassItemGeneratorImpl(context));
        for (GroovyFile file : this.myFiles) {
            PsiElement newFile;
            PsiClass[] classes = file.getClasses();
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (PsiClass aClass : classes) {
                classGenerator.writeTypeDefinition(builder, aClass, true, first);
                first = false;
                builder.append('\n');
            }
            Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument((PsiFile)file);
            LOG.assertTrue(document != null);
            document.setText((CharSequence)builder.toString());
            PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document);
            String fileName = ConvertToJavaProcessor.getNewFileName(file);
            try {
                newFile = file.setName(fileName);
            }
            catch (IncorrectOperationException e) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Messages.showMessageDialog((Project)ConvertToJavaProcessor.this.myProject, (String)e.getMessage(), (String)RefactoringBundle.message((String)"error.title"), (Icon)Messages.getErrorIcon());
                    }
                });
                return;
            }
            this.doPostProcessing(newFile);
        }
    }

    private void doPostProcessing(PsiElement newFile) {
        PsiClass[] inner;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (!(newFile instanceof PsiJavaFile)) {
            LOG.info(".java is not assigned to java file type");
            return;
        }
        newFile = JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences(newFile);
        newFile = CodeStyleManager.getInstance((Project)this.myProject).reformat(newFile);
        for (PsiClass psiClass : inner = ((PsiJavaFile)newFile).getClasses()) {
            MoveClassToSeparateFileFix fix = new MoveClassToSeparateFileFix(psiClass);
            if (!fix.isAvailable(this.myProject, null, (PsiFile)newFile)) continue;
            fix.invoke(this.myProject, null, (PsiFile)newFile);
        }
    }

    private static String getNewFileName(GroovyFile file) {
        PsiDirectory dir = file.getContainingDirectory();
        LOG.assertTrue(dir != null);
        PsiFile[] files = dir.getFiles();
        HashSet fileNames = new HashSet();
        for (PsiFile psiFile : files) {
            fileNames.add(psiFile.getName());
        }
        String prefix = FileUtil.getNameWithoutExtension((String)file.getName());
        String fileName = prefix + ".java";
        int index = 1;
        while (fileNames.contains(fileName)) {
            fileName = prefix + index + ".java";
        }
        return fileName;
    }

    protected String getCommandName() {
        return GroovyRefactoringBundle.message("converting.files.to.java", new Object[0]);
    }
}

