/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.classMembers;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public abstract class GrClassMemberReferenceVisitor
extends GroovyRecursiveElementVisitor {
    private final PsiClass myClass;

    public GrClassMemberReferenceVisitor(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/classMembers/GrClassMemberReferenceVisitor", "<init>"));
        }
        this.myClass = aClass;
    }

    @Override
    public void visitReferenceExpression(GrReferenceExpression ref) {
        PsiClass containingClass;
        PsiElement resolved;
        GrExpression qualifier = (GrExpression)ref.getQualifier();
        if (qualifier != null && !PsiUtil.isThisOrSuperRef(qualifier)) {
            qualifier.accept(this);
            if (!(qualifier instanceof GrReferenceExpression) || !(((GrReferenceExpression)qualifier).resolve() instanceof PsiClass)) {
                return;
            }
        }
        if ((resolved = ref.resolve()) instanceof GrMember && GrClassMemberReferenceVisitor.isPartOf(this.myClass, containingClass = ((GrMember)resolved).getContainingClass())) {
            this.visitClassMemberReferenceElement((GrMember)resolved, ref);
        }
    }

    @Override
    public void visitCodeReferenceElement(GrCodeReferenceElement reference) {
        PsiElement referencedElement = reference.resolve();
        if (referencedElement instanceof GrTypeDefinition) {
            GrTypeDefinition referencedClass = (GrTypeDefinition)referencedElement;
            if (PsiTreeUtil.isAncestor((PsiElement)this.myClass, (PsiElement)referencedElement, (boolean)true) || GrClassMemberReferenceVisitor.isPartOf(this.myClass, referencedClass.getContainingClass())) {
                this.visitClassMemberReferenceElement((GrMember)referencedElement, reference);
            }
        }
    }

    private static boolean isPartOf(@NotNull PsiClass aClass, @Nullable PsiClass containingClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/classMembers/GrClassMemberReferenceVisitor", "isPartOf"));
        }
        if (containingClass == null) {
            return false;
        }
        return aClass.equals(containingClass) || aClass.isInheritor(containingClass, true);
    }

    protected abstract void visitClassMemberReferenceElement(GrMember var1, GrReferenceElement var2);
}

