/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.refactoring.NameValidator;

public class GroovyNameSuggestionUtil {
    public static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.refactoring.GroovyNameSuggestionUtil");

    private GroovyNameSuggestionUtil() {
    }

    public static String[] suggestVariableNames(GrExpression expr, NameValidator validator) {
        return GroovyNameSuggestionUtil.suggestVariableNames(expr, validator, false);
    }

    public static String[] suggestVariableNames(@NotNull GrExpression expr, NameValidator validator, boolean forStaticVariable) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/GroovyNameSuggestionUtil", "suggestVariableNames"));
        }
        LinkedHashSet<String> possibleNames = new LinkedHashSet<String>();
        PsiType type = expr.getType();
        GroovyNameSuggestionUtil.generateNameByExpr(expr, possibleNames, validator, forStaticVariable);
        if (type != null && !PsiType.VOID.equals((Object)type)) {
            GroovyNameSuggestionUtil.generateVariableNameByTypeInner(type, possibleNames, validator);
        }
        possibleNames.remove("");
        if (possibleNames.size() == 0) {
            possibleNames.add(validator.validateName("var", true));
        }
        return ArrayUtil.toStringArray(possibleNames);
    }

    public static String[] suggestVariableNameByType(PsiType type, NameValidator validator) {
        if (type == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        LinkedHashSet<String> possibleNames = new LinkedHashSet<String>();
        GroovyNameSuggestionUtil.generateVariableNameByTypeInner(type, possibleNames, validator);
        return ArrayUtil.toStringArray(possibleNames);
    }

    private static void generateVariableNameByTypeInner(PsiType type, Set<String> possibleNames, NameValidator validator) {
        String unboxed = PsiTypesUtil.unboxIfPossible((String)type.getCanonicalText());
        if (unboxed != null && !unboxed.equals(type.getCanonicalText())) {
            String name = GroovyNameSuggestionUtil.generateNameForBuiltInType(unboxed);
            if (GroovyNamesUtil.isIdentifier(name = validator.validateName(name, true))) {
                possibleNames.add(name);
            }
        } else if (type instanceof PsiIntersectionType) {
            for (PsiType psiType : ((PsiIntersectionType)type).getConjuncts()) {
                GroovyNameSuggestionUtil.generateByType(psiType, possibleNames, validator);
            }
        } else {
            GroovyNameSuggestionUtil.generateByType(type, possibleNames, validator);
        }
    }

    private static void generateNameByExpr(GrExpression expr, Set<String> possibleNames, NameValidator validator, boolean forStaticVariable) {
        Object value;
        if (expr instanceof GrReferenceExpression && ((GrReferenceExpression)expr).getReferenceName() != null) {
            GrReferenceExpression refExpr;
            String name;
            if (PsiUtil.isThisReference(expr)) {
                possibleNames.add(validator.validateName("thisInstance", true));
            }
            if (PsiUtil.isSuperReference(expr)) {
                possibleNames.add(validator.validateName("superInstance", true));
            }
            if ((name = (refExpr = (GrReferenceExpression)expr).getReferenceName()) != null && name.toUpperCase().equals(name)) {
                possibleNames.add(validator.validateName(name.toLowerCase(), true));
            } else {
                GroovyNameSuggestionUtil.generateCamelNames(possibleNames, validator, name);
            }
            if (expr.getText().equals(name)) {
                possibleNames.remove(name);
            }
        }
        if (expr instanceof GrMethodCallExpression) {
            GroovyNameSuggestionUtil.generateNameByExpr(((GrMethodCallExpression)expr).getInvokedExpression(), possibleNames, validator, forStaticVariable);
        }
        if (expr instanceof GrLiteral && (value = ((GrLiteral)expr).getValue()) instanceof String) {
            GroovyNameSuggestionUtil.generateNameByString(possibleNames, (String)value, validator, forStaticVariable, expr.getProject());
        }
    }

    private static void generateNameByString(Set<String> possibleNames, String value, NameValidator validator, boolean forStaticVariable, Project project) {
        if (!JavaPsiFacade.getInstance((Project)project).getNameHelper().isIdentifier(value)) {
            return;
        }
        if (forStaticVariable) {
            StringBuilder buffer = new StringBuilder(value.length() + 10);
            char[] chars = new char[value.length()];
            value.getChars(0, value.length(), chars, 0);
            boolean wasLow = Character.isLowerCase(chars[0]);
            buffer.append(Character.toUpperCase(chars[0]));
            for (int i = 1; i < chars.length; ++i) {
                if (Character.isUpperCase(chars[i])) {
                    if (wasLow) {
                        buffer.append('_');
                        wasLow = false;
                    }
                } else {
                    wasLow = true;
                }
                buffer.append(Character.toUpperCase(chars[i]));
            }
            possibleNames.add(validator.validateName(buffer.toString(), true));
        } else {
            possibleNames.add(validator.validateName(value, true));
        }
    }

    private static void generateByType(PsiType type, Set<String> possibleNames, NameValidator validator) {
        String typeName = type.getPresentableText();
        GroovyNameSuggestionUtil.generateNamesForCollectionType(type, possibleNames, validator);
        GroovyNameSuggestionUtil.generateNamesForArrayType(type, possibleNames, validator);
        GroovyNameSuggestionUtil.generateNamesForExceptions(type, possibleNames, validator);
        typeName = GroovyNameSuggestionUtil.cleanTypeName(typeName);
        if (typeName.equals("String")) {
            possibleNames.add(validator.validateName("s", true));
        }
        if (typeName.equals("Closure")) {
            possibleNames.add(validator.validateName("cl", true));
        }
        if (typeName.toUpperCase().equals(typeName)) {
            possibleNames.add(validator.validateName(GroovyNamesUtil.deleteNonLetterFromString(typeName.toLowerCase()), true));
        } else if (!typeName.equals(typeName.toLowerCase())) {
            GroovyNameSuggestionUtil.generateCamelNames(possibleNames, validator, typeName);
            possibleNames.remove(typeName);
        }
    }

    private static void generateNamesForExceptions(PsiType type, Set<String> possibleNames, NameValidator validator) {
        if (InheritanceUtil.isInheritor((PsiType)type, (String)"java.lang.Error")) {
            possibleNames.add(validator.validateName("error", true));
        } else if (InheritanceUtil.isInheritor((PsiType)type, (String)"java.lang.Exception")) {
            possibleNames.add(validator.validateName("e", true));
        }
    }

    private static void generateNamesForArrayType(PsiType type, Set<String> possibleNames, NameValidator validator) {
        int arrayDim = type.getArrayDimensions();
        if (arrayDim == 0) {
            return;
        }
        PsiType deepType = type.getDeepComponentType();
        String candidateName = GroovyNameSuggestionUtil.cleanTypeName(deepType.getPresentableText());
        if (deepType instanceof PsiClassType) {
            PsiClass clazz = ((PsiClassType)deepType).resolve();
            if (clazz == null) {
                return;
            }
            candidateName = GroovyNamesUtil.fromLowerLetter(clazz.getName());
        }
        candidateName = StringUtil.pluralize((String)GroovyNamesUtil.fromLowerLetter(candidateName));
        GroovyNameSuggestionUtil.generateCamelNames(possibleNames, validator, candidateName);
        ArrayList<String> camelizedName = GroovyNamesUtil.camelizeString(candidateName);
        candidateName = camelizedName.get(camelizedName.size() - 1);
        candidateName = "arrayOf" + GroovyNameSuggestionUtil.fromUpperLetter(candidateName);
        possibleNames.add(validator.validateName(candidateName, true));
    }

    private static void generateNamesForCollectionType(PsiType type, Set<String> possibleNames, NameValidator validator) {
        PsiType componentType = GroovyNameSuggestionUtil.getCollectionComponentType(type, validator.getProject());
        if (!(type instanceof PsiClassType) || componentType == null) {
            return;
        }
        PsiClass clazz = ((PsiClassType)type).resolve();
        if (clazz == null) {
            return;
        }
        String collectionName = clazz.getName();
        assert (collectionName != null);
        String componentName = GroovyNameSuggestionUtil.cleanTypeName(componentType.getPresentableText());
        if (componentType instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)componentType;
            PsiClass psiClass = classType.resolve();
            if (psiClass == null) {
                return;
            }
            componentName = psiClass.getName();
        }
        assert (componentName != null);
        String candidateName = StringUtil.pluralize((String)GroovyNamesUtil.fromLowerLetter(componentName));
        GroovyNameSuggestionUtil.generateCamelNames(possibleNames, validator, candidateName);
        ArrayList<String> camelizedName = GroovyNamesUtil.camelizeString(candidateName);
        candidateName = camelizedName.get(camelizedName.size() - 1);
        candidateName = collectionName.toLowerCase() + "Of" + GroovyNameSuggestionUtil.fromUpperLetter(candidateName);
        possibleNames.add(validator.validateName(candidateName, true));
    }

    @NotNull
    private static String cleanTypeName(@NotNull String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/refactoring/GroovyNameSuggestionUtil", "cleanTypeName"));
        }
        if (typeName.contains(".")) {
            typeName = typeName.substring(typeName.lastIndexOf(".") + 1);
        }
        if (typeName.contains("<")) {
            typeName = typeName.substring(0, typeName.indexOf("<"));
        }
        String string = typeName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/GroovyNameSuggestionUtil", "cleanTypeName"));
        }
        return string;
    }

    private static void generateCamelNames(Set<String> possibleNames, NameValidator validator, String typeName) {
        ArrayList<String> camelTokens = GroovyNamesUtil.camelizeString(typeName);
        Collections.reverse(camelTokens);
        if (camelTokens.size() > 0) {
            String possibleName = "";
            for (String camelToken : camelTokens) {
                possibleName = camelToken + GroovyNameSuggestionUtil.fromUpperLetter(possibleName);
                String candidate = validator.validateName(possibleName, true);
                if (candidate.equals("class")) {
                    candidate = validator.validateName("clazz", true);
                }
                if (possibleNames.contains(candidate) || !GroovyNamesUtil.isIdentifier(candidate)) continue;
                possibleNames.add(candidate);
            }
        }
    }

    private static String generateNameForBuiltInType(String unboxed) {
        return unboxed.toLowerCase().substring(0, 1);
    }

    private static String fromUpperLetter(String str) {
        if (str.length() == 0) {
            return "";
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    @Nullable
    private static PsiType getCollectionComponentType(PsiType type, Project project) {
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        PsiClassType classType = (PsiClassType)type;
        PsiClassType.ClassResolveResult result = classType.resolveGenerics();
        PsiClass clazz = result.getElement();
        if (clazz == null) {
            return null;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiClass collectionClass = facade.findClass("java.util.Collection", type.getResolveScope());
        if (collectionClass == null || collectionClass.getTypeParameters().length != 1) {
            return null;
        }
        PsiSubstitutor substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)collectionClass, (PsiClass)clazz, (PsiSubstitutor)result.getSubstitutor());
        if (substitutor == null) {
            return null;
        }
        PsiType componentType = substitutor.substitute(collectionClass.getTypeParameters()[0]);
        return componentType instanceof PsiIntersectionType ? null : componentType;
    }
}

