/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.overrideImplement;

import com.intellij.codeInsight.MethodImplementor;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.actions.generate.GroovyGenerationInfo;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GrDocCommentUtil;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.overrideImplement.GroovyOverrideImplementUtil;

public class GroovyMethodImplementor
implements MethodImplementor {
    @NotNull
    public PsiMethod[] getMethodsToImplement(PsiClass aClass) {
        if (PsiMethod.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/overrideImplement/GroovyMethodImplementor", "getMethodsToImplement"));
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    @NotNull
    public PsiMethod[] createImplementationPrototypes(PsiClass inClass, PsiMethod method) throws IncorrectOperationException {
        if (!(inClass instanceof GrTypeDefinition)) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/overrideImplement/GroovyMethodImplementor", "createImplementationPrototypes"));
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        PsiClass containingClass = method.getContainingClass();
        PsiSubstitutor substitutor = inClass.isInheritor(containingClass, true) ? TypeConversionUtil.getSuperClassSubstitutor((PsiClass)containingClass, (PsiClass)inClass, (PsiSubstitutor)PsiSubstitutor.EMPTY) : PsiSubstitutor.EMPTY;
        PsiMethod[] psiMethodArray = new PsiMethod[]{GroovyOverrideImplementUtil.generateMethodPrototype((GrTypeDefinition)inClass, method, substitutor)};
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/overrideImplement/GroovyMethodImplementor", "createImplementationPrototypes"));
        }
        return psiMethodArray;
    }

    public GenerationInfo createGenerationInfo(PsiMethod method, boolean mergeIfExists) {
        if (method instanceof GrMethod) {
            return new GroovyGenerationInfo<GrMethod>((GrMethod)method, mergeIfExists);
        }
        return null;
    }

    @NotNull
    public Consumer<PsiMethod> createDecorator(final PsiClass targetClass, final PsiMethod baseMethod, final boolean toCopyJavaDoc, final boolean insertOverrideIfPossible) {
        Consumer<PsiMethod> consumer = new Consumer<PsiMethod>(){

            public void consume(PsiMethod method) {
                Project project = targetClass.getProject();
                if (toCopyJavaDoc) {
                    PsiDocComment baseMethodDocComment = baseMethod.getDocComment();
                    if (baseMethodDocComment != null) {
                        GrDocComment docComment = GroovyPsiElementFactory.getInstance(project).createDocCommentFromText(baseMethodDocComment.getText());
                        GrDocCommentUtil.setDocComment((GrMethod)method, docComment);
                    }
                } else {
                    PsiDocComment docComment = method.getDocComment();
                    if (docComment != null) {
                        docComment.delete();
                    }
                }
                if (insertOverrideIfPossible) {
                    if (OverrideImplementUtil.canInsertOverride((PsiMethod)method, (PsiClass)targetClass) && JavaPsiFacade.getInstance((Project)project).findClass("java.lang.Override", targetClass.getResolveScope()) != null && method.getModifierList().findAnnotation("java.lang.Override") == null) {
                        method.getModifierList().addAnnotation("java.lang.Override");
                    }
                } else {
                    PsiAnnotation annotation = method.getModifierList().findAnnotation("java.lang.Override");
                    if (annotation != null) {
                        annotation.delete();
                    }
                }
            }
        };
        if (consumer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/overrideImplement/GroovyMethodImplementor", "createDecorator"));
        }
        return consumer;
    }
}

