/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.HashMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;
import org.jetbrains.plugins.groovy.mvc.MvcRunConfiguration;
import org.jetbrains.plugins.groovy.mvc.util.ModuleCellRenderer;

public class MvcRunConfigurationEditor<T extends MvcRunConfiguration>
extends SettingsEditor<T>
implements PanelWithAnchor {
    private DefaultComboBoxModel myModulesModel;
    protected JComboBox myModulesBox;
    private JPanel myMainPanel;
    private RawCommandLineEditor myVMParameters;
    private JTextField myCommandLine;
    private JBLabel myVMParamsLabel;
    private JPanel myExtensionPanel;
    protected JCheckBox myDepsClasspath;
    private EnvironmentVariablesComponent myEnvVariablesComponent;
    private MvcFramework myFramework;
    private JComponent anchor;

    public MvcRunConfigurationEditor() {
        this.$$$setupUI$$$();
        this.myCommandLine.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                MvcRunConfigurationEditor.this.commandLineChanged(MvcRunConfigurationEditor.this.getCommandLine());
            }
        });
        this.setAnchor((JComponent)this.myEnvVariablesComponent.getLabel());
    }

    protected void resetEditorFrom(T configuration) {
        this.myFramework = ((MvcRunConfiguration)((Object)configuration)).getFramework();
        this.myVMParameters.setDialogCaption("VM Options");
        this.myVMParameters.setText(((MvcRunConfiguration)((Object)configuration)).vmParams);
        this.myVMParamsLabel.setLabelFor((Component)this.myVMParameters);
        this.myCommandLine.setText(((MvcRunConfiguration)((Object)configuration)).cmdLine);
        this.myModulesModel.removeAllElements();
        for (Module module : ((MvcRunConfiguration)((Object)configuration)).getValidModules()) {
            this.myModulesModel.addElement(module);
        }
        this.myModulesModel.setSelectedItem(((MvcRunConfiguration)((Object)configuration)).getModule());
        this.commandLineChanged(this.getCommandLine());
        this.myEnvVariablesComponent.setEnvs(new HashMap<String, String>(((MvcRunConfiguration)((Object)configuration)).envs));
        this.myEnvVariablesComponent.setPassParentEnvs(((MvcRunConfiguration)((Object)configuration)).passParentEnv);
        if (this.myDepsClasspath.isEnabled()) {
            this.myDepsClasspath.setSelected(((MvcRunConfiguration)((Object)configuration)).depsClasspath);
        }
    }

    protected boolean isAvailableDepsClasspath() {
        return true;
    }

    protected void commandLineChanged(@NotNull String newText) {
        if (newText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/mvc/MvcRunConfigurationEditor", "commandLineChanged"));
        }
        Module module = this.getSelectedModule();
        String depsClasspath = MvcFramework.getInstance(module) == null ? "" : this.myFramework.getApplicationClassPath(module).getPathsString();
        boolean hasClasspath = StringUtil.isNotEmpty((String)depsClasspath);
        MvcRunConfigurationEditor.setCBEnabled(hasClasspath && this.isAvailableDepsClasspath(), this.myDepsClasspath);
        String presentable = "Add --classpath";
        if (hasClasspath) {
            presentable = presentable + ": " + (depsClasspath.length() > 70 ? depsClasspath.substring(0, 70) + "..." : depsClasspath);
        }
        this.myDepsClasspath.setText(presentable);
        this.myDepsClasspath.setToolTipText("<html>&nbsp;" + StringUtil.replace((String)depsClasspath, (String)File.pathSeparator, (String)"<br>&nbsp;") + "</html>");
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.myVMParamsLabel.setAnchor(anchor);
        this.myEnvVariablesComponent.setAnchor(anchor);
    }

    protected static void setCBEnabled(boolean enabled, JCheckBox checkBox) {
        boolean wasEnabled = checkBox.isEnabled();
        checkBox.setEnabled(enabled);
        if (wasEnabled && !enabled) {
            checkBox.setSelected(false);
        } else if (!wasEnabled && enabled) {
            checkBox.setSelected(true);
        }
    }

    protected void applyEditorTo(T configuration) throws ConfigurationException {
        configuration.setModule(this.getSelectedModule());
        ((MvcRunConfiguration)((Object)configuration)).vmParams = this.myVMParameters.getText().trim();
        ((MvcRunConfiguration)((Object)configuration)).cmdLine = this.getCommandLine();
        ((MvcRunConfiguration)((Object)configuration)).envs.clear();
        ((MvcRunConfiguration)((Object)configuration)).envs.putAll(this.myEnvVariablesComponent.getEnvs());
        ((MvcRunConfiguration)((Object)configuration)).passParentEnv = this.myEnvVariablesComponent.isPassParentEnvs();
        if (this.myDepsClasspath.isEnabled()) {
            ((MvcRunConfiguration)((Object)configuration)).depsClasspath = this.myDepsClasspath.isSelected();
        }
    }

    protected String getCommandLine() {
        return this.myCommandLine.getText().trim();
    }

    protected Module getSelectedModule() {
        return (Module)this.myModulesBox.getSelectedItem();
    }

    public void addExtension(JComponent component) {
        this.myExtensionPanel.add((Component)component, "First");
    }

    @NotNull
    protected JComponent createEditor() {
        this.myModulesModel = new DefaultComboBoxModel();
        this.myModulesBox.setModel(this.myModulesModel);
        this.myModulesBox.setRenderer(new ModuleCellRenderer(this.myModulesBox.getRenderer()));
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/mvc/MvcRunConfigurationEditor", "createEditor"));
        }
        return jPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        EnvironmentVariablesComponent environmentVariablesComponent;
        JCheckBox jCheckBox;
        JPanel jPanel;
        JComboBox jComboBox;
        RawCommandLineEditor rawCommandLineEditor;
        JTextField jTextField;
        JBLabel jBLabel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myVMParamsLabel = jBLabel = new JBLabel();
        jBLabel.setText("VM options:");
        jBLabel.setDisplayedMnemonic('V');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Command line:");
        jLabel.setDisplayedMnemonic('C');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCommandLine = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myVMParameters = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel2.add((Component)rawCommandLineEditor, new GridConstraints(2, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myModulesBox = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Module:");
        jLabel2.setDisplayedMnemonic('M');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myExtensionPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myDepsClasspath = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(false);
        jCheckBox.setText("Add --classpath");
        jCheckBox.setMnemonic('P');
        jCheckBox.setDisplayedMnemonicIndex(11);
        jPanel2.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myEnvVariablesComponent = environmentVariablesComponent = new EnvironmentVariablesComponent();
        environmentVariablesComponent.setLabelLocation("West");
        jPanel2.add((Component)environmentVariablesComponent, new GridConstraints(3, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        jLabel.setLabelFor(jTextField);
        jLabel2.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

