/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.mvc.MvcConfigureNotification;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;

public class MvcProjectWithoutLibraryNotificator
implements StartupActivity,
DumbAware {
    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/mvc/MvcProjectWithoutLibraryNotificator", "runActivity"));
        }
        ProgressIndicatorUtils.scheduleWithWriteActionPriority((ReadTask)new ReadTask(){

            public void computeInReadAction(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/mvc/MvcProjectWithoutLibraryNotificator$1", "computeInReadAction"));
                }
                if (project.isDisposed()) {
                    return;
                }
                Pair pair = MvcProjectWithoutLibraryNotificator.findModuleWithoutLibrary(project);
                if (pair != null) {
                    final MvcFramework framework = (MvcFramework)pair.second;
                    final Module module = (Module)pair.first;
                    String name = framework.getFrameworkName();
                    String content = "<html><body>Module '" + module.getName() + "' has no " + name + " SDK. <a href='create'>Configure SDK</a></body></html>";
                    new Notification(name + ".Configure", name + " SDK not found", content, NotificationType.INFORMATION, (NotificationListener)new NotificationListener.Adapter(){

                        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                            if (notification == null) {
                                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/mvc/MvcProjectWithoutLibraryNotificator$1$1", "hyperlinkActivated"));
                            }
                            if (e == null) {
                                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/mvc/MvcProjectWithoutLibraryNotificator$1$1", "hyperlinkActivated"));
                            }
                            if (!module.isDisposed()) {
                                MvcConfigureNotification.configure(framework, module);
                            }
                        }
                    }).notify(project);
                }
            }

            public void onCanceled(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/mvc/MvcProjectWithoutLibraryNotificator$1", "onCanceled"));
                }
                ProgressIndicatorUtils.scheduleWithWriteActionPriority((ReadTask)this);
            }
        });
    }

    @Nullable
    private static Pair<Module, MvcFramework> findModuleWithoutLibrary(Project project) {
        MvcFramework[] frameworks = (MvcFramework[])MvcFramework.EP_NAME.getExtensions();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            for (MvcFramework framework : frameworks) {
                VirtualFile appRoot = framework.findAppRoot(module);
                if (appRoot == null || appRoot.findChild("application.properties") == null || framework.hasFrameworkJar(module)) continue;
                return Pair.create((Object)module, (Object)framework);
            }
        }
        return null;
    }
}

