/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ui.configuration.libraries.AddCustomLibraryDialog;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.GroovyFrameworkConfigNotification;
import org.jetbrains.plugins.groovy.config.GroovyLibraryDescription;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;

public class MvcConfigureNotification
extends GroovyFrameworkConfigNotification {
    private final MvcFramework framework;

    public MvcConfigureNotification(MvcFramework framework) {
        this.framework = framework;
    }

    @Override
    public boolean hasFrameworkStructure(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/mvc/MvcConfigureNotification", "hasFrameworkStructure"));
        }
        VirtualFile appDir = this.framework.findAppDirectory(module);
        if (appDir == null) {
            return false;
        }
        return appDir.findChild("controllers") != null && appDir.findChild("conf") != null;
    }

    @Override
    public boolean hasFrameworkLibrary(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/mvc/MvcConfigureNotification", "hasFrameworkLibrary"));
        }
        return this.framework.hasFrameworkJar(module);
    }

    public static void configure(@NotNull MvcFramework framework, @NotNull Module module) {
        if (framework == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/mvc/MvcConfigureNotification", "configure"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/mvc/MvcConfigureNotification", "configure"));
        }
        GroovyLibraryDescription description = framework.createLibraryDescription();
        AddCustomLibraryDialog dialog = AddCustomLibraryDialog.createDialog((CustomLibraryDescription)description, (Module)module, null);
        dialog.setTitle("Change " + framework.getDisplayName() + " SDK version");
        dialog.show();
        if (dialog.isOK()) {
            module.putUserData(MvcFramework.UPGRADE, (Object)Boolean.TRUE);
        }
    }

    @Override
    public EditorNotificationPanel createConfigureNotificationPanel(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/mvc/MvcConfigureNotification", "createConfigureNotificationPanel"));
        }
        EditorNotificationPanel panel = new EditorNotificationPanel();
        panel.setText(this.framework.getFrameworkName() + " SDK is not configured for module '" + module.getName() + '\'');
        panel.createActionLabel("Configure " + this.framework.getFrameworkName() + " SDK", new Runnable(){

            @Override
            public void run() {
                MvcConfigureNotification.configure(MvcConfigureNotification.this.framework, module);
            }
        });
        return panel;
    }
}

