/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.surroundWith;

import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public abstract class GroovyExpressionSurrounder
implements Surrounder {
    protected boolean isApplicable(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/surroundWith/GroovyExpressionSurrounder", "isApplicable"));
        }
        return element instanceof GrExpression;
    }

    @Nullable
    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement[] elements) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/surroundWith/GroovyExpressionSurrounder", "surroundElements"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/surroundWith/GroovyExpressionSurrounder", "surroundElements"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/surroundWith/GroovyExpressionSurrounder", "surroundElements"));
        }
        if (elements.length != 1) {
            return null;
        }
        PsiElement element = elements[0];
        return this.surroundExpression((GrExpression)element, element.getParent());
    }

    protected abstract TextRange surroundExpression(GrExpression var1, PsiElement var2);

    public boolean isApplicable(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/surroundWith/GroovyExpressionSurrounder", "isApplicable"));
        }
        return elements.length == 1 && this.isApplicable(elements[0]);
    }

    protected static void replaceToOldExpression(GrExpression oldExpr, GrExpression replacement) {
        oldExpr.replaceWithExpression(replacement, false);
    }
}

