/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.source.tree.java.PsiLocalVariableImpl;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.SpreadState;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.StaticChecker;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GrScopeProcessorWithHints;

public class ResolverProcessor
extends GrScopeProcessorWithHints {
    public static final Key<PsiElement> RESOLVE_CONTEXT = Key.create((String)"RESOLVE_CONTEXT");
    public static final EnumSet<ClassHint.ResolveKind> RESOLVE_KINDS_CLASS_PACKAGE = EnumSet.of(ClassHint.ResolveKind.CLASS, ClassHint.ResolveKind.PACKAGE);
    public static final EnumSet<ClassHint.ResolveKind> RESOLVE_KINDS_CLASS = EnumSet.of(ClassHint.ResolveKind.CLASS);
    public static final EnumSet<ClassHint.ResolveKind> RESOLVE_KINDS_METHOD = EnumSet.of(ClassHint.ResolveKind.METHOD);
    public static final EnumSet<ClassHint.ResolveKind> RESOLVE_KINDS_METHOD_PROPERTY = EnumSet.of(ClassHint.ResolveKind.METHOD, ClassHint.ResolveKind.PROPERTY);
    public static final EnumSet<ClassHint.ResolveKind> RESOLVE_KINDS_PROPERTY = EnumSet.of(ClassHint.ResolveKind.PROPERTY);
    private Set<String> myProcessedClasses;
    protected final PsiElement myPlace;
    private final PsiType[] myTypeArguments;
    private List<GroovyResolveResult> myCandidates;

    protected ResolverProcessor(@Nullable String name, @NotNull EnumSet<ClassHint.ResolveKind> resolveTargets, @NotNull PsiElement place, @NotNull PsiType[] typeArguments) {
        if (resolveTargets == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/resolve/processors/ResolverProcessor", "<init>"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/resolve/processors/ResolverProcessor", "<init>"));
        }
        if (typeArguments == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/groovy/lang/resolve/processors/ResolverProcessor", "<init>"));
        }
        super(name, resolveTargets);
        this.myPlace = place;
        this.myTypeArguments = typeArguments;
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/resolve/processors/ResolverProcessor", "execute"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/resolve/processors/ResolverProcessor", "execute"));
        }
        if (element instanceof PsiLocalVariableImpl) {
            return true;
        }
        if (this.myResolveTargetKinds.contains((Object)ResolverProcessor.getResolveKind(element))) {
            if (element instanceof PsiVariable && !(element instanceof PsiField) && this.getName() != null && !this.getName().equals(((PsiVariable)element).getName())) {
                return true;
            }
            PsiNamedElement namedElement = (PsiNamedElement)element;
            PsiSubstitutor substitutor = (PsiSubstitutor)state.get(PsiSubstitutor.KEY);
            if (substitutor == null) {
                substitutor = PsiSubstitutor.EMPTY;
            }
            if (this.myTypeArguments.length > 0 && namedElement instanceof PsiClass) {
                substitutor = substitutor.putAll((PsiClass)namedElement, this.myTypeArguments);
            }
            if (namedElement instanceof PsiClass && !(namedElement instanceof PsiTypeParameter)) {
                PsiClass aClass = (PsiClass)namedElement;
                if (this.myProcessedClasses == null) {
                    this.myProcessedClasses = new HashSet<String>();
                }
                if (!this.myProcessedClasses.add(aClass.getQualifiedName())) {
                    return true;
                }
            }
            boolean isAccessible = this.isAccessible(namedElement);
            PsiElement resolveContext = (PsiElement)state.get(RESOLVE_CONTEXT);
            SpreadState spreadState = (SpreadState)state.get(SpreadState.SPREAD_STATE);
            boolean isStaticsOK = this.isStaticsOK(namedElement, resolveContext, false);
            this.addCandidate(new GroovyResolveResultImpl((PsiElement)namedElement, resolveContext, spreadState, substitutor, isAccessible, isStaticsOK));
            return !isAccessible || !isStaticsOK;
        }
        return true;
    }

    protected final void addCandidate(@NotNull GroovyResolveResult candidate) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/resolve/processors/ResolverProcessor", "addCandidate"));
        }
        PsiElement element = candidate.getElement();
        assert (element == null || element.isValid()) : ResolverProcessor.getElementInfo(element);
        if (this.myCandidates == null) {
            this.myCandidates = new ArrayList<GroovyResolveResult>();
        }
        this.myCandidates.add(candidate);
    }

    @NotNull
    private static String getElementInfo(@NotNull PsiElement element) {
        PsiElement context;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/resolve/processors/ResolverProcessor", "getElementInfo"));
        }
        String text = element instanceof LightElement ? ((context = element.getContext()) != null ? context.getText() : null) : element.getText();
        String string = "invalid resolve candidate: " + element.getClass() + ", text: " + text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/ResolverProcessor", "getElementInfo"));
        }
        return string;
    }

    @NotNull
    protected List<GroovyResolveResult> getCandidatesInternal() {
        List<Object> list = this.myCandidates == null ? Collections.emptyList() : this.myCandidates;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/ResolverProcessor", "getCandidatesInternal"));
        }
        return list;
    }

    protected boolean isAccessible(@NotNull PsiNamedElement namedElement) {
        if (namedElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/resolve/processors/ResolverProcessor", "isAccessible"));
        }
        if (namedElement instanceof GrField) {
            GrField field = (GrField)namedElement;
            if (PsiUtil.isAccessible(this.myPlace, field)) {
                return true;
            }
            for (GrAccessorMethod method : field.getGetters()) {
                if (!PsiUtil.isAccessible(this.myPlace, (PsiMember)method)) continue;
                return true;
            }
            GrAccessorMethod setter = field.getSetter();
            return setter != null && PsiUtil.isAccessible(this.myPlace, (PsiMember)setter);
        }
        return !(namedElement instanceof PsiMember) || PsiUtil.isAccessible(this.myPlace, (PsiMember)namedElement);
    }

    protected boolean isStaticsOK(@NotNull PsiNamedElement element, @Nullable PsiElement resolveContext, boolean filterStaticAfterInstanceQualifier) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/resolve/processors/ResolverProcessor", "isStaticsOK"));
        }
        if (resolveContext instanceof GrImportStatement) {
            return true;
        }
        if (element instanceof PsiModifierListOwner) {
            return StaticChecker.isStaticsOK((PsiModifierListOwner)element, this.myPlace, resolveContext, filterStaticAfterInstanceQualifier);
        }
        return true;
    }

    @NotNull
    public GroovyResolveResult[] getCandidates() {
        if (this.myCandidates == null) {
            if (GroovyResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/ResolverProcessor", "getCandidates"));
            }
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        GroovyResolveResult[] groovyResolveResultArray = this.myCandidates.toArray(new GroovyResolveResult[this.myCandidates.size()]);
        if (groovyResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/ResolverProcessor", "getCandidates"));
        }
        return groovyResolveResultArray;
    }

    @Override
    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/resolve/processors/ResolverProcessor", "handleEvent"));
        }
    }

    public boolean hasCandidates() {
        return this.myCandidates != null;
    }

    @Nullable
    private static ClassHint.ResolveKind getResolveKind(PsiElement element) {
        if (element instanceof PsiVariable) {
            return ClassHint.ResolveKind.PROPERTY;
        }
        if (element instanceof PsiMethod) {
            return ClassHint.ResolveKind.METHOD;
        }
        if (element instanceof PsiPackage) {
            return ClassHint.ResolveKind.PACKAGE;
        }
        if (element instanceof PsiClass) {
            return ClassHint.ResolveKind.CLASS;
        }
        return null;
    }

    public String toString() {
        return "NameHint: '" + this.getName() + "', " + this.myResolveTargetKinds.toString() + ", Candidates: " + (this.myCandidates == null ? 0 : this.myCandidates.size());
    }
}

