/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.SpreadState;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MethodResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.SubstitutorComputer;

public class AccessorResolverProcessor
extends MethodResolverProcessor {
    private final String myPropertyName;
    private final boolean mySearchForGetter;
    private final SubstitutorComputer mySubstitutorComputer;

    public AccessorResolverProcessor(@Nullable String accessorName, @NotNull String propertyName, @NotNull PsiElement place, boolean searchForGetter) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/resolve/processors/AccessorResolverProcessor", "<init>"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/resolve/processors/AccessorResolverProcessor", "<init>"));
        }
        this(accessorName, propertyName, place, searchForGetter, false, null, PsiType.EMPTY_ARRAY);
    }

    public AccessorResolverProcessor(@Nullable String accessorName, @NotNull String propertyName, @NotNull PsiElement place, boolean searchForGetter, boolean byShape, @Nullable PsiType thisType, @NotNull PsiType[] typeArguments) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/resolve/processors/AccessorResolverProcessor", "<init>"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/resolve/processors/AccessorResolverProcessor", "<init>"));
        }
        if (typeArguments == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "6", "org/jetbrains/plugins/groovy/lang/resolve/processors/AccessorResolverProcessor", "<init>"));
        }
        super(accessorName, place, false, thisType, null, typeArguments, false, byShape);
        this.myPropertyName = propertyName;
        this.mySearchForGetter = searchForGetter;
        this.mySubstitutorComputer = byShape ? null : new SubstitutorComputer(thisType, PsiType.EMPTY_ARRAY, typeArguments, place, this.myPlace);
    }

    @Override
    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        String importedName;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/resolve/processors/AccessorResolverProcessor", "execute"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/resolve/processors/AccessorResolverProcessor", "execute"));
        }
        PsiElement resolveContext = (PsiElement)state.get(RESOLVE_CONTEXT);
        String string = importedName = resolveContext instanceof GrImportStatement ? ((GrImportStatement)resolveContext).getImportedName() : null;
        if (this.mySearchForGetter ? element instanceof PsiMethod && (importedName != null && GroovyPropertyUtils.isSimplePropertyGetter((PsiMethod)element, null) && (AccessorResolverProcessor.isAppropriatePropertyNameForGetter((PsiMethod)element, importedName, this.myPropertyName) || this.myPropertyName.equals(importedName)) || importedName == null && GroovyPropertyUtils.isSimplePropertyGetter((PsiMethod)element, this.myPropertyName)) : element instanceof PsiMethod && (importedName != null && GroovyPropertyUtils.isSimplePropertySetter((PsiMethod)element, null) && (AccessorResolverProcessor.isAppropriatePropertyNameForSetter(importedName, this.myPropertyName) || this.myPropertyName.equals(importedName)) || importedName == null && GroovyPropertyUtils.isSimplePropertySetter((PsiMethod)element, this.myPropertyName))) {
            return this.addAccessor((PsiMethod)element, state);
        }
        return true;
    }

    private static boolean isAppropriatePropertyNameForSetter(@NotNull String importedName, @NotNull String propertyName) {
        if (importedName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/resolve/processors/AccessorResolverProcessor", "isAppropriatePropertyNameForSetter"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/resolve/processors/AccessorResolverProcessor", "isAppropriatePropertyNameForSetter"));
        }
        propertyName = GroovyPropertyUtils.decapitalize(propertyName);
        return propertyName.equals(GroovyPropertyUtils.getPropertyNameBySetterName(importedName));
    }

    private static boolean isAppropriatePropertyNameForGetter(@NotNull PsiMethod getter, @NotNull String importedNameForGetter, @NotNull String propertyName) {
        if (getter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/resolve/processors/AccessorResolverProcessor", "isAppropriatePropertyNameForGetter"));
        }
        if (importedNameForGetter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/resolve/processors/AccessorResolverProcessor", "isAppropriatePropertyNameForGetter"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/resolve/processors/AccessorResolverProcessor", "isAppropriatePropertyNameForGetter"));
        }
        propertyName = GroovyPropertyUtils.decapitalize(propertyName);
        return propertyName.equals(AccessorResolverProcessor.getPropertyNameByGetter(getter, importedNameForGetter));
    }

    @Nullable
    private static String getPropertyNameByGetter(PsiMethod element, String importedName) {
        return GroovyPropertyUtils.getPropertyNameByGetterName(importedName, AccessorResolverProcessor.isBoolean(element));
    }

    private static boolean isBoolean(PsiMethod method) {
        return method.getReturnType() == PsiType.BOOLEAN;
    }

    private boolean addAccessor(PsiMethod method, ResolveState state) {
        PsiSubstitutor substitutor = (PsiSubstitutor)state.get(PsiSubstitutor.KEY);
        if (substitutor == null) {
            substitutor = PsiSubstitutor.EMPTY;
        }
        if (this.mySubstitutorComputer != null) {
            substitutor = this.mySubstitutorComputer.obtainSubstitutor(substitutor, method, state);
        }
        boolean isAccessible = this.isAccessible((PsiNamedElement)method);
        PsiElement resolveContext = (PsiElement)state.get(RESOLVE_CONTEXT);
        SpreadState spreadState = (SpreadState)state.get(SpreadState.SPREAD_STATE);
        boolean isStaticsOK = this.isStaticsOK((PsiNamedElement)method, resolveContext, false);
        GroovyResolveResultImpl candidate = new GroovyResolveResultImpl((PsiElement)method, resolveContext, spreadState, substitutor, isAccessible, isStaticsOK, true, true);
        if (isAccessible && isStaticsOK) {
            this.addCandidate(candidate);
            return method instanceof GrGdkMethod;
        }
        this.myInapplicableCandidates.add(candidate);
        return true;
    }

    @Override
    @NotNull
    public GroovyResolveResult[] getCandidates() {
        boolean hasApplicableCandidates = this.hasApplicableCandidates();
        GroovyResolveResult[] candidates = super.getCandidates();
        if (hasApplicableCandidates) {
            if (candidates.length <= 1) {
                if (candidates == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/AccessorResolverProcessor", "getCandidates"));
                }
                return candidates;
            }
            GroovyResolveResult[] groovyResolveResultArray = new GroovyResolveResult[]{candidates[0]};
            if (groovyResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/AccessorResolverProcessor", "getCandidates"));
            }
            return groovyResolveResultArray;
        }
        if (candidates == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/AccessorResolverProcessor", "getCandidates"));
        }
        return candidates;
    }
}

