/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.ast;

import com.google.common.collect.ImmutableMap;
import com.intellij.psi.PsiAnnotation;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightField;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightModifierList;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ast.AstTransformContributor;

public class LoggingContributor
extends AstTransformContributor {
    private static final ImmutableMap<String, String> ourLoggers = ImmutableMap.builder().put((Object)"groovy.util.logging.Log", (Object)"java.util.logging.Logger").put((Object)"groovy.util.logging.Commons", (Object)"org.apache.commons.logging.Log").put((Object)"groovy.util.logging.Log4j", (Object)"org.apache.log4j.Logger").put((Object)"groovy.util.logging.Slf4j", (Object)"org.slf4j.Logger").build();

    @Override
    public void collectFields(@NotNull GrTypeDefinition psiClass, @NotNull Collection<GrField> collector) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/resolve/ast/LoggingContributor", "collectFields"));
        }
        if (collector == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/resolve/ast/LoggingContributor", "collectFields"));
        }
        GrModifierList modifierList = psiClass.getModifierList();
        if (modifierList == null) {
            return;
        }
        for (GrAnnotation annotation : modifierList.getAnnotations()) {
            String qname = annotation.getQualifiedName();
            String logger = (String)ourLoggers.get((Object)qname);
            if (logger == null) continue;
            String fieldName = PsiUtil.getAnnoAttributeValue((PsiAnnotation)annotation, "value", "log");
            GrLightField field = new GrLightField(psiClass, fieldName, logger);
            field.setNavigationElement(annotation);
            ((GrLightModifierList)field.getModifierList()).setModifiers("private", "final", "static");
            field.setOriginInfo("created by @" + annotation.getShortName());
            collector.add(field);
        }
    }
}

