/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.util.LightCacheKey;

public class GrImportUtil {
    private static final LightCacheKey<MultiMap<String, String>> KEY = LightCacheKey.createByFileModificationCount();

    public static boolean acceptName(GrReferenceElement ref, String expected) {
        String actual = ref.getReferenceName();
        if (expected.equals(actual)) {
            return true;
        }
        if (ref.getQualifier() != null) {
            return false;
        }
        PsiFile file = ref.getContainingFile();
        if (file instanceof GroovyFile) {
            MultiMap<String, String> data = KEY.getCachedValue((PsiElement)file);
            if (data == null) {
                data = GrImportUtil.collectAliases((GroovyFile)file);
                KEY.putCachedValue((PsiElement)file, data);
            }
            Collection aliases = data.get((Object)expected);
            return aliases.contains(actual);
        }
        return false;
    }

    @NotNull
    private static MultiMap<String, String> collectAliases(@NotNull GroovyFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/util/GrImportUtil", "collectAliases"));
        }
        MultiMap aliases = MultiMap.createSet();
        for (GrImportStatement anImport : file.getImportStatements()) {
            String refName;
            GrCodeReferenceElement importReference;
            if (!anImport.isAliasedImport() || (importReference = anImport.getImportReference()) == null || (refName = importReference.getReferenceName()) == null) continue;
            aliases.putValue((Object)refName, (Object)anImport.getImportedName());
        }
        MultiMap multiMap = aliases;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/util/GrImportUtil", "collectAliases"));
        }
        return multiMap;
    }
}

