/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;

public class GrGenericTypeConverter
extends GrTypeConverter {
    @Override
    public boolean isAllowedInMethodCall() {
        return true;
    }

    @Override
    public Boolean isConvertible(@NotNull PsiType ltype, @NotNull PsiType rtype, @NotNull GroovyPsiElement context) {
        if (ltype == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrGenericTypeConverter", "isConvertible"));
        }
        if (rtype == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrGenericTypeConverter", "isConvertible"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrGenericTypeConverter", "isConvertible"));
        }
        if (!(ltype instanceof PsiClassType) || !(rtype instanceof PsiClassType)) {
            return null;
        }
        PsiClass lclass = ((PsiClassType)ltype).resolve();
        PsiClass rclass = ((PsiClassType)rtype).resolve();
        if (lclass == null || rclass == null) {
            return null;
        }
        if (lclass.getTypeParameters().length == 0) {
            return null;
        }
        if (!InheritanceUtil.isInheritorOrSelf((PsiClass)rclass, (PsiClass)lclass, (boolean)true)) {
            return null;
        }
        PsiClassType.ClassResolveResult lresult = ((PsiClassType)ltype).resolveGenerics();
        PsiClassType.ClassResolveResult rresult = ((PsiClassType)rtype).resolveGenerics();
        if (GrGenericTypeConverter.typeParametersAgree(lclass, rclass, lresult.getSubstitutor(), rresult.getSubstitutor(), context)) {
            return Boolean.TRUE;
        }
        return null;
    }

    private static boolean typeParametersAgree(@NotNull PsiClass leftClass, @NotNull PsiClass rightClass, @NotNull PsiSubstitutor leftSubstitutor, @NotNull PsiSubstitutor rightSubstitutor, @NotNull PsiElement context) {
        if (leftClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrGenericTypeConverter", "typeParametersAgree"));
        }
        if (rightClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrGenericTypeConverter", "typeParametersAgree"));
        }
        if (leftSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrGenericTypeConverter", "typeParametersAgree"));
        }
        if (rightSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrGenericTypeConverter", "typeParametersAgree"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrGenericTypeConverter", "typeParametersAgree"));
        }
        if (!leftClass.hasTypeParameters()) {
            return true;
        }
        if (!leftClass.getManager().areElementsEquivalent((PsiElement)leftClass, (PsiElement)rightClass)) {
            rightSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)leftClass, (PsiClass)rightClass, (PsiSubstitutor)rightSubstitutor);
            rightClass = leftClass;
        } else if (!rightClass.hasTypeParameters()) {
            return true;
        }
        Iterator li = PsiUtil.typeParametersIterator((PsiTypeParameterListOwner)leftClass);
        Iterator ri = PsiUtil.typeParametersIterator((PsiTypeParameterListOwner)rightClass);
        while (li.hasNext()) {
            if (!ri.hasNext()) {
                return false;
            }
            PsiTypeParameter lp = (PsiTypeParameter)li.next();
            PsiTypeParameter rp = (PsiTypeParameter)ri.next();
            PsiType typeLeft = leftSubstitutor.substitute(lp);
            if (typeLeft == null) continue;
            PsiType typeRight = rightSubstitutor.substituteWithBoundsPromotion(rp);
            if (typeRight == null) {
                return true;
            }
            if (!(typeLeft instanceof PsiClassType && typeRight instanceof PsiClassType ? !TypesUtil.isAssignableByMethodCallConversion(typeLeft, typeRight, context) : !TypeConversionUtil.typesAgree((PsiType)typeLeft, (PsiType)typeRight, (boolean)true))) continue;
            return false;
        }
        return true;
    }
}

