/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMirrorElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.AbstractClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.SignatureHintProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class ClosureParamsEnhancer
extends AbstractClosureParameterEnhancer {
    @Override
    @Nullable
    protected PsiType getClosureParameterType(GrClosableBlock closure, int index) {
        if (!GroovyConfigUtils.getInstance().isVersionAtLeast(closure, "2.3")) {
            return null;
        }
        GrParameter[] parameters = closure.getAllParameters();
        if (ClosureParamsEnhancer.containsParametersWithDeclaredType(parameters)) {
            return null;
        }
        List<PsiType[]> fittingSignatures = ClosureParamsEnhancer.findFittingSignatures(closure);
        if (fittingSignatures.size() == 1) {
            PsiType[] expectedSignature = fittingSignatures.get(0);
            return expectedSignature[index];
        }
        return null;
    }

    @NotNull
    public static List<PsiType[]> findFittingSignatures(GrClosableBlock closure) {
        final GrParameter[] parameters = closure.getAllParameters();
        GrCall call = ClosureParamsEnhancer.findCall(closure);
        if (call == null) {
            List<PsiType[]> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/ClosureParamsEnhancer", "findFittingSignatures"));
            }
            return list;
        }
        GroovyResolveResult resolveResult = call.advancedResolve();
        PsiElement element = resolveResult.getElement();
        if (!(element instanceof PsiMethod)) {
            List<PsiType[]> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/ClosureParamsEnhancer", "findFittingSignatures"));
            }
            return list;
        }
        while (element instanceof PsiMirrorElement) {
            element = ((PsiMirrorElement)element).getPrototype();
        }
        List<Pair<PsiParameter, PsiType>> params = ResolveUtil.collectExpectedParamsByArg(closure, new GroovyResolveResult[]{resolveResult}, call.getNamedArguments(), call.getExpressionArguments(), call.getClosureArguments(), closure);
        if (params.isEmpty()) {
            List<PsiType[]> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/ClosureParamsEnhancer", "findFittingSignatures"));
            }
            return list;
        }
        Pair<PsiParameter, PsiType> pair = params.get(0);
        PsiParameter param = (PsiParameter)pair.getFirst();
        PsiModifierList modifierList = param.getModifierList();
        if (modifierList == null) {
            List<PsiType[]> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/ClosureParamsEnhancer", "findFittingSignatures"));
            }
            return list;
        }
        PsiAnnotation anno = modifierList.findAnnotation("groovy.transform.stc.ClosureParams");
        if (anno == null) {
            List<PsiType[]> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/ClosureParamsEnhancer", "findFittingSignatures"));
            }
            return list;
        }
        PsiClass closureSignatureHint = GrAnnotationUtil.inferClassAttribute(anno, "value");
        if (closureSignatureHint == null) {
            List<PsiType[]> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/ClosureParamsEnhancer", "findFittingSignatures"));
            }
            return list;
        }
        String qnameOfClosureSignatureHint = closureSignatureHint.getQualifiedName();
        if (qnameOfClosureSignatureHint == null) {
            List<PsiType[]> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/ClosureParamsEnhancer", "findFittingSignatures"));
            }
            return list;
        }
        SignatureHintProcessor signatureHintProcessor = SignatureHintProcessor.getHintProcessor(qnameOfClosureSignatureHint);
        if (signatureHintProcessor == null) {
            List<PsiType[]> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/ClosureParamsEnhancer", "findFittingSignatures"));
            }
            return list;
        }
        List<PsiType[]> expectedSignatures = signatureHintProcessor.inferExpectedSignatures((PsiMethod)element, resolveResult.getSubstitutor(), SignatureHintProcessor.buildOptions(anno));
        List list = ContainerUtil.findAll(expectedSignatures, (Condition)new Condition<PsiType[]>(){

            public boolean value(PsiType[] types) {
                return types.length == parameters.length;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/ClosureParamsEnhancer", "findFittingSignatures"));
        }
        return list;
    }

    private static boolean containsParametersWithDeclaredType(GrParameter[] parameters) {
        return ContainerUtil.find((Object[])parameters, (Condition)new Condition<GrParameter>(){

            public boolean value(GrParameter parameter) {
                return parameter.getDeclaredType() != null;
            }
        }) != null;
    }

    @Nullable
    private static GrCall findCall(@NotNull GrClosableBlock closure) {
        PsiElement pparent;
        if (closure == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/ClosureParamsEnhancer", "findCall"));
        }
        PsiElement parent = closure.getParent();
        if (parent instanceof GrCall && ArrayUtil.contains((Object)closure, (Object[])((GrCall)parent).getClosureArguments())) {
            return (GrCall)parent;
        }
        if (parent instanceof GrArgumentList && (pparent = parent.getParent()) instanceof GrCall) {
            return (GrCall)pparent;
        }
        return null;
    }
}

