/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs.elements;

import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrMethodStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrStubUtils;
import org.jetbrains.plugins.groovy.lang.psi.stubs.elements.GrStubElementType;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrAnnotatedMemberIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrMethodNameIndex;

public abstract class GrMethodElementType
extends GrStubElementType<GrMethodStub, GrMethod> {
    public GrMethodElementType(String debugName) {
        super(debugName);
    }

    public GrMethodStub createStub(@NotNull GrMethod psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrMethodElementType", "createStub"));
        }
        Set<String> namedParameters = psi.getNamedParameters().keySet();
        return new GrMethodStub(parentStub, StringRef.fromString((String)psi.getName()), GrStubUtils.getAnnotationNames(psi), ArrayUtil.toStringArray(namedParameters), this, GrStubUtils.getTypeText(psi.getReturnTypeElementGroovy()), GrMethodStub.buildFlags(psi));
    }

    public void serialize(@NotNull GrMethodStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrMethodElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrMethodElementType", "serialize"));
        }
        dataStream.writeName(stub.getName());
        GrStubUtils.writeStringArray(dataStream, stub.getAnnotations());
        GrStubUtils.writeStringArray(dataStream, stub.getNamedParameters());
        GrStubUtils.writeNullableString(dataStream, stub.getTypeText());
        dataStream.writeByte((int)stub.getFlags());
    }

    @NotNull
    public GrMethodStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrMethodElementType", "deserialize"));
        }
        StringRef ref = dataStream.readName();
        String[] annNames = GrStubUtils.readStringArray(dataStream);
        String[] namedParameters = GrStubUtils.readStringArray(dataStream);
        String typeText = GrStubUtils.readNullableString(dataStream);
        byte flags = dataStream.readByte();
        GrMethodStub grMethodStub = new GrMethodStub(parentStub, ref, annNames, namedParameters, this, typeText, flags);
        if (grMethodStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrMethodElementType", "deserialize"));
        }
        return grMethodStub;
    }

    @Override
    public void indexStub(@NotNull GrMethodStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrMethodElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrMethodElementType", "indexStub"));
        }
        String name = stub.getName();
        sink.occurrence(GrMethodNameIndex.KEY, (Object)name);
        if (GrStubUtils.isGroovyStaticMemberStub(stub)) {
            sink.occurrence(JavaStubIndexKeys.JVM_STATIC_MEMBERS_NAMES, (Object)name);
            sink.occurrence(JavaStubIndexKeys.JVM_STATIC_MEMBERS_TYPES, (Object)GrStubUtils.getShortTypeText(stub.getTypeText()));
        }
        for (String annName : stub.getAnnotations()) {
            if (annName == null) continue;
            sink.occurrence(GrAnnotatedMemberIndex.KEY, (Object)annName);
        }
    }
}

