/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.types;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocReferenceElement;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameterList;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrReferenceElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.CompletionProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ResolverProcessor;

public class GrCodeReferenceElementImpl
extends GrReferenceElementImpl<GrCodeReferenceElement>
implements GrCodeReferenceElement {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.lang.psi.impl.types.GrCodeReferenceElementImpl");
    private static final OurResolver RESOLVER = new OurResolver();

    public GrCodeReferenceElementImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public PsiElement handleElementRenameSimple(String newElementName) throws IncorrectOperationException {
        if (StringUtil.isJavaIdentifier((String)newElementName)) {
            return super.handleElementRenameSimple(newElementName);
        }
        throw new IncorrectOperationException("Cannot rename reference to '" + newElementName + "'");
    }

    protected GrCodeReferenceElement bindWithQualifiedRef(@NotNull String qName) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl", "bindWithQualifiedRef"));
        }
        GrCodeReferenceElement qualifiedRef = GroovyPsiElementFactory.getInstance(this.getProject()).createTypeOrPackageReference(qName);
        GrTypeArgumentList list = this.getTypeArgumentList();
        if (list != null) {
            qualifiedRef.getNode().addChild(list.copy().getNode());
        }
        this.getNode().getTreeParent().replaceChild(this.getNode(), qualifiedRef.getNode());
        return qualifiedRef;
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitCodeReferenceElement(this);
    }

    public String toString() {
        return "Reference element";
    }

    @Override
    public GrCodeReferenceElement getQualifier() {
        return (GrCodeReferenceElement)this.findChildByType(GroovyElementTypes.REFERENCE_ELEMENT);
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return this.findChildByType(TokenSets.CODE_REFERENCE_ELEMENT_NAME_TOKENS);
    }

    @Override
    @Nullable
    public PsiElement resolve() {
        GroovyResolveResult[] results = TypeInferenceHelper.getCurrentContext().multiResolve(this, false, RESOLVER);
        return results.length == 1 ? results[0].getElement() : null;
    }

    private ReferenceKind getKind(boolean forCompletion) {
        if (this.isClassReferenceForNew()) {
            return ReferenceKind.CLASS_OR_PACKAGE;
        }
        PsiElement parent = this.getParent();
        if (parent instanceof GrCodeReferenceElementImpl) {
            ReferenceKind parentKind = ((GrCodeReferenceElementImpl)parent).getKind(forCompletion);
            if (parentKind == ReferenceKind.CLASS) {
                return ReferenceKind.CLASS_OR_PACKAGE;
            }
            if (parentKind == ReferenceKind.STATIC_MEMBER_FQ) {
                return this.isQualified() ? ReferenceKind.CLASS_FQ : ReferenceKind.CLASS;
            }
            if (parentKind == ReferenceKind.CLASS_FQ) {
                return ReferenceKind.CLASS_OR_PACKAGE_FQ;
            }
            return parentKind;
        }
        if (parent instanceof GrPackageDefinition) {
            return ReferenceKind.PACKAGE_FQ;
        }
        if (parent instanceof GrDocReferenceElement) {
            return ReferenceKind.CLASS_OR_PACKAGE;
        }
        if (parent instanceof GrImportStatement) {
            GrImportStatement importStatement = (GrImportStatement)parent;
            if (importStatement.isStatic()) {
                return importStatement.isOnDemand() ? ReferenceKind.CLASS : ReferenceKind.STATIC_MEMBER_FQ;
            }
            return forCompletion || importStatement.isOnDemand() ? ReferenceKind.CLASS_OR_PACKAGE_FQ : ReferenceKind.CLASS_FQ;
        }
        if (parent instanceof GrNewExpression || parent instanceof GrAnonymousClassDefinition) {
            PsiElement newExpr;
            PsiElement psiElement = newExpr = parent instanceof GrAnonymousClassDefinition ? parent.getParent() : parent;
            assert (newExpr instanceof GrNewExpression);
            if (((GrNewExpression)newExpr).getQualifier() != null) {
                return ReferenceKind.CLASS_IN_QUALIFIED_NEW;
            }
        }
        return ReferenceKind.CLASS;
    }

    @NotNull
    public String getCanonicalText() {
        ReferenceKind kind = this.getKind(false);
        switch (kind) {
            case CLASS: 
            case CLASS_IN_QUALIFIED_NEW: 
            case CLASS_OR_PACKAGE: {
                PsiElement target = this.resolve();
                if (target instanceof PsiClass) {
                    PsiType[] types;
                    PsiClass aClass = (PsiClass)target;
                    String name = aClass.getQualifiedName();
                    if (name == null) {
                        name = aClass.getName();
                    }
                    if ((types = this.getTypeArguments()).length == 0) {
                        String string = name;
                        if (string == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl", "getCanonicalText"));
                        }
                        return string;
                    }
                    StringBuilder buf = new StringBuilder();
                    buf.append(name);
                    buf.append('<');
                    for (int i = 0; i < types.length; ++i) {
                        if (i > 0) {
                            buf.append(',');
                        }
                        buf.append(types[i].getCanonicalText());
                    }
                    buf.append('>');
                    String string = buf.toString();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl", "getCanonicalText"));
                    }
                    return string;
                }
                if (target instanceof PsiPackage) {
                    String string = ((PsiPackage)target).getQualifiedName();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl", "getCanonicalText"));
                    }
                    return string;
                }
                LOG.assertTrue(target == null);
                String string = this.getTextSkipWhiteSpaceAndComments();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl", "getCanonicalText"));
                }
                return string;
            }
            case CLASS_FQ: 
            case CLASS_OR_PACKAGE_FQ: 
            case PACKAGE_FQ: 
            case STATIC_MEMBER_FQ: {
                String string = this.getTextSkipWhiteSpaceAndComments();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl", "getCanonicalText"));
                }
                return string;
            }
        }
        LOG.assertTrue(false);
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl", "getCanonicalText"));
        }
        return null;
    }

    @Override
    protected boolean bindsCorrectly(PsiElement element) {
        PsiMethod method;
        PsiElement resolved;
        if (super.bindsCorrectly(element)) {
            return true;
        }
        return element instanceof PsiClass && (resolved = this.resolve()) instanceof PsiMethod && (method = (PsiMethod)resolved).isConstructor() && this.getManager().areElementsEquivalent(element, (PsiElement)method.getContainingClass());
    }

    @Override
    public boolean isFullyQualified() {
        switch (this.getKind(false)) {
            case CLASS_OR_PACKAGE: 
            case CLASS_FQ: 
            case CLASS_OR_PACKAGE_FQ: 
            case PACKAGE_FQ: 
            case STATIC_MEMBER_FQ: {
                if (!(this.resolve() instanceof PsiPackage)) break;
                return true;
            }
        }
        GrCodeReferenceElement qualifier = this.getQualifier();
        return qualifier != null && ((GrCodeReferenceElementImpl)qualifier).isFullyQualified();
    }

    public boolean isReferenceTo(PsiElement element) {
        PsiManagerEx manager = this.getManager();
        if (element instanceof PsiNamedElement && this.getParent() instanceof GrImportStatement) {
            GroovyResolveResult[] results;
            for (GroovyResolveResult result : results = this.multiResolve(false)) {
                if (!manager.areElementsEquivalent(result.getElement(), element)) continue;
                return true;
            }
        }
        return manager.areElementsEquivalent(element, this.resolve());
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    private boolean isClassReferenceForNew() {
        PsiElement parent = this.getParent();
        while (parent instanceof GrCodeReferenceElement) {
            parent = parent.getParent();
        }
        return parent instanceof GrNewExpression;
    }

    private static void feedLookupElements(PsiNamedElement psi, boolean afterNew, Consumer<LookupElement> consumer, PrefixMatcher matcher) {
        for (LookupElement lookupElement : GroovyCompletionUtil.createLookupElements(new GroovyResolveResultImpl((PsiElement)psi, true), afterNew, matcher, null)) {
            consumer.consume((Object)lookupElement);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processVariantsImpl(ReferenceKind kind, Consumer<LookupElement> consumer, PrefixMatcher matcher) {
        boolean afterNew = JavaClassNameCompletionContributor.AFTER_NEW.accepts((Object)this);
        switch (kind) {
            case STATIC_MEMBER_FQ: {
                PsiElement resolve;
                GrCodeReferenceElement qualifier = this.getQualifier();
                if (qualifier != null && (resolve = qualifier.resolve()) instanceof PsiClass) {
                    PsiClass clazz = (PsiClass)resolve;
                    for (PsiField psiField : clazz.getFields()) {
                        if (!psiField.hasModifierProperty("static")) continue;
                        GrCodeReferenceElementImpl.feedLookupElements((PsiNamedElement)psiField, afterNew, consumer, matcher);
                    }
                    for (PsiField psiField : clazz.getMethods()) {
                        if (!psiField.hasModifierProperty("static")) continue;
                        GrCodeReferenceElementImpl.feedLookupElements((PsiNamedElement)psiField, afterNew, consumer, matcher);
                    }
                    for (PsiField psiField : clazz.getInnerClasses()) {
                        if (!psiField.hasModifierProperty("static")) continue;
                        GrCodeReferenceElementImpl.feedLookupElements((PsiNamedElement)psiField, afterNew, consumer, matcher);
                    }
                    return;
                }
            }
            case CLASS_FQ: 
            case CLASS_OR_PACKAGE_FQ: 
            case PACKAGE_FQ: {
                String refText = PsiUtil.getQualifiedReferenceText(this);
                LOG.assertTrue(refText != null, (Object)this.getText());
                String parentPackageFQName = StringUtil.getPackageName((String)refText);
                PsiPackage parentPackage = JavaPsiFacade.getInstance((Project)this.getProject()).findPackage(parentPackageFQName);
                if (parentPackage != null) {
                    void var11_38;
                    void var11_36;
                    GlobalSearchScope scope = this.getResolveScope();
                    if (kind == ReferenceKind.PACKAGE_FQ) {
                        void var11_32;
                        PsiPackage[] arr$ = parentPackage.getSubPackages(scope);
                        int len$ = arr$.length;
                        boolean bl = false;
                        while (var11_32 < len$) {
                            PsiPackage psiPackage = arr$[var11_32];
                            GrCodeReferenceElementImpl.feedLookupElements((PsiNamedElement)psiPackage, afterNew, consumer, matcher);
                            ++var11_32;
                        }
                        return;
                    }
                    if (kind == ReferenceKind.CLASS_FQ) {
                        void var11_34;
                        PsiClass[] arr$ = parentPackage.getClasses(scope);
                        int len$ = arr$.length;
                        boolean bl = false;
                        while (var11_34 < len$) {
                            PsiClass psiClass = arr$[var11_34];
                            GrCodeReferenceElementImpl.feedLookupElements((PsiNamedElement)psiClass, afterNew, consumer, matcher);
                            ++var11_34;
                        }
                        return;
                    }
                    PsiPackage[] arr$ = parentPackage.getSubPackages(scope);
                    int len$ = arr$.length;
                    boolean bl = false;
                    while (var11_36 < len$) {
                        PsiPackage psiPackage = arr$[var11_36];
                        GrCodeReferenceElementImpl.feedLookupElements((PsiNamedElement)psiPackage, afterNew, consumer, matcher);
                        ++var11_36;
                    }
                    arr$ = parentPackage.getClasses(scope);
                    len$ = arr$.length;
                    boolean bl2 = false;
                    while (var11_38 < len$) {
                        PsiPackage psiPackage = arr$[var11_38];
                        GrCodeReferenceElementImpl.feedLookupElements((PsiNamedElement)psiPackage, afterNew, consumer, matcher);
                        ++var11_38;
                    }
                    return;
                }
            }
            case CLASS: 
            case CLASS_IN_QUALIFIED_NEW: 
            case CLASS_OR_PACKAGE: {
                GrCodeReferenceElement qualifier = this.getQualifier();
                if (qualifier != null) {
                    PsiElement qualifierResolved = qualifier.resolve();
                    if (qualifierResolved instanceof PsiPackage) {
                        PsiPackage aPackage = (PsiPackage)qualifierResolved;
                        for (PsiClass psiClass : aPackage.getClasses(this.getResolveScope())) {
                            GrCodeReferenceElementImpl.feedLookupElements((PsiNamedElement)psiClass, afterNew, consumer, matcher);
                        }
                        if (kind == ReferenceKind.CLASS) {
                            return;
                        }
                        for (PsiClass psiClass : aPackage.getSubPackages(this.getResolveScope())) {
                            GrCodeReferenceElementImpl.feedLookupElements((PsiNamedElement)psiClass, afterNew, consumer, matcher);
                        }
                    } else {
                        if (!(qualifierResolved instanceof PsiClass)) break;
                        for (PsiClass aClass : ((PsiClass)qualifierResolved).getInnerClasses()) {
                            GrCodeReferenceElementImpl.feedLookupElements((PsiNamedElement)aClass, afterNew, consumer, matcher);
                        }
                    }
                } else {
                    ResolverProcessor classProcessor = CompletionProcessor.createClassCompletionProcessor(this);
                    this.processTypeParametersFromUnfinishedMethodOrField(classProcessor);
                    ResolveUtil.treeWalkUp(this, classProcessor, false);
                    for (LookupElement o : GroovyCompletionUtil.getCompletionVariants(classProcessor.getCandidates(), afterNew, matcher, (PsiElement)this)) {
                        consumer.consume((Object)o);
                    }
                }
                break;
            }
        }
    }

    private void processTypeParametersFromUnfinishedMethodOrField(@NotNull ResolverProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl", "processTypeParametersFromUnfinishedMethodOrField"));
        }
        PsiElement candidate = this.findTypeParameterListCandidate();
        if (candidate instanceof GrTypeParameterList) {
            for (GrTypeParameter p : ((GrTypeParameterList)candidate).getTypeParameters()) {
                ResolveUtil.processElement(processor, p, ResolveState.initial());
            }
        }
    }

    @Nullable
    private PsiElement findTypeParameterListCandidate() {
        PsiElement errorElement;
        GrTypeElement typeElement = this.getRootTypeElement();
        if (typeElement == null) {
            return null;
        }
        if (typeElement.getParent() instanceof GrTypeDefinitionBody) {
            return PsiUtil.skipWhitespacesAndComments(typeElement.getPrevSibling(), false);
        }
        if (typeElement.getParent() instanceof GrVariableDeclaration && (errorElement = PsiUtil.skipWhitespacesAndComments(typeElement.getPrevSibling(), false)) instanceof PsiErrorElement) {
            return errorElement.getFirstChild();
        }
        return null;
    }

    @Nullable
    private GrTypeElement getRootTypeElement() {
        PsiElement parent = this.getParent();
        while (GrCodeReferenceElementImpl.isTypeElementChild(parent)) {
            if (parent instanceof GrTypeElement && !GrCodeReferenceElementImpl.isTypeElementChild(parent.getParent())) {
                return (GrTypeElement)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    private static boolean isTypeElementChild(PsiElement element) {
        return element instanceof GrCodeReferenceElement || element instanceof GrTypeArgumentList || element instanceof GrTypeElement;
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    public GroovyResolveResult advancedResolve() {
        GroovyResolveResult[] results = TypeInferenceHelper.getCurrentContext().multiResolve(this, false, RESOLVER);
        return results.length == 1 ? results[0] : GroovyResolveResult.EMPTY_RESULT;
    }

    @Override
    @NotNull
    public GroovyResolveResult[] multiResolve(boolean incompleteCode) {
        GroovyResolveResult[] results = TypeInferenceHelper.getCurrentContext().multiResolve(this, incompleteCode, RESOLVER);
        if (results.length == 0) {
            if (GroovyResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl", "multiResolve"));
            }
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        GroovyResolveResult[] groovyResolveResultArray = results;
        if (groovyResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl", "multiResolve"));
        }
        return groovyResolveResultArray;
    }

    @Override
    public void processVariants(PrefixMatcher matcher, CompletionParameters parameters, Consumer<LookupElement> consumer) {
        this.processVariantsImpl(this.getKind(true), consumer, matcher);
    }

    @Override
    @NotNull
    public PsiType[] getTypeArguments() {
        GrTypeArgumentList typeArgumentList = this.getTypeArgumentList();
        if (typeArgumentList != null && typeArgumentList.isDiamond()) {
            PsiType[] psiTypeArray = this.inferDiamondTypeArguments();
            if (psiTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl", "getTypeArguments"));
            }
            return psiTypeArray;
        }
        PsiType[] psiTypeArray = super.getTypeArguments();
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl", "getTypeArguments"));
        }
        return psiTypeArray;
    }

    private PsiType[] inferDiamondTypeArguments() {
        PsiElement parent = this.getParent();
        if (!(parent instanceof GrNewExpression)) {
            return PsiType.EMPTY_ARRAY;
        }
        PsiType lType = PsiImplUtil.inferExpectedTypeForDiamond((GrNewExpression)parent);
        if (lType instanceof PsiClassType) {
            return ((PsiClassType)lType).getParameters();
        }
        return PsiType.EMPTY_ARRAY;
    }

    private static class OurResolver
    implements ResolveCache.PolyVariantResolver<GrCodeReferenceElementImpl> {
        private OurResolver() {
        }

        @NotNull
        public GroovyResolveResult[] resolve(@NotNull GrCodeReferenceElementImpl reference, boolean incompleteCode) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "resolve"));
            }
            if (reference.getReferenceName() == null) {
                if (GroovyResolveResult.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "resolve"));
                }
                return GroovyResolveResult.EMPTY_ARRAY;
            }
            GroovyResolveResult[] results = OurResolver._resolve(reference, (PsiManager)reference.getManager(), reference.getKind(false));
            if (results.length == 0) {
                if (results == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "resolve"));
                }
                return results;
            }
            ArrayList<GroovyResolveResultImpl> imported = new ArrayList<GroovyResolveResultImpl>();
            PsiType[] args = reference.getTypeArguments();
            for (int i = 0; i < results.length; ++i) {
                GroovyResolveResult result = results[i];
                PsiElement element = result.getElement();
                if (!(element instanceof PsiClass)) continue;
                PsiSubstitutor substitutor = result.getSubstitutor();
                PsiSubstitutor newSubstitutor = substitutor.putAll((PsiClass)element, args);
                PsiElement context = result.getCurrentFileResolveContext();
                GroovyResolveResultImpl newResult = new GroovyResolveResultImpl(element, context, null, newSubstitutor, result.isAccessible(), result.isStaticsOK());
                results[i] = newResult;
                if (!(context instanceof GrImportStatement)) continue;
                imported.add(newResult);
            }
            if (!imported.isEmpty()) {
                GroovyResolveResult[] groovyResolveResultArray = imported.toArray(new GroovyResolveResult[imported.size()]);
                if (groovyResolveResultArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "resolve"));
                }
                return groovyResolveResultArray;
            }
            if (results == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "resolve"));
            }
            return results;
        }

        @NotNull
        private static GroovyResolveResult[] _resolve(GrCodeReferenceElementImpl ref, PsiManager manager, ReferenceKind kind) {
            String refName = ref.getReferenceName();
            if (refName == null) {
                if (GroovyResolveResult.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "_resolve"));
                }
                return GroovyResolveResult.EMPTY_ARRAY;
            }
            switch (kind) {
                case CLASS_FQ: 
                case CLASS_OR_PACKAGE_FQ: 
                case PACKAGE_FQ: {
                    PsiPackage aPackage;
                    String qName = PsiUtil.getQualifiedReferenceText(ref);
                    LOG.assertTrue(qName != null, (Object)ref.getText());
                    JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
                    if (kind == ReferenceKind.CLASS_OR_PACKAGE_FQ || kind == ReferenceKind.CLASS_FQ) {
                        PsiClass aClass;
                        PsiFile file = ref.getContainingFile();
                        if ((qName.indexOf(46) > 0 || file instanceof GroovyFile && ((GroovyFile)file).getPackageName().length() == 0) && (aClass = facade.findClass(qName, ref.getResolveScope())) != null) {
                            boolean isAccessible = PsiUtil.isAccessible(ref, (PsiMember)aClass);
                            GroovyResolveResult[] groovyResolveResultArray = new GroovyResolveResult[]{new GroovyResolveResultImpl((PsiElement)aClass, isAccessible)};
                            if (groovyResolveResultArray == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "_resolve"));
                            }
                            return groovyResolveResultArray;
                        }
                    }
                    if (kind != ReferenceKind.CLASS_OR_PACKAGE_FQ && kind != ReferenceKind.PACKAGE_FQ || (aPackage = facade.findPackage(qName)) == null) break;
                    GroovyResolveResult[] groovyResolveResultArray = new GroovyResolveResult[]{new GroovyResolveResultImpl((PsiElement)aPackage, true)};
                    if (groovyResolveResultArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "_resolve"));
                    }
                    return groovyResolveResultArray;
                }
                case CLASS: {
                    PsiPackage pkg;
                    EnumSet<ClassHint.ResolveKind> kinds = kind == ReferenceKind.CLASS ? ResolverProcessor.RESOLVE_KINDS_CLASS : ResolverProcessor.RESOLVE_KINDS_CLASS_PACKAGE;
                    ClassResolverProcessor processor = new ClassResolverProcessor(refName, ref, kinds);
                    GrCodeReferenceElement qualifier = ref.getQualifier();
                    if (qualifier != null) {
                        PsiElement qualifierResolved = qualifier.resolve();
                        if (!(qualifierResolved instanceof PsiPackage) && !(qualifierResolved instanceof PsiClass)) break;
                        qualifierResolved.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), null, (PsiElement)ref);
                        GroovyResolveResult[] groovyResolveResultArray = processor.getCandidates();
                        if (groovyResolveResultArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "_resolve"));
                        }
                        return groovyResolveResultArray;
                    }
                    GrCodeReferenceElementImpl placeToStartWalking = OurResolver.isAnnotationRef(ref) ? FileContextUtil.getContextFile((PsiElement)ref) : ref;
                    ResolveUtil.treeWalkUp(placeToStartWalking, processor, false);
                    GroovyResolveResult[] candidates = processor.getCandidates();
                    if (candidates.length > 0) {
                        if (candidates == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "_resolve"));
                        }
                        return candidates;
                    }
                    if (kind != ReferenceKind.CLASS_OR_PACKAGE || (pkg = JavaPsiFacade.getInstance((Project)ref.getProject()).findPackage(refName)) == null) break;
                    GroovyResolveResult[] groovyResolveResultArray = new GroovyResolveResult[]{new GroovyResolveResultImpl((PsiElement)pkg, true)};
                    if (groovyResolveResultArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "_resolve"));
                    }
                    return groovyResolveResultArray;
                }
                case CLASS_OR_PACKAGE: {
                    GroovyResolveResult[] classResult = OurResolver._resolve(ref, manager, ReferenceKind.CLASS);
                    if (classResult.length == 1 && !classResult[0].isAccessible()) {
                        GroovyResolveResult[] packageResult = OurResolver._resolve(ref, manager, ReferenceKind.PACKAGE_FQ);
                        if (packageResult.length != 0) {
                            if (packageResult == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "_resolve"));
                            }
                            return packageResult;
                        }
                    } else if (classResult.length == 0) {
                        GroovyResolveResult[] groovyResolveResultArray = OurResolver._resolve(ref, manager, ReferenceKind.PACKAGE_FQ);
                        if (groovyResolveResultArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "_resolve"));
                        }
                        return groovyResolveResultArray;
                    }
                    if (classResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "_resolve"));
                    }
                    return classResult;
                }
                case STATIC_MEMBER_FQ: {
                    PsiElement resolved;
                    GrCodeReferenceElement qualifier = ref.getQualifier();
                    if (qualifier == null || !((resolved = qualifier.resolve()) instanceof PsiClass)) break;
                    PsiClass clazz = (PsiClass)resolved;
                    PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)clazz.getProject()).getResolveHelper();
                    ArrayList<GroovyResolveResult> result = new ArrayList<GroovyResolveResult>();
                    OurResolver.processFields(ref, refName, clazz, helper, result);
                    OurResolver.processMethods(ref, refName, clazz, helper, result);
                    OurResolver.processInnerClasses(ref, refName, clazz, helper, result);
                    if (result.isEmpty()) {
                        OurResolver.processAccessors(ref, refName, clazz, helper, result);
                    }
                    GroovyResolveResult[] groovyResolveResultArray = result.toArray(new GroovyResolveResult[result.size()]);
                    if (groovyResolveResultArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "_resolve"));
                    }
                    return groovyResolveResultArray;
                }
                case CLASS_IN_QUALIFIED_NEW: {
                    PsiClassType classType;
                    PsiClass psiClass;
                    if (ref.getParent() instanceof GrCodeReferenceElement) {
                        if (GroovyResolveResult.EMPTY_ARRAY == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "_resolve"));
                        }
                        return GroovyResolveResult.EMPTY_ARRAY;
                    }
                    GrNewExpression newExpression = (GrNewExpression)PsiTreeUtil.getParentOfType((PsiElement)ref, GrNewExpression.class);
                    assert (newExpression != null);
                    GrExpression qualifier = newExpression.getQualifier();
                    assert (qualifier != null);
                    PsiType type = qualifier.getType();
                    if (!(type instanceof PsiClassType) || (psiClass = (classType = (PsiClassType)type).resolve()) == null) break;
                    PsiClass[] allInnerClasses = psiClass.getAllInnerClasses();
                    ArrayList<GroovyResolveResultImpl> result = new ArrayList<GroovyResolveResultImpl>();
                    PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)ref.getProject()).getResolveHelper();
                    for (PsiClass innerClass : allInnerClasses) {
                        if (!refName.equals(innerClass.getName())) continue;
                        result.add(new GroovyResolveResultImpl((PsiElement)innerClass, helper.isAccessible((PsiMember)innerClass, (PsiElement)ref, null)));
                    }
                    GroovyResolveResult[] groovyResolveResultArray = result.toArray(new GroovyResolveResult[result.size()]);
                    if (groovyResolveResultArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "_resolve"));
                    }
                    return groovyResolveResultArray;
                }
            }
            if (GroovyResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver", "_resolve"));
            }
            return GroovyResolveResult.EMPTY_ARRAY;
        }

        private static boolean isAnnotationRef(GrCodeReferenceElement ref) {
            PsiElement parent = ref.getParent();
            return parent instanceof GrAnnotation || parent instanceof GrCodeReferenceElement && OurResolver.isAnnotationRef((GrCodeReferenceElement)parent);
        }

        private static void processAccessors(GrCodeReferenceElementImpl ref, String refName, PsiClass clazz, PsiResolveHelper helper, List<GroovyResolveResult> result) {
            String booleanGetter = GroovyPropertyUtils.getGetterNameBoolean(refName);
            String nonBooleanGetter = GroovyPropertyUtils.getGetterNameNonBoolean(refName);
            String setter = GroovyPropertyUtils.getSetterName(refName);
            OurResolver.processMethods(ref, booleanGetter, clazz, helper, result);
            if (!result.isEmpty()) {
                return;
            }
            OurResolver.processMethods(ref, nonBooleanGetter, clazz, helper, result);
            if (!result.isEmpty()) {
                return;
            }
            OurResolver.processMethods(ref, setter, clazz, helper, result);
        }

        private static void processInnerClasses(GrCodeReferenceElementImpl ref, String refName, PsiClass clazz, PsiResolveHelper helper, List<GroovyResolveResult> result) {
            PsiClass innerClass = clazz.findInnerClassByName(refName, true);
            if (innerClass != null && innerClass.hasModifierProperty("static")) {
                result.add(new GroovyResolveResultImpl((PsiElement)innerClass, helper.isAccessible((PsiMember)innerClass, (PsiElement)ref, null)));
            }
        }

        private static void processFields(GrCodeReferenceElementImpl ref, String refName, PsiClass clazz, PsiResolveHelper helper, List<GroovyResolveResult> result) {
            PsiField field = clazz.findFieldByName(refName, true);
            if (field != null && field.hasModifierProperty("static")) {
                result.add(new GroovyResolveResultImpl((PsiElement)field, helper.isAccessible((PsiMember)field, (PsiElement)ref, null)));
            }
        }

        private static void processMethods(GrCodeReferenceElementImpl ref, String refName, PsiClass clazz, PsiResolveHelper helper, List<GroovyResolveResult> result) {
            PsiMethod[] methods;
            for (PsiMethod method : methods = clazz.findMethodsByName(refName, true)) {
                result.add(new GroovyResolveResultImpl((PsiElement)method, helper.isAccessible((PsiMember)method, (PsiElement)ref, null)));
            }
        }
    }

    static enum ReferenceKind {
        CLASS,
        CLASS_OR_PACKAGE,
        PACKAGE_FQ,
        CLASS_FQ,
        CLASS_OR_PACKAGE_FQ,
        STATIC_MEMBER_FQ,
        CLASS_IN_QUALIFIED_NEW;

    }
}

