/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.cache.ModifierFlags;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifier;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrModifierListImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightAnnotation;

public class GrLightModifierList
extends LightElement
implements GrModifierList {
    private int myModifiers;
    private final List<GrAnnotation> myAnnotations;
    private final PsiElement myParent;

    public GrLightModifierList(@NotNull PsiElement parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightModifierList", "<init>"));
        }
        super(parent.getManager(), parent.getLanguage());
        this.myAnnotations = new ArrayList<GrAnnotation>();
        this.myParent = parent;
    }

    public PsiElement getParent() {
        return this.myParent;
    }

    public void addModifier(String modifier) {
        int code = GrModifierListImpl.NAME_TO_MODIFIER_FLAG_MAP.get((Object)modifier);
        assert (code != 0);
        this.myModifiers |= code;
    }

    public void addModifier(int modifier) {
        this.myModifiers |= modifier;
    }

    public void removeModifier(int modifier) {
        this.myModifiers &= ~modifier;
    }

    public void setModifiers(int modifiers) {
        this.myModifiers = modifiers;
    }

    public void setModifiers(String ... modifiers) {
        this.myModifiers = 0;
        for (String modifier : modifiers) {
            this.addModifier(modifier);
        }
    }

    public int getModifiersAsInt() {
        return this.myModifiers;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightModifierList", "hasModifierProperty"));
        }
        return GrModifierListImpl.checkModifierProperty(this, name);
    }

    @Override
    public boolean hasExplicitModifier(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightModifierList", "hasExplicitModifier"));
        }
        return (this.myModifiers & GrModifierListImpl.NAME_TO_MODIFIER_FLAG_MAP.get((Object)name)) != 0;
    }

    @Override
    public void setModifierProperty(@NotNull String name, boolean value) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightModifierList", "setModifierProperty"));
        }
        throw new IncorrectOperationException();
    }

    @Override
    @NotNull
    public GrAnnotation[] getRawAnnotations() {
        GrAnnotation[] grAnnotationArray = this.getAnnotations();
        if (grAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightModifierList", "getRawAnnotations"));
        }
        return grAnnotationArray;
    }

    public void checkSetModifierProperty(@NotNull String name, boolean value) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightModifierList", "checkSetModifierProperty"));
        }
        throw new IncorrectOperationException();
    }

    @Override
    @NotNull
    public GrAnnotation[] getAnnotations() {
        GrAnnotation[] grAnnotationArray = this.myAnnotations.toArray(new GrAnnotation[this.myAnnotations.size()]);
        if (grAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightModifierList", "getAnnotations"));
        }
        return grAnnotationArray;
    }

    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getAnnotations();
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightModifierList", "getApplicableAnnotations"));
        }
        return psiAnnotationArray;
    }

    public PsiAnnotation findAnnotation(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightModifierList", "findAnnotation"));
        }
        return null;
    }

    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightModifierList", "addAnnotation"));
        }
        GrLightAnnotation annotation = new GrLightAnnotation(this.getManager(), this.getLanguage(), qualifiedName, (PsiAnnotationOwner)this);
        this.myAnnotations.add(annotation);
        GrLightAnnotation grLightAnnotation = annotation;
        if (grLightAnnotation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightModifierList", "addAnnotation"));
        }
        return grLightAnnotation;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightModifierList", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitModifierList((PsiModifierList)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "GrModifierList";
    }

    public String getText() {
        StringBuilder buffer = new StringBuilder();
        for (GrAnnotation annotation : this.myAnnotations) {
            buffer.append(annotation.getText());
            buffer.append(' ');
        }
        for (String modifier : GrModifier.GROOVY_MODIFIERS) {
            if (!this.hasExplicitModifier(modifier)) continue;
            buffer.append(modifier);
            buffer.append(' ');
        }
        if (buffer.length() > 0) {
            buffer.delete(buffer.length() - 1, buffer.length());
        }
        return buffer.toString();
    }

    @Override
    @NotNull
    public PsiElement[] getModifiers() {
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightModifierList", "getModifiers"));
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    public boolean hasExplicitVisibilityModifiers() {
        return (this.myModifiers & 7) != 0;
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitModifierList(this);
    }

    @Override
    public void acceptChildren(GroovyElementVisitor visitor) {
    }

    public void copyModifiers(@NotNull PsiModifierListOwner modifierOwner) {
        if (modifierOwner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightModifierList", "copyModifiers"));
        }
        int mod = 0;
        PsiModifierList modifierList = modifierOwner.getModifierList();
        if (modifierList != null) {
            if (modifierList instanceof GrLightModifierList) {
                mod = ((GrLightModifierList)modifierList).getModifiersAsInt();
            } else {
                for (Object o : ModifierFlags.NAME_TO_MODIFIER_FLAG_MAP.keys()) {
                    String modifier = (String)o;
                    if (!modifierList.hasExplicitModifier(modifier)) continue;
                    mod |= GrModifierListImpl.NAME_TO_MODIFIER_FLAG_MAP.get((Object)modifier);
                }
            }
        }
        this.setModifiers(mod);
    }
}

