/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.types;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTypeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GrTypeCastExpressionImpl
extends GrExpressionImpl
implements GrTypeCastExpression {
    public GrTypeCastExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/types/GrTypeCastExpressionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitCastExpression(this);
    }

    public String toString() {
        return "Typecast expression";
    }

    @Override
    public PsiType getType() {
        GrTypeElement typeElement = this.getCastTypeElement();
        if (typeElement != null) {
            return TypesUtil.boxPrimitiveType(typeElement.getType(), (PsiManager)this.getManager(), this.getResolveScope());
        }
        return null;
    }

    @Override
    public GrTypeElement getCastTypeElement() {
        return (GrTypeElement)this.findChildByClass(GrTypeElement.class);
    }

    @Override
    public GrExpression getOperand() {
        return GrTypeCastExpressionImpl.findExpressionChild(this);
    }

    @Override
    @NotNull
    public PsiElement getLeftParen() {
        ASTNode paren = this.getNode().findChildByType(GroovyTokenTypes.mLPAREN);
        assert (paren != null);
        PsiElement psiElement = paren.getPsi();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/types/GrTypeCastExpressionImpl", "getLeftParen"));
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiElement getRightParen() {
        ASTNode paren = this.getNode().findChildByType(GroovyTokenTypes.mRPAREN);
        assert (paren != null);
        PsiElement psiElement = paren.getPsi();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/types/GrTypeCastExpressionImpl", "getRightParen"));
        }
        return psiElement;
    }
}

