/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.codeInsight.GrReassignedLocalVarsChecker;
import org.jetbrains.plugins.groovy.codeInsight.GroovyTargetElementEvaluator;
import org.jetbrains.plugins.groovy.codeInspection.untypedUnresolvedAccess.GrUnresolvedAccessInspection;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.SpreadState;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrReferenceElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.InferenceContext;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.CompleteReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrReferenceResolveUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrBindingVariable;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrReferenceTypeEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ClosureMissingMethodContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.AccessorResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.CompletionProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MethodResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.PropertyResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ResolverProcessor;
import org.jetbrains.plugins.groovy.util.ResolveProfiler;

public class GrReferenceExpressionImpl
extends GrReferenceElementImpl<GrExpression>
implements GrReferenceExpression {
    private static final Logger LOG = Logger.getInstance(GrReferenceExpressionImpl.class);
    private static final ResolveCache.PolyVariantResolver<GrReferenceExpressionImpl> POLY_RESOLVER = new ResolveCache.PolyVariantResolver<GrReferenceExpressionImpl>(){

        @NotNull
        public GroovyResolveResult[] resolve(@NotNull GrReferenceExpressionImpl refExpr, boolean incompleteCode) {
            if (refExpr == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl$3", "resolve"));
            }
            GroovyResolveResult[] groovyResolveResultArray = refExpr.doPolyResolve(incompleteCode, true);
            if (groovyResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl$3", "resolve"));
            }
            return groovyResolveResultArray;
        }
    };
    private static final OurTypesCalculator TYPES_CALCULATOR = new OurTypesCalculator();

    public GrReferenceExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "<init>"));
        }
        super(node);
    }

    private boolean findClassOrPackageAtFirst() {
        String name = this.getReferenceName();
        if (StringUtil.isEmpty((String)name) || this.hasAt()) {
            return false;
        }
        return Character.isUpperCase(name.charAt(0)) && !this.isMethodCallRef() || this.getParent() instanceof GrReferenceExpressionImpl && ((GrReferenceExpressionImpl)this.getParent()).findClassOrPackageAtFirst();
    }

    private boolean isMethodCallRef() {
        PsiElement parent = this.getParent();
        return parent instanceof GrMethodCall || parent instanceof GrReferenceExpressionImpl && ((GrReferenceExpressionImpl)parent).isMethodCallRef();
    }

    private boolean isDefinitelyKeyOfMap() {
        PsiElement resolved;
        GrExpression qualifier = ResolveUtil.getSelfOrWithQualifier(this);
        if (qualifier == null) {
            return false;
        }
        if (qualifier instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)qualifier).resolve()) instanceof PsiClass) {
            return false;
        }
        PsiType type = qualifier.getType();
        if (type == null) {
            return false;
        }
        if (!InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Map")) {
            return false;
        }
        String canonicalText = type.getCanonicalText();
        if (canonicalText.startsWith("java.")) {
            return true;
        }
        if ("groovy.util.ConfigObject".equals(canonicalText)) {
            return false;
        }
        return canonicalText.startsWith("groovy.");
    }

    private GroovyResolveResult[] resolveTypeOrProperty() {
        if (this.isDefinitelyKeyOfMap()) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        GroovyResolveResult[] results = this.resolveTypeOrPropertyInner();
        if (results.length == 0) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        if (!ResolveUtil.mayBeKeyOfMap(this)) {
            return results;
        }
        ArrayList<GroovyResolveResult> filtered = new ArrayList<GroovyResolveResult>();
        for (GroovyResolveResult result : results) {
            String name;
            PsiClass containingClass;
            PsiElement element = result.getElement();
            if (element instanceof PsiMember && (((PsiMember)element).hasModifierProperty("private") || (containingClass = ((PsiMember)element).getContainingClass()) != null && (!InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.util.Map") || (name = containingClass.getQualifiedName()) != null && name.startsWith("java.") || containingClass.getLanguage() != GroovyFileType.GROOVY_LANGUAGE && !InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"groovy.lang.GroovyObject")))) continue;
            filtered.add(result);
        }
        return (GroovyResolveResult[])ContainerUtil.toArray(filtered, (Object[])new GroovyResolveResult[filtered.size()]);
    }

    private GroovyResolveResult[] resolveTypeOrPropertyInner() {
        ArrayList<GroovyResolveResult> results;
        PsiElement nameElement = this.getReferenceNameElement();
        String name = this.getReferenceName();
        if (name == null || nameElement == null) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        IElementType nameType = nameElement.getNode().getElementType();
        if (nameType == GroovyTokenTypes.kTHIS ? GrReferenceResolveUtil.resolveThisExpression(this, results = new ArrayList<GroovyResolveResult>()) : nameType == GroovyTokenTypes.kSUPER && GrReferenceResolveUtil.resolveSuperExpression(this, results = new ArrayList())) {
            return results.toArray(new GroovyResolveResult[results.size()]);
        }
        EnumSet<ClassHint.ResolveKind> kinds = this.getParent() instanceof GrReferenceExpression ? ResolverProcessor.RESOLVE_KINDS_CLASS_PACKAGE : ResolverProcessor.RESOLVE_KINDS_CLASS;
        GroovyResolveResult[] classCandidates = null;
        PropertyResolverProcessor processor = new PropertyResolverProcessor(name, this);
        GrReferenceResolveUtil.resolveImpl(processor, this);
        Object[] fieldCandidates = ((ResolverProcessor)processor).getCandidates();
        if (this.hasAt()) {
            return fieldCandidates;
        }
        boolean canBeClassOrPackage = ResolveUtil.canBeClassOrPackage(this);
        if (canBeClassOrPackage && this.findClassOrPackageAtFirst()) {
            ClassResolverProcessor classProcessor = new ClassResolverProcessor(name, this, kinds);
            GrReferenceResolveUtil.resolveImpl(classProcessor, this);
            classCandidates = classProcessor.getCandidates();
            if (classCandidates.length > 0 && GrReferenceExpressionImpl.containsPackage(classCandidates)) {
                return classCandidates;
            }
        }
        for (GroovyResolveResult groovyResolveResult : fieldCandidates) {
            PsiClass containingClass;
            PsiElement element = groovyResolveResult.getElement();
            if (!(element instanceof PsiField ? (containingClass = ((PsiField)element).getContainingClass()) != null && PsiUtil.getContextClass(this) == containingClass : !(element instanceof GrBindingVariable))) continue;
            return fieldCandidates;
        }
        if (classCandidates != null && classCandidates.length > 0) {
            return classCandidates;
        }
        boolean isLValue = PsiUtil.isLValue(this);
        String[] accessorNames = isLValue ? GroovyPropertyUtils.suggestSettersName(name) : GroovyPropertyUtils.suggestGettersName(name);
        ArrayList accessorResults = new ArrayList();
        for (String accessorName : accessorNames) {
            AccessorResolverProcessor accessorResolver = new AccessorResolverProcessor(accessorName, name, this, !isLValue, false, GrReferenceResolveUtil.getQualifierType(this), this.getTypeArguments());
            GrReferenceResolveUtil.resolveImpl(accessorResolver, this);
            Object[] candidates = accessorResolver.getCandidates();
            if (candidates.length == 1 && candidates[0].isStaticsOK() && candidates[0].isAccessible()) {
                return candidates;
            }
            ContainerUtil.addAll(accessorResults, (Object[])candidates);
        }
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])fieldCandidates);
        GrReferenceExpressionImpl.filterOutBindings(arrayList);
        if (!arrayList.isEmpty()) {
            return arrayList.toArray(new GroovyResolveResult[arrayList.size()]);
        }
        if (classCandidates == null && canBeClassOrPackage) {
            ClassResolverProcessor classProcessor = new ClassResolverProcessor(name, this, kinds);
            GrReferenceResolveUtil.resolveImpl(classProcessor, this);
            classCandidates = classProcessor.getCandidates();
        }
        if (classCandidates != null && classCandidates.length > 0) {
            return classCandidates;
        }
        if (accessorResults.size() > 0) {
            return new GroovyResolveResult[]{(GroovyResolveResult)accessorResults.get(0)};
        }
        return GroovyResolveResult.EMPTY_ARRAY;
    }

    private static boolean containsPackage(@NotNull GroovyResolveResult[] candidates) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "containsPackage"));
        }
        for (GroovyResolveResult candidate : candidates) {
            if (!(candidate.getElement() instanceof PsiPackage)) continue;
            return true;
        }
        return false;
    }

    public GroovyResolveResult[] getCallVariants(GrExpression upToArgument) {
        return this.resolveMethodOrProperty(true, upToArgument, true);
    }

    private void processMethods(MethodResolverProcessor methodResolver) {
        GrReferenceResolveUtil.resolveImpl(methodResolver, this);
        if (methodResolver.hasApplicableCandidates()) {
            return;
        }
        if (!this.isQualified() && this.getContext() instanceof GrMethodCall) {
            for (PsiElement e = this.getContext(); e != null; e = e.getContext()) {
                if (!(e instanceof GrClosableBlock)) continue;
                ResolveState state = ResolveState.initial().put(ResolverProcessor.RESOLVE_CONTEXT, (Object)e);
                for (ClosureMissingMethodContributor contributor : (ClosureMissingMethodContributor[])ClosureMissingMethodContributor.EP_NAME.getExtensions()) {
                    if (contributor.processMembers((GrClosableBlock)e, methodResolver, this, state)) continue;
                    return;
                }
            }
        }
    }

    @NotNull
    private GroovyResolveResult[] resolveMethodOrProperty(boolean allVariants, @Nullable GrExpression upToArgument, boolean genericsMatter) {
        String name = this.getReferenceName();
        if (name == null) {
            if (GroovyResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "resolveMethodOrProperty"));
            }
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        PropertyResolverProcessor propertyResolver = new PropertyResolverProcessor(name, this);
        GrReferenceResolveUtil.resolveImpl(propertyResolver, this);
        Object[] propertyCandidates = propertyResolver.getCandidates();
        if (!allVariants) {
            for (GroovyResolveResult groovyResolveResult : propertyCandidates) {
                PsiElement element = groovyResolveResult.getElement();
                if (!(element instanceof GrVariable) || element instanceof GrField || element instanceof GrBindingVariable) continue;
                if (propertyCandidates == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "resolveMethodOrProperty"));
                }
                return propertyCandidates;
            }
        }
        Pair<Boolean, GroovyResolveResult[]> shapeResults = this.resolveByShape(allVariants, upToArgument);
        if (!genericsMatter && !allVariants && ((Boolean)shapeResults.first).booleanValue()) {
            GrReferenceExpressionImpl.assertAllAreValid((GroovyResolveResult[])shapeResults.second);
            GroovyResolveResult[] groovyResolveResultArray = (GroovyResolveResult[])shapeResults.second;
            if (groovyResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "resolveMethodOrProperty"));
            }
            return groovyResolveResultArray;
        }
        MethodResolverProcessor methodResolver = null;
        if (genericsMatter) {
            methodResolver = this.createMethodProcessor(allVariants, name, false, upToArgument);
            for (GroovyResolveResult result : (GroovyResolveResult[])shapeResults.second) {
                ResolveState state = ResolveState.initial().put(PsiSubstitutor.KEY, (Object)result.getSubstitutor()).put(ResolverProcessor.RESOLVE_CONTEXT, (Object)result.getCurrentFileResolveContext()).put(SpreadState.SPREAD_STATE, (Object)result.getSpreadState());
                methodResolver.execute(result.getElement(), state);
            }
            if (!allVariants && methodResolver.hasApplicableCandidates()) {
                GroovyResolveResult[] groovyResolveResultArray = methodResolver.getCandidates();
                if (groovyResolveResultArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "resolveMethodOrProperty"));
                }
                return groovyResolveResultArray;
            }
        }
        if (!allVariants) {
            for (Object candidate : propertyCandidates) {
                PsiClass containingClass;
                PsiElement element = candidate.getElement();
                if (!(element instanceof GrField) || (containingClass = ((PsiField)element).getContainingClass()) == null || !PsiTreeUtil.isContextAncestor((PsiElement)containingClass, (PsiElement)this, (boolean)true)) continue;
                if (propertyCandidates == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "resolveMethodOrProperty"));
                }
                return propertyCandidates;
            }
        }
        ArrayList<GroovyResolveResult> allCandidates = new ArrayList<GroovyResolveResult>();
        ContainerUtil.addAll(allCandidates, (Object[])propertyCandidates);
        ContainerUtil.addAll(allCandidates, (Object[])(genericsMatter ? methodResolver.getCandidates() : (GroovyResolveResult[])shapeResults.second));
        GrReferenceExpressionImpl.filterOutBindings(allCandidates);
        for (String getterName : GroovyPropertyUtils.suggestGettersName(name)) {
            AccessorResolverProcessor getterResolver = new AccessorResolverProcessor(getterName, name, this, true, genericsMatter, GrReferenceResolveUtil.getQualifierType(this), this.getTypeArguments());
            GrReferenceResolveUtil.resolveImpl(getterResolver, this);
            Object[] candidates = getterResolver.getCandidates();
            if (!allVariants && candidates.length == 1) {
                if (candidates == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "resolveMethodOrProperty"));
                }
                return candidates;
            }
            ContainerUtil.addAll(allCandidates, (Object[])candidates);
        }
        if (allCandidates.size() > 0) {
            GroovyResolveResult[] groovyResolveResultArray = allCandidates.toArray(new GroovyResolveResult[allCandidates.size()]);
            if (groovyResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "resolveMethodOrProperty"));
            }
            return groovyResolveResultArray;
        }
        if (GroovyResolveResult.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "resolveMethodOrProperty"));
        }
        return GroovyResolveResult.EMPTY_ARRAY;
    }

    private static void filterOutBindings(List<GroovyResolveResult> candidates) {
        boolean hasNonBinding = false;
        for (GroovyResolveResult candidate : candidates) {
            if (candidate.getElement() instanceof GrBindingVariable) continue;
            hasNonBinding = true;
        }
        if (hasNonBinding) {
            Iterator<GroovyResolveResult> iterator = candidates.iterator();
            while (iterator.hasNext()) {
                GroovyResolveResult candidate;
                candidate = iterator.next();
                if (!(candidate.getElement() instanceof GrBindingVariable)) continue;
                iterator.remove();
            }
        }
    }

    private Pair<Boolean, GroovyResolveResult[]> resolveByShape(boolean allVariants, @Nullable GrExpression upToArgument) {
        if (allVariants) {
            return this.doResolveByShape(allVariants, upToArgument);
        }
        LOG.assertTrue(upToArgument == null);
        return (Pair)TypeInferenceHelper.getCurrentContext().getCachedValue(this, new NullableComputable<Pair<Boolean, GroovyResolveResult[]>>(){

            public Pair<Boolean, GroovyResolveResult[]> compute() {
                return GrReferenceExpressionImpl.this.doResolveByShape(false, null);
            }
        });
    }

    private Pair<Boolean, GroovyResolveResult[]> doResolveByShape(boolean allVariants, @Nullable GrExpression upToArgument) {
        String name = this.getReferenceName();
        LOG.assertTrue(name != null);
        MethodResolverProcessor shapeProcessor = this.createMethodProcessor(allVariants, name, true, upToArgument);
        this.processMethods(shapeProcessor);
        GroovyResolveResult[] candidates = shapeProcessor.getCandidates();
        GrReferenceExpressionImpl.assertAllAreValid(candidates);
        return Pair.create((Object)shapeProcessor.hasApplicableCandidates(), (Object)candidates);
    }

    private static void assertAllAreValid(GroovyResolveResult[] candidates) {
        for (GroovyResolveResult candidate : candidates) {
            PsiElement element = candidate.getElement();
            LOG.assertTrue(element == null || element.isValid());
        }
    }

    private MethodResolverProcessor createMethodProcessor(boolean allVariants, String name, boolean byShape, @Nullable GrExpression upToArgument) {
        PsiType[] argTypes = PsiUtil.getArgumentTypes(this, false, upToArgument, byShape);
        if (byShape && argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                argTypes[i] = TypeConversionUtil.erasure((PsiType)argTypes[i]);
            }
        }
        return new MethodResolverProcessor(name, this, false, GrReferenceResolveUtil.getQualifierType(this), argTypes, this.getTypeArguments(), allVariants, byShape);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitReferenceExpression(this);
    }

    @Override
    @Nullable
    public PsiElement getReferenceNameElement() {
        ASTNode lastChild = this.getNode().getLastChildNode();
        if (lastChild == null) {
            return null;
        }
        if (TokenSets.REFERENCE_NAMES.contains(lastChild.getElementType())) {
            return lastChild.getPsi();
        }
        return null;
    }

    @Override
    @NotNull
    public PsiReference getReference() {
        GrReferenceExpressionImpl grReferenceExpressionImpl = this;
        if (grReferenceExpressionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "getReference"));
        }
        return grReferenceExpressionImpl;
    }

    @Override
    @Nullable
    public GrExpression getQualifier() {
        return this.getQualifierExpression();
    }

    @Override
    public String getReferenceName() {
        PsiElement nameElement = this.getReferenceNameElement();
        if (nameElement != null) {
            Object value;
            IElementType nodeType = nameElement.getNode().getElementType();
            if (TokenSets.STRING_LITERAL_SET.contains(nodeType) && (value = GrLiteralImpl.getLiteralValue(nameElement)) instanceof String) {
                return (String)value;
            }
            return nameElement.getText();
        }
        return null;
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        String name;
        GroovyResolveResult result = this.advancedResolve();
        if (result.isInvokedOnProperty() && (name = GroovyPropertyUtils.getPropertyNameByAccessorName(newElementName)) != null) {
            newElementName = name;
        }
        if (PsiUtil.isThisOrSuperRef(this)) {
            return this;
        }
        return this.handleElementRenameSimple(newElementName);
    }

    protected GrReferenceExpression bindWithQualifiedRef(@NotNull String qName) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "bindWithQualifiedRef"));
        }
        GrReferenceExpression qualifiedRef = GroovyPsiElementFactory.getInstance(this.getProject()).createReferenceExpressionFromText(qName);
        GrTypeArgumentList list = this.getTypeArgumentList();
        if (list != null) {
            qualifiedRef.getNode().addChild(list.copy().getNode());
        }
        this.getNode().getTreeParent().replaceChild(this.getNode(), qualifiedRef.getNode());
        return qualifiedRef;
    }

    @Override
    public boolean isFullyQualified() {
        if (this.getKind() == Kind.TYPE_OR_PROPERTY && this.resolve() instanceof PsiPackage) {
            return true;
        }
        GrExpression qualifier = this.getQualifier();
        if (!(qualifier instanceof GrReferenceExpressionImpl)) {
            return false;
        }
        return ((GrReferenceExpressionImpl)qualifier).isFullyQualified();
    }

    @Override
    public PsiElement handleElementRenameSimple(String newElementName) throws IncorrectOperationException {
        if (!PsiUtil.isValidReferenceName(newElementName)) {
            PsiElement old = this.getReferenceNameElement();
            if (old == null) {
                throw new IncorrectOperationException("ref has no name element");
            }
            PsiElement element = GroovyPsiElementFactory.getInstance(this.getProject()).createStringLiteralForReference(newElementName);
            old.replace(element);
            return this;
        }
        return super.handleElementRenameSimple(newElementName);
    }

    public String toString() {
        return "Reference expression";
    }

    @Override
    @Nullable
    public PsiElement resolve() {
        GroovyResolveResult[] results = this.resolveByShape();
        return results.length == 1 ? results[0].getElement() : null;
    }

    @Override
    public GroovyResolveResult[] resolveByShape() {
        final InferenceContext context = TypeInferenceHelper.getCurrentContext();
        return context.getCachedValue(this, new Computable<GroovyResolveResult[]>(){

            public GroovyResolveResult[] compute() {
                Pair key = Pair.create((Object)GrReferenceExpressionImpl.this, (Object)context);
                GroovyResolveResult[] value = (GroovyResolveResult[])RecursionManager.doPreventingRecursion((Object)key, (boolean)true, (Computable)new Computable<GroovyResolveResult[]>(){

                    public GroovyResolveResult[] compute() {
                        return GrReferenceExpressionImpl.this.doPolyResolve(false, false);
                    }
                });
                return value == null ? GroovyResolveResult.EMPTY_ARRAY : value;
            }
        });
    }

    @Override
    public PsiType getNominalType() {
        PsiType type;
        GroovyResolveResult resolveResult = this.advancedResolve();
        PsiElement resolved = resolveResult.getElement();
        for (GrReferenceTypeEnhancer enhancer : (GrReferenceTypeEnhancer[])GrReferenceTypeEnhancer.EP_NAME.getExtensions()) {
            PsiType type2 = enhancer.getReferenceType(this, resolved);
            if (type2 == null) continue;
            return type2;
        }
        IElementType dotType = this.getDotTokenType();
        if (dotType == GroovyTokenTypes.mMEMBER_POINTER) {
            return GrClosureType.create(this.multiResolve(false), this);
        }
        if (this.isDefinitelyKeyOfMap() && (type = GrReferenceExpressionImpl.getTypeFromMapAccess(this)) != null) {
            return type;
        }
        PsiType result = this.getNominalTypeInner(resolved);
        if (result == null) {
            return null;
        }
        result = TypesUtil.substituteBoxAndNormalizeType(result, resolveResult.getSubstitutor(), resolveResult.getSpreadState(), this);
        return result;
    }

    @Nullable
    private PsiType getNominalTypeInner(PsiElement resolved) {
        if (resolved == null && !"class".equals(this.getReferenceName())) {
            resolved = this.resolve();
        }
        if (resolved instanceof PsiClass) {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory();
            if (PsiUtil.isInstanceThisRef(this)) {
                PsiClassType categoryType = GdkMethodUtil.getCategoryType((PsiClass)resolved);
                if (categoryType != null) {
                    return categoryType;
                }
                return factory.createType((PsiClass)resolved);
            }
            if (this.getParent() instanceof GrReferenceExpression || PsiUtil.isSuperReference(this)) {
                return factory.createType((PsiClass)resolved);
            }
            return TypesUtil.createJavaLangClassType((PsiType)factory.createType((PsiClass)resolved), this.getProject(), this.getResolveScope());
        }
        if (resolved instanceof GrVariable) {
            return ((GrVariable)resolved).getDeclaredType();
        }
        if (resolved instanceof PsiVariable) {
            return ((PsiVariable)resolved).getType();
        }
        if (resolved instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)resolved;
            if (PropertyUtil.isSimplePropertySetter((PsiMethod)method) && !method.getName().equals(this.getReferenceName())) {
                return method.getParameterList().getParameters()[0].getType();
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass != null && "java.lang.Object".equals(containingClass.getQualifiedName()) && "getClass".equals(method.getName())) {
                return TypesUtil.createJavaLangClassType(GrReferenceResolveUtil.getQualifierType(this), this.getProject(), this.getResolveScope());
            }
            return PsiUtil.getSmartReturnType(method);
        }
        if (resolved == null) {
            PsiType fromClassRef = GrReferenceExpressionImpl.getTypeFromClassRef(this);
            if (fromClassRef != null) {
                return fromClassRef;
            }
            PsiType fromMapAccess = GrReferenceExpressionImpl.getTypeFromMapAccess(this);
            if (fromMapAccess != null) {
                return fromMapAccess;
            }
            PsiType fromSpreadOperator = GrReferenceExpressionImpl.getTypeFromSpreadOperator(this);
            if (fromSpreadOperator != null) {
                return fromSpreadOperator;
            }
        }
        return null;
    }

    @Nullable
    private static PsiType getTypeFromMapAccess(@NotNull GrReferenceExpressionImpl ref) {
        PsiType substituted;
        PsiSubstitutor substitutor;
        PsiClass mapClass;
        PsiClassType.ClassResolveResult qResult;
        PsiClass clazz;
        PsiType qType;
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "getTypeFromMapAccess"));
        }
        GrExpression qualifier = ref.getQualifierExpression();
        if (qualifier != null && (qType = qualifier.getNominalType()) instanceof PsiClassType && (clazz = (qResult = ((PsiClassType)qType).resolveGenerics()).getElement()) != null && (mapClass = JavaPsiFacade.getInstance((Project)ref.getProject()).findClass("java.util.Map", ref.getResolveScope())) != null && mapClass.getTypeParameters().length == 2 && (substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)mapClass, (PsiClass)clazz, (PsiSubstitutor)qResult.getSubstitutor())) != null && (substituted = substitutor.substitute(mapClass.getTypeParameters()[1])) != null) {
            return PsiImplUtil.normalizeWildcardTypeByPosition(substituted, ref);
        }
        return null;
    }

    @Nullable
    private static PsiType getTypeFromSpreadOperator(@NotNull GrReferenceExpressionImpl ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "getTypeFromSpreadOperator"));
        }
        if (ref.getDotTokenType() == GroovyTokenTypes.mSPREAD_DOT) {
            return TypesUtil.createType("java.util.List", ref);
        }
        return null;
    }

    @Nullable
    private static PsiType getTypeFromClassRef(@NotNull GrReferenceExpressionImpl ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "getTypeFromClassRef"));
        }
        if ("class".equals(ref.getReferenceName())) {
            return TypesUtil.createJavaLangClassType(GrReferenceResolveUtil.getQualifierType(ref), ref.getProject(), ref.getResolveScope());
        }
        return null;
    }

    @Nullable
    private static PsiType getInferredTypes(GrReferenceExpressionImpl refExpr, @Nullable PsiElement resolved) {
        PsiType mapValueType;
        PsiType qType;
        GrExpression qualifier = refExpr.getQualifier();
        if (qualifier == null && !(resolved instanceof PsiClass) && !(resolved instanceof PsiPackage)) {
            return TypeInferenceHelper.getCurrentContext().getVariableType(refExpr);
        }
        if (qualifier != null && (qType = qualifier.getType()) instanceof PsiClassType && !(qType instanceof GrMapType) && (mapValueType = GrReferenceExpressionImpl.getTypeFromMapAccess(refExpr)) != null) {
            return mapValueType;
        }
        return null;
    }

    @Override
    public PsiType getType() {
        return TypeInferenceHelper.getCurrentContext().getExpressionType(this, TYPES_CALCULATOR);
    }

    @Override
    public GrExpression replaceWithExpression(@NotNull GrExpression newExpr, boolean removeUnnecessaryParentheses) {
        if (newExpr == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "replaceWithExpression"));
        }
        return PsiImplUtil.replaceExpression(this, newExpr, removeUnnecessaryParentheses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private GroovyResolveResult[] doPolyResolve(boolean incompleteCode, boolean genericsMatter) {
        GroovyResolveResult[] groovyResolveResultArray;
        block20: {
            GroovyResolveResult[] processor;
            String name = this.getReferenceName();
            if (name == null) {
                if (GroovyResolveResult.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "doPolyResolve"));
                }
                return GroovyResolveResult.EMPTY_ARRAY;
            }
            if (incompleteCode) {
                processor = CompletionProcessor.createRefSameNameProcessor(this, name);
                GrReferenceResolveUtil.resolveImpl((ResolverProcessor)processor, this);
                GroovyResolveResult[] propertyCandidates = processor.getCandidates();
                if (propertyCandidates.length > 0 && !PsiUtil.isSingleBindingVariant(propertyCandidates)) {
                    if (propertyCandidates == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "doPolyResolve"));
                    }
                    return propertyCandidates;
                }
            }
            ResolveProfiler.start();
            switch (this.getKind()) {
                case METHOD_OR_PROPERTY: {
                    processor = this.resolveMethodOrProperty(false, null, genericsMatter);
                    if (processor == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "doPolyResolve"));
                    }
                    return processor;
                }
                case TYPE_OR_PROPERTY: {
                    processor = this.resolveTypeOrProperty();
                    if (processor == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "doPolyResolve"));
                    }
                    return processor;
                }
                case METHOD_OR_PROPERTY_OR_TYPE: {
                    GroovyResolveResult[] results = this.resolveMethodOrProperty(false, null, genericsMatter);
                    if (results.length == 0) {
                        results = this.resolveTypeOrProperty();
                    }
                    if ((groovyResolveResultArray = results) == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "doPolyResolve"));
                    }
                    return groovyResolveResultArray;
                }
            }
            groovyResolveResultArray = GroovyResolveResult.EMPTY_ARRAY;
            if (groovyResolveResultArray != null) break block20;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "doPolyResolve"));
        }
        return groovyResolveResultArray;
        finally {
            long time = ResolveProfiler.finish();
            ResolveProfiler.write("ref " + this.getText() + " " + this.hashCode() + " : " + time);
        }
    }

    Kind getKind() {
        if (this.getDotTokenType() == GroovyTokenTypes.mMEMBER_POINTER) {
            return Kind.METHOD_OR_PROPERTY;
        }
        PsiElement parent = this.getParent();
        if (parent instanceof GrMethodCallExpression || parent instanceof GrApplicationStatement) {
            return Kind.METHOD_OR_PROPERTY_OR_TYPE;
        }
        return Kind.TYPE_OR_PROPERTY;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getRangeInElement().substring(this.getElement().getText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "getCanonicalText"));
        }
        return string;
    }

    @Override
    public boolean hasAt() {
        return this.findChildByType(GroovyTokenTypes.mAT) != null;
    }

    @Override
    public boolean hasMemberPointer() {
        return this.findChildByType(GroovyTokenTypes.mMEMBER_POINTER) != null;
    }

    public boolean isReferenceTo(PsiElement element) {
        PsiMethod[] superMethods;
        PsiElement baseTarget = this.resolve();
        if (this.getManager().areElementsEquivalent(element, baseTarget)) {
            return true;
        }
        PsiElement target = GroovyTargetElementEvaluator.correctSearchTargets(baseTarget);
        if (target != baseTarget && this.getManager().areElementsEquivalent(element, target)) {
            return true;
        }
        return element instanceof PsiMethod && target instanceof PsiMethod && Arrays.asList(superMethods = ((PsiMethod)target).findSuperMethods(false)).contains(element);
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    public GrExpression getQualifierExpression() {
        return GrReferenceExpressionImpl.findExpressionChild(this);
    }

    @Override
    @Nullable
    public PsiElement getDotToken() {
        return this.findChildByType(TokenSets.DOTS);
    }

    @Override
    public void replaceDotToken(PsiElement newDot) {
        if (newDot == null) {
            return;
        }
        if (!TokenSets.DOTS.contains(newDot.getNode().getElementType())) {
            return;
        }
        PsiElement oldDot = this.getDotToken();
        if (oldDot == null) {
            return;
        }
        this.getNode().replaceChild(oldDot.getNode(), newDot.getNode());
    }

    @Override
    @Nullable
    public IElementType getDotTokenType() {
        PsiElement dot = this.getDotToken();
        return dot == null ? null : dot.getNode().getElementType();
    }

    @Override
    public GroovyResolveResult advancedResolve() {
        GroovyResolveResult[] results = TypeInferenceHelper.getCurrentContext().multiResolve(this, false, POLY_RESOLVER);
        return results.length == 1 ? results[0] : GroovyResolveResult.EMPTY_RESULT;
    }

    @Override
    @NotNull
    public GroovyResolveResult[] multiResolve(boolean incomplete) {
        GroovyResolveResult[] results = TypeInferenceHelper.getCurrentContext().multiResolve(this, incomplete, POLY_RESOLVER);
        GroovyResolveResult[] groovyResolveResultArray = results.length == 0 ? GroovyResolveResult.EMPTY_ARRAY : results;
        if (groovyResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "multiResolve"));
        }
        return groovyResolveResultArray;
    }

    @Override
    public void processVariants(PrefixMatcher matcher, CompletionParameters parameters, Consumer<LookupElement> consumer) {
        CompleteReferenceExpression.processVariants(matcher, consumer, this, parameters);
    }

    @Override
    @NotNull
    public GroovyResolveResult[] getSameNameVariants() {
        GroovyResolveResult[] groovyResolveResultArray = this.doPolyResolve(true, true);
        if (groovyResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "getSameNameVariants"));
        }
        return groovyResolveResultArray;
    }

    @Override
    public GrReferenceExpression bindToElementViaStaticImport(@NotNull PsiMember member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "bindToElementViaStaticImport"));
        }
        if (this.getQualifier() != null) {
            throw new IncorrectOperationException("Reference has qualifier");
        }
        if (StringUtil.isEmpty((String)this.getReferenceName())) {
            throw new IncorrectOperationException("Reference has empty name");
        }
        PsiClass containingClass = member.getContainingClass();
        if (containingClass == null) {
            throw new IncorrectOperationException("Member has no containing class");
        }
        PsiFile file = this.getContainingFile();
        if (file instanceof GroovyFile) {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
            String text = "import static " + containingClass.getQualifiedName() + "." + member.getName();
            GrImportStatement statement = factory.createImportStatementFromText(text);
            ((GroovyFile)file).addImport(statement);
        }
        return this;
    }

    static enum Kind {
        TYPE_OR_PROPERTY,
        METHOD_OR_PROPERTY,
        METHOD_OR_PROPERTY_OR_TYPE;

    }

    private static final class OurTypesCalculator
    implements Function<GrReferenceExpressionImpl, PsiType> {
        private OurTypesCalculator() {
        }

        @Nullable
        public PsiType fun(GrReferenceExpressionImpl refExpr) {
            if (GrUnresolvedAccessInspection.isClassReference(refExpr)) {
                GrExpression qualifier = refExpr.getQualifier();
                LOG.assertTrue(qualifier != null);
                return TypesUtil.createJavaLangClassType(qualifier.getType(), refExpr.getProject(), refExpr.getResolveScope());
            }
            PsiElement resolved = refExpr.resolve();
            PsiType nominal = refExpr.getNominalType();
            Boolean reassigned = GrReassignedLocalVarsChecker.isReassignedVar(refExpr);
            if (reassigned != null && reassigned.booleanValue()) {
                return GrReassignedLocalVarsChecker.getReassignedVarType(refExpr, true);
            }
            PsiType inferred = GrReferenceExpressionImpl.getInferredTypes(refExpr, resolved);
            if (inferred == null) {
                if (nominal == null && resolved instanceof GrVariable) {
                    LOG.assertTrue(resolved.isValid());
                    return ((GrVariable)resolved).getTypeGroovy();
                }
                return nominal;
            }
            if (nominal == null) {
                return inferred;
            }
            if (!TypeConversionUtil.isAssignable((PsiType)TypeConversionUtil.erasure((PsiType)nominal), (PsiType)inferred, (boolean)false) && resolved instanceof GrVariable && ((GrVariable)resolved).getTypeElementGroovy() != null) {
                return nominal;
            }
            return inferred;
        }
    }
}

