/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.clauses;

import com.intellij.lang.ASTNode;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrCondition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrTraditionalForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;

public class GrTraditionalForClauseImpl
extends GroovyPsiElementImpl
implements GrTraditionalForClause {
    public GrTraditionalForClauseImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/clauses/GrTraditionalForClauseImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitTraditionalForClause(this);
    }

    public String toString() {
        return "Traditional FOR clause";
    }

    @Override
    public GrParameter getDeclaredVariable() {
        return (GrParameter)this.findChildByClass(GrParameter.class);
    }

    @Override
    public GrCondition getInitialization() {
        return this.getConditionInner(0);
    }

    @Override
    public GrExpression getCondition() {
        GrCondition condition = this.getConditionInner(1);
        return condition instanceof GrExpression ? (GrExpression)condition : null;
    }

    @Override
    public GrExpression getUpdate() {
        GrCondition condition = this.getConditionInner(2);
        return condition instanceof GrExpression ? (GrExpression)condition : null;
    }

    private GrCondition getConditionInner(int i) {
        int passed = 0;
        boolean waitForSemicolon = false;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == GroovyTokenTypes.mSEMI) {
                if (waitForSemicolon) {
                    waitForSemicolon = false;
                    continue;
                }
                if (passed == i) {
                    return null;
                }
                ++passed;
                continue;
            }
            if (!(child.getPsi() instanceof GrCondition)) continue;
            if (passed == i) {
                return (GrCondition)child.getPsi();
            }
            ++passed;
            waitForSemicolon = true;
        }
        return null;
    }

    @Override
    public GrParameter[] getParameters() {
        GrParameter[] grParameterArray;
        GrParameter declaredVariable = this.getDeclaredVariable();
        if (declaredVariable == null) {
            grParameterArray = GrParameter.EMPTY_ARRAY;
        } else {
            GrParameter[] grParameterArray2 = new GrParameter[1];
            grParameterArray = grParameterArray2;
            grParameterArray2[0] = declaredVariable;
        }
        return grParameterArray;
    }

    @Override
    public GrParameterList getParameterList() {
        return null;
    }

    @Override
    public boolean isVarArgs() {
        throw new IncorrectOperationException("For clause cannot have varargs");
    }
}

