/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.arguments;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.resolve.GroovyStringLiteralManipulator;

public class GrArgumentLabelManipulator
extends AbstractElementManipulator<GrArgumentLabel> {
    @NotNull
    public TextRange getRangeInElement(@NotNull GrArgumentLabel element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentLabelManipulator", "getRangeInElement"));
        }
        PsiElement nameElement = element.getNameElement();
        if (nameElement instanceof LeafPsiElement && TokenSets.STRING_LITERAL_SET.contains(((LeafPsiElement)nameElement).getElementType())) {
            TextRange textRange = GroovyStringLiteralManipulator.getLiteralRange(nameElement.getText());
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentLabelManipulator", "getRangeInElement"));
            }
            return textRange;
        }
        TextRange textRange = super.getRangeInElement((PsiElement)element);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentLabelManipulator", "getRangeInElement"));
        }
        return textRange;
    }

    public GrArgumentLabel handleContentChange(@NotNull GrArgumentLabel element, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentLabelManipulator", "handleContentChange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentLabelManipulator", "handleContentChange"));
        }
        element.setName(newContent);
        return element;
    }
}

