/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.signatures;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrMultiSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignatureVisitor;

public class GrMultiSignatureImpl
implements GrMultiSignature {
    private final GrClosureSignature[] mySignatures;

    public GrMultiSignatureImpl(GrClosureSignature[] signatures) {
        this.mySignatures = signatures;
    }

    @Override
    public GrClosureSignature[] getAllSignatures() {
        return this.mySignatures;
    }

    @Override
    public boolean isValid() {
        for (GrClosureSignature signature : this.mySignatures) {
            if (signature.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public GrSignature curry(@NotNull PsiType[] args, int position, @NotNull PsiElement context) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrMultiSignatureImpl", "curry"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrMultiSignatureImpl", "curry"));
        }
        ArrayList<GrClosureSignature> newClosures = new ArrayList<GrClosureSignature>();
        for (GrClosureSignature old : this.mySignatures) {
            GrSignature curried = old.curry(args, position, context);
            if (curried instanceof GrClosureSignature) {
                newClosures.add((GrClosureSignature)curried);
                continue;
            }
            if (!(curried instanceof GrMultiSignature)) continue;
            newClosures.addAll(Arrays.asList(((GrMultiSignature)curried).getAllSignatures()));
        }
        return new GrMultiSignatureImpl(newClosures.toArray(new GrClosureSignature[newClosures.size()]));
    }

    @Override
    public void accept(GrSignatureVisitor visitor) {
        visitor.visitMultiSignature(this);
    }
}

