/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.signatures;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureParameter;

public class GrImmediateClosureParameterImpl
implements GrClosureParameter {
    @Nullable
    final PsiType myType;
    @Nullable
    private final String myName;
    final boolean myOptional;
    @Nullable
    final GrExpression myDefaultInitializer;

    public GrImmediateClosureParameterImpl(@Nullable PsiType type, @Nullable String name, boolean optional, GrExpression defaultInitializer) {
        this.myType = type;
        this.myName = name;
        this.myOptional = optional;
        this.myDefaultInitializer = optional ? defaultInitializer : null;
    }

    public GrImmediateClosureParameterImpl(@NotNull PsiParameter parameter, @NotNull PsiSubstitutor substitutor) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrImmediateClosureParameterImpl", "<init>"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrImmediateClosureParameterImpl", "<init>"));
        }
        this(substitutor.substitute(GrImmediateClosureParameterImpl.getParameterType(parameter)), GrImmediateClosureParameterImpl.getParameterName(parameter), GrImmediateClosureParameterImpl.isParameterOptional(parameter), GrImmediateClosureParameterImpl.getDefaultInitializer(parameter));
    }

    @NotNull
    public static GrImmediateClosureParameterImpl createErasedParameter(@NotNull PsiParameter param) {
        if (param == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrImmediateClosureParameterImpl", "createErasedParameter"));
        }
        PsiType type = TypeConversionUtil.erasure((PsiType)param.getType());
        GrImmediateClosureParameterImpl grImmediateClosureParameterImpl = new GrImmediateClosureParameterImpl(type, GrImmediateClosureParameterImpl.getParameterName(param), GrImmediateClosureParameterImpl.isParameterOptional(param), GrImmediateClosureParameterImpl.getDefaultInitializer(param));
        if (grImmediateClosureParameterImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrImmediateClosureParameterImpl", "createErasedParameter"));
        }
        return grImmediateClosureParameterImpl;
    }

    @Nullable
    private static PsiType getParameterType(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrImmediateClosureParameterImpl", "getParameterType"));
        }
        return parameter instanceof GrParameter ? ((GrParameter)parameter).getDeclaredType() : parameter.getType();
    }

    @Nullable
    public static GrExpression getDefaultInitializer(PsiParameter parameter) {
        return parameter instanceof GrParameter ? ((GrParameter)parameter).getInitializerGroovy() : null;
    }

    public static boolean isParameterOptional(PsiParameter parameter) {
        return parameter instanceof GrParameter && ((GrParameter)parameter).isOptional();
    }

    public static boolean isVararg(GrClosureParameter[] closureParams) {
        return closureParams.length > 0 && closureParams[closureParams.length - 1].getType() instanceof PsiArrayType;
    }

    @Nullable
    public static String getParameterName(@NotNull PsiParameter param) {
        if (param == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrImmediateClosureParameterImpl", "getParameterName"));
        }
        if (param instanceof PsiCompiledElement) {
            return null;
        }
        return param.getName();
    }

    @Override
    @Nullable
    public PsiType getType() {
        return this.myType;
    }

    @Override
    public boolean isOptional() {
        return this.myOptional;
    }

    @Override
    @Nullable
    public GrExpression getDefaultInitializer() {
        return this.myDefaultInitializer;
    }

    @Override
    public boolean isValid() {
        return !(this.myType != null && !this.myType.isValid() || this.myDefaultInitializer != null && !this.myDefaultInitializer.isValid());
    }

    @Override
    @Nullable
    public String getName() {
        return this.myName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GrClosureParameter) {
            return Comparing.equal((Object)this.myType, (Object)((GrClosureParameter)obj).getType()) && Comparing.equal((Object)this.myOptional, (Object)((GrClosureParameter)obj).isOptional()) && Comparing.equal((Object)this.myDefaultInitializer, (Object)((GrClosureParameter)obj).getDefaultInitializer());
        }
        return super.equals(obj);
    }
}

