/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightAnnotation;

public class GrAnnotationCollector {
    @NotNull
    public static GrAnnotation[] getResolvedAnnotations(@NotNull GrModifierList modifierList) {
        if (modifierList == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrAnnotationCollector", "getResolvedAnnotations"));
        }
        GrAnnotation[] rawAnnotations = modifierList.getRawAnnotations();
        if (!GrAnnotationCollector.hasAliases(rawAnnotations)) {
            if (rawAnnotations == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrAnnotationCollector", "getResolvedAnnotations"));
            }
            return rawAnnotations;
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (GrAnnotation annotation : rawAnnotations) {
            PsiAnnotation annotationCollector = GrAnnotationCollector.findAnnotationCollector(annotation);
            if (annotationCollector != null) {
                GrAnnotationCollector.collectAnnotations(result, annotation, annotationCollector);
                continue;
            }
            result.add(annotation);
        }
        GrAnnotation[] grAnnotationArray = result.toArray(new GrAnnotation[result.size()]);
        if (grAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrAnnotationCollector", "getResolvedAnnotations"));
        }
        return grAnnotationArray;
    }

    private static boolean hasAliases(@NotNull GrAnnotation[] rawAnnotations) {
        if (rawAnnotations == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrAnnotationCollector", "hasAliases"));
        }
        for (GrAnnotation annotation : rawAnnotations) {
            PsiAnnotation annotationCollector = GrAnnotationCollector.findAnnotationCollector(annotation);
            if (annotationCollector == null) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static Set<String> collectAnnotations(@NotNull List<GrAnnotation> list, @NotNull GrAnnotation alias, @NotNull PsiAnnotation annotationCollector) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrAnnotationCollector", "collectAnnotations"));
        }
        if (alias == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrAnnotationCollector", "collectAnnotations"));
        }
        if (annotationCollector == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrAnnotationCollector", "collectAnnotations"));
        }
        PsiModifierList modifierList = (PsiModifierList)annotationCollector.getParent();
        HashMap annotations = ContainerUtil.newHashMap();
        GrAnnotationCollector.collectAliasedAnnotationsFromAnnotationCollectorValueAttribute(annotationCollector, annotations);
        GrAnnotationCollector.collectAliasedAnnotationsFromAnnotationCollectorAnnotations(modifierList, annotations);
        PsiManager manager = alias.getManager();
        GrAnnotationNameValuePair[] attributes = alias.getParameterList().getAttributes();
        HashSet allUsedAttrs = ContainerUtil.newHashSet();
        for (Map.Entry entry : annotations.entrySet()) {
            String qname = (String)entry.getKey();
            PsiClass resolved = JavaPsiFacade.getInstance((Project)alias.getProject()).findClass(qname, alias.getResolveScope());
            if (resolved == null) continue;
            GrLightAnnotation annotation = new GrLightAnnotation(manager, alias.getLanguage(), qname, (PsiAnnotationOwner)modifierList);
            HashSet usedAttrs = ContainerUtil.newHashSet();
            for (GrAnnotationNameValuePair attr : attributes) {
                String name;
                String string = name = attr.getName() != null ? attr.getName() : "value";
                if (resolved.findMethodsByName(name, false).length <= 0) continue;
                annotation.addAttribute(attr);
                allUsedAttrs.add(name);
                usedAttrs.add(name);
            }
            Map defaults = (Map)entry.getValue();
            for (Map.Entry defa : defaults.entrySet()) {
                if (usedAttrs.contains(defa.getKey())) continue;
                annotation.addAttribute((PsiNameValuePair)defa.getValue());
            }
            list.add(annotation);
        }
        HashSet hashSet = allUsedAttrs;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrAnnotationCollector", "collectAnnotations"));
        }
        return hashSet;
    }

    private static void collectAliasedAnnotationsFromAnnotationCollectorAnnotations(@NotNull PsiModifierList modifierList, @NotNull HashMap<String, Map<String, PsiNameValuePair>> annotations) {
        PsiAnnotation[] rawAnnotations;
        if (modifierList == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrAnnotationCollector", "collectAliasedAnnotationsFromAnnotationCollectorAnnotations"));
        }
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrAnnotationCollector", "collectAliasedAnnotationsFromAnnotationCollectorAnnotations"));
        }
        PsiElement parent = modifierList.getParent();
        if (parent instanceof PsiClass && "groovy.transform.CompileDynamic".equals(((PsiClass)parent).getQualifiedName())) {
            HashMap params = ContainerUtil.newHashMap();
            annotations.put("groovy.transform.CompileStatic", params);
            GrAnnotation annotation = GroovyPsiElementFactory.getInstance(modifierList.getProject()).createAnnotationFromText("@CompileStatic(TypeCheckingMode.SKIP)");
            params.put("value", annotation.getParameterList().getAttributes()[0]);
            return;
        }
        for (PsiAnnotation annotation : rawAnnotations = modifierList instanceof GrModifierList ? ((GrModifierList)modifierList).getRawAnnotations() : modifierList.getAnnotations()) {
            PsiNameValuePair[] attributes;
            String qname = annotation.getQualifiedName();
            if (qname == null || qname.equals("groovy.transform.AnnotationCollector")) continue;
            for (PsiNameValuePair pair : attributes = annotation.getParameterList().getAttributes()) {
                HashMap map = annotations.get(qname);
                if (map == null) {
                    map = ContainerUtil.newHashMap();
                    annotations.put(qname, map);
                }
                map.put(pair.getName() != null ? pair.getName() : "value", pair);
            }
            if (attributes.length != 0 || annotations.containsKey(qname)) continue;
            annotations.put(qname, ContainerUtil.newHashMap());
        }
    }

    private static void collectAliasedAnnotationsFromAnnotationCollectorValueAttribute(@NotNull PsiAnnotation annotationCollector, @NotNull HashMap<String, Map<String, PsiNameValuePair>> annotations) {
        if (annotationCollector == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrAnnotationCollector", "collectAliasedAnnotationsFromAnnotationCollectorValueAttribute"));
        }
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrAnnotationCollector", "collectAliasedAnnotationsFromAnnotationCollectorValueAttribute"));
        }
        PsiAnnotationMemberValue annotationsFromValue = annotationCollector.findAttributeValue("value");
        if (annotationsFromValue instanceof GrAnnotationArrayInitializer) {
            for (GrAnnotationMemberValue member : ((GrAnnotationArrayInitializer)annotationsFromValue).getInitializers()) {
                PsiElement resolved;
                if (!(member instanceof GrReferenceExpression) || !((resolved = ((GrReferenceExpression)member).resolve()) instanceof PsiClass) || !((PsiClass)resolved).isAnnotationType()) continue;
                annotations.put(((PsiClass)resolved).getQualifiedName(), ContainerUtil.newHashMap());
            }
        }
    }

    @Nullable
    public static PsiAnnotation findAnnotationCollector(@Nullable PsiClass clazz) {
        PsiModifierList modifierList;
        if (clazz != null && (modifierList = clazz.getModifierList()) != null) {
            PsiAnnotation[] annotations;
            for (PsiAnnotation annotation : annotations = modifierList instanceof GrModifierList ? ((GrModifierList)modifierList).getRawAnnotations() : modifierList.getAnnotations()) {
                if (!"groovy.transform.AnnotationCollector".equals(annotation.getQualifiedName())) continue;
                return annotation;
            }
        }
        return null;
    }

    @Nullable
    public static PsiAnnotation findAnnotationCollector(@NotNull GrAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrAnnotationCollector", "findAnnotationCollector"));
        }
        GrCodeReferenceElement ref = annotation.getClassReference();
        PsiElement resolved = ref.resolve();
        if (resolved instanceof PsiClass) {
            return GrAnnotationCollector.findAnnotationCollector((PsiClass)resolved);
        }
        return null;
    }
}

