/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.PackageEntry;
import com.intellij.psi.codeStyle.PackageEntryTable;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.scope.DelegatingScopeProcessor;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import icons.JetgroovyIcons;
import java.util.Comparator;
import java.util.concurrent.ConcurrentMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.codeStyle.GroovyCodeStyleSettings;
import org.jetbrains.plugins.groovy.editor.GroovyImportHelper;
import org.jetbrains.plugins.groovy.editor.GroovyImportOptimizer;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptTypeDetector;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTopLevelDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.GrTopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileBaseImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrBindingVariable;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrFileStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrPackageDefinitionStub;
import org.jetbrains.plugins.groovy.lang.resolve.MethodTypeInferencer;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;

public class GroovyFileImpl
extends GroovyFileBaseImpl
implements GroovyFile {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileImpl");
    private static final String SYNTHETIC_PARAMETER_NAME = "args";
    private static final CachedValueProvider<ConcurrentMap<String, GrBindingVariable>> BINDING_PROVIDER = new CachedValueProvider<ConcurrentMap<String, GrBindingVariable>>(){

        @Nullable
        public CachedValueProvider.Result<ConcurrentMap<String, GrBindingVariable>> compute() {
            ConcurrentMap map = ContainerUtil.newConcurrentMap();
            return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }
    };
    private final Object lock = new Object();
    private volatile Boolean myScript;
    private volatile GroovyScriptClass myScriptClass;
    private volatile GrParameter mySyntheticArgsParameter = null;
    private PsiElement myContext;

    public GroovyFileImpl(FileViewProvider viewProvider) {
        super(viewProvider, GroovyFileType.GROOVY_LANGUAGE);
    }

    @Override
    @NotNull
    public String getPackageName() {
        String name;
        GrPackageDefinition packageDef = this.getPackageDefinition();
        if (packageDef != null && (name = packageDef.getPackageName()) != null) {
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileImpl", "getPackageName"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileImpl", "getPackageName"));
        }
        return "";
    }

    @Override
    public GrPackageDefinition getPackageDefinition() {
        StubElement stub = this.getStub();
        if (stub != null) {
            for (StubElement element : stub.getChildrenStubs()) {
                if (!(element instanceof GrPackageDefinitionStub)) continue;
                return (GrPackageDefinition)element.getPsi();
            }
            return null;
        }
        ASTNode node = this.calcTreeElement().findChildByType((IElementType)GroovyElementTypes.PACKAGE_DEFINITION);
        return node != null ? (GrPackageDefinition)node.getPsi() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GrParameter getSyntheticArgsParameter() {
        if (this.mySyntheticArgsParameter == null) {
            PsiType psiType = JavaPsiFacade.getElementFactory((Project)this.getProject()).createTypeFromText("java.lang.String[]", (PsiElement)this);
            GrLightParameter candidate = new GrLightParameter(SYNTHETIC_PARAMETER_NAME, psiType, this);
            Object object = this.lock;
            synchronized (object) {
                if (this.mySyntheticArgsParameter == null) {
                    this.mySyntheticArgsParameter = candidate;
                }
            }
        }
        return this.mySyntheticArgsParameter;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileImpl", "processDeclarations"));
        }
        if (this.myContext != null) {
            return this.processChildrenScopes(processor, state, lastParent, place);
        }
        GroovyScriptClass scriptClass = this.getScriptClass();
        if (scriptClass != null && scriptClass.getName() != null) {
            if (!(lastParent instanceof GrTypeDefinition) && !scriptClass.processDeclarations(processor, state, lastParent, place)) {
                return false;
            }
            if (!ResolveUtil.processElement(processor, (PsiNamedElement)scriptClass, state)) {
                return false;
            }
        }
        for (GrTypeDefinition definition : this.getTypeDefinitions()) {
            if (ResolveUtil.processElement(processor, definition, state)) continue;
            return false;
        }
        if (!this.processChildrenScopes(processor, state, lastParent, place)) {
            return false;
        }
        ClassHint classHint = (ClassHint)processor.getHint(ClassHint.KEY);
        boolean processClasses = classHint == null || classHint.shouldProcess(ClassHint.ResolveKind.CLASS);
        String expectedName = ResolveUtil.getNameHint(processor);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.getProject());
        GrImportStatement[] importStatements = this.getImportStatements();
        if (!this.processImports(processor, state, lastParent, place, importStatements, false)) {
            return false;
        }
        if (!GroovyFileImpl.processDeclarationsInPackage(processor, state, lastParent, place, facade, this.getPackageName())) {
            return false;
        }
        if (!this.processImports(processor, state, lastParent, place, importStatements, true)) {
            return false;
        }
        if (processClasses && !GroovyImportHelper.processImplicitImports(processor, state, lastParent, place, this)) {
            return false;
        }
        if (classHint == null || classHint.shouldProcess(ClassHint.ResolveKind.PACKAGE)) {
            if (expectedName != null) {
                PsiPackage pkg = facade.findPackage(expectedName);
                if (pkg != null && !processor.execute((PsiElement)pkg, state)) {
                    return false;
                }
            } else {
                PsiPackage defaultPackage = facade.findPackage("");
                if (defaultPackage != null) {
                    for (PsiPackage subPackage : defaultPackage.getSubPackages(this.getResolveScope())) {
                        if (ResolveUtil.processElement(processor, (PsiNamedElement)subPackage, state)) continue;
                        return false;
                    }
                }
            }
        }
        if (lastParent != null && !(lastParent instanceof GrTypeDefinition) && scriptClass != null && !ResolveUtil.processElement(processor, this.getSyntheticArgsParameter(), state)) {
            return false;
        }
        return !this.isScript() || lastParent instanceof GrTypeDefinition || PsiTreeUtil.getParentOfType((PsiElement)place, GrTypeDefinition.class, (boolean)false) != null || this.processBindings(processor, state, place);
    }

    protected boolean processImports(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place, GrImportStatement[] importStatements, boolean onDemand) {
        return GroovyImportHelper.processImports(state, lastParent, place, processor, importStatements, onDemand);
    }

    private boolean processBindings(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileImpl", "processBindings"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileImpl", "processBindings"));
        }
        if (!this.isPhysical()) {
            return true;
        }
        NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
        if (nameHint == null) {
            return true;
        }
        String name = nameHint.getName(state);
        if (name == null) {
            return true;
        }
        ClassHint classHint = (ClassHint)processor.getHint(ClassHint.KEY);
        if (classHint != null && !classHint.shouldProcess(ClassHint.ResolveKind.PROPERTY)) {
            return true;
        }
        ConcurrentMap<String, GrBindingVariable> bindings = this.getBindings();
        GrBindingVariable variable = (GrBindingVariable)bindings.get(name);
        if (variable == null) {
            variable = (GrBindingVariable)ConcurrencyUtil.cacheOrGet(bindings, (Object)name, (Object)new GrBindingVariable(this, name, null));
        }
        variable.updateWriteAccessIfNeeded(place);
        if (!variable.hasWriteAccess()) {
            return true;
        }
        return processor.execute((PsiElement)variable, state);
    }

    private ConcurrentMap<String, GrBindingVariable> getBindings() {
        return (ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)this, BINDING_PROVIDER);
    }

    @Nullable
    private PsiElement getShellComment() {
        ASTNode node = this.getNode().findChildByType(GroovyTokenTypes.mSH_COMMENT);
        return node == null ? null : node.getPsi();
    }

    @Override
    public boolean isTopControlFlowOwner() {
        return true;
    }

    private static boolean processDeclarationsInPackage(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place, JavaPsiFacade facade, String packageName) {
        PsiPackage aPackage = facade.findPackage(packageName);
        return aPackage == null || aPackage.processDeclarations((PsiScopeProcessor)new DelegatingScopeProcessor(processor){

            public boolean execute(@NotNull PsiElement element, ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileImpl$2", "execute"));
                }
                if (element instanceof PsiPackage) {
                    return true;
                }
                return super.execute(element, state);
            }
        }, state, lastParent, place);
    }

    private boolean processChildrenScopes(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        PsiElement run;
        StubElement stub = this.getStub();
        if (stub != null) {
            return true;
        }
        PsiElement psiElement = run = lastParent == null ? this.getLastChild() : lastParent.getPrevSibling();
        while (run != null) {
            if (GroovyFileImpl.shouldProcess(lastParent, run) && !run.processDeclarations(processor, state, null, place)) {
                return false;
            }
            run = run.getPrevSibling();
        }
        return true;
    }

    private static boolean shouldProcess(PsiElement lastParent, PsiElement run) {
        return !(run instanceof GrTopLevelDefinition) && !(run instanceof GrImportStatement) && !(lastParent instanceof GrMember);
    }

    @Override
    public GrImportStatement[] getImportStatements() {
        StubElement stub = this.getStub();
        if (stub != null) {
            return (GrImportStatement[])stub.getChildrenByType((IElementType)GroovyElementTypes.IMPORT_STATEMENT, GrImportStatement.ARRAY_FACTORY);
        }
        return (GrImportStatement[])this.calcTreeElement().getChildrenAsPsiElements((IElementType)GroovyElementTypes.IMPORT_STATEMENT, GrImportStatement.ARRAY_FACTORY);
    }

    @Nullable
    public Icon getIcon(int flags) {
        Icon baseIcon = this.isScript() ? GroovyScriptTypeDetector.getScriptType(this).getScriptIcon() : JetgroovyIcons.Groovy.Groovy_16x16;
        return ElementBase.createLayeredIcon((Iconable)this, (Icon)baseIcon, (int)ElementBase.transformFlags((PsiElement)this, (int)flags));
    }

    @Override
    public GrImportStatement addImportForClass(PsiClass aClass) {
        try {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
            GrImportStatement importStatement = factory.createImportStatementFromText(aClass.getQualifiedName(), false, false, null);
            return this.addImport(importStatement);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Nullable
    private PsiElement getAnchorToInsertImportAfter(GrImportStatement statement) {
        GroovyCodeStyleSettings settings = (GroovyCodeStyleSettings)CodeStyleSettingsManager.getInstance((Project)this.getProject()).getCurrentSettings().getCustomSettings(GroovyCodeStyleSettings.class);
        PackageEntryTable layoutTable = settings.IMPORT_LAYOUT_TABLE;
        PackageEntry[] entries = layoutTable.getEntries();
        GrImportStatement[] importStatements = this.getImportStatements();
        if (importStatements.length == 0) {
            GrPackageDefinition definition = this.getPackageDefinition();
            if (definition != null) {
                return definition;
            }
            return this.getShellComment();
        }
        Comparator<GrImportStatement> comparator = GroovyImportOptimizer.getComparator(settings);
        int idx = GroovyFileImpl.getPackageEntryIdx(entries, statement);
        GrTopStatement anchor = null;
        for (GrImportStatement importStatement : importStatements) {
            int i = GroovyFileImpl.getPackageEntryIdx(entries, importStatement);
            if (i < idx) {
                anchor = importStatement;
                continue;
            }
            if (i > idx || comparator.compare(statement, importStatement) <= 0) break;
            anchor = importStatement;
        }
        if (anchor == null) {
            anchor = this.getPackageDefinition();
        }
        if (anchor == null) {
            anchor = this.getShellComment();
        }
        if (anchor == null && importStatements.length > 0) {
            anchor = importStatements[0].getPrevSibling();
        }
        return anchor;
    }

    @Override
    public GrImportStatement addImport(GrImportStatement statement) throws IncorrectOperationException {
        PsiElement anchor = this.getAnchorToInsertImportAfter(statement);
        PsiElement result = this.addAfter(statement, anchor);
        GrImportStatement gImport = (GrImportStatement)result;
        this.addLineFeedBefore(gImport);
        this.addLineFeedAfter(gImport);
        return gImport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isScript() {
        StubElement stub = this.getStub();
        if (stub instanceof GrFileStub) {
            return ((GrFileStub)stub).isScript();
        }
        if (this.myScript == null) {
            Object object = this.lock;
            synchronized (object) {
                boolean isScript = this.checkIsScript();
                if (this.myScript == null) {
                    this.myScript = isScript;
                }
            }
        }
        return this.myScript;
    }

    private boolean checkIsScript() {
        GrTopStatement[] topStatements = (GrTopStatement[])this.findChildrenByClass(GrTopStatement.class);
        boolean hasClassDefinitions = false;
        boolean hasTopStatements = false;
        for (GrTopStatement st : topStatements) {
            if (st instanceof GrTypeDefinition) {
                hasClassDefinitions = true;
                continue;
            }
            if (st instanceof GrImportStatement || st instanceof GrPackageDefinition) continue;
            hasTopStatements = true;
            break;
        }
        return hasTopStatements || !hasClassDefinitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subtreeChanged() {
        Object object = this.lock;
        synchronized (object) {
            this.myScript = null;
        }
        super.subtreeChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GroovyScriptClass getScriptClass() {
        if (this.isScript()) {
            if (this.myScriptClass == null) {
                GroovyScriptClass candidate = new GroovyScriptClass(this);
                Object object = this.lock;
                synchronized (object) {
                    if (this.myScriptClass == null) {
                        this.myScriptClass = candidate;
                    }
                }
            }
            return this.myScriptClass;
        }
        return null;
    }

    @Override
    public void setPackageName(String packageName) {
        GrCodeReferenceElement packageReference;
        FileASTNode fileNode = this.getNode();
        assert (fileNode != null);
        GrPackageDefinition currentPackage = this.getPackageDefinition();
        if (packageName == null || packageName.length() == 0) {
            if (currentPackage != null) {
                ASTNode currNode = currentPackage.getNode();
                fileNode.removeChild(currNode);
            }
            return;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
        GrPackageDefinition newPackage = (GrPackageDefinition)factory.createTopElementFromText("package " + packageName);
        if (currentPackage != null && (packageReference = currentPackage.getPackageReference()) != null) {
            GrCodeReferenceElement ref = newPackage.getPackageReference();
            if (ref != null) {
                packageReference.replace(ref);
            }
            return;
        }
        ASTNode newNode = newPackage.getNode();
        if (currentPackage != null) {
            ASTNode currNode = currentPackage.getNode();
            fileNode.replaceChild(currNode, newNode);
        } else {
            ASTNode anchor = fileNode.getFirstChildNode();
            if (anchor != null && anchor.getElementType() == GroovyTokenTypes.mSH_COMMENT) {
                anchor = anchor.getTreeNext();
                fileNode.addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", anchor);
            }
            fileNode.addChild(newNode, anchor);
            if (anchor != null && !anchor.getText().startsWith("\n\n")) {
                fileNode.addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", anchor);
            }
        }
    }

    @Override
    @Nullable
    public GrPackageDefinition setPackage(@Nullable GrPackageDefinition newPackage) {
        GrPackageDefinition oldPackage = this.getPackageDefinition();
        if (oldPackage == null) {
            if (newPackage != null) {
                GrPackageDefinition result = (GrPackageDefinition)this.addAfter(newPackage, null);
                this.getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", result.getNode().getTreeNext());
                return result;
            }
        } else {
            if (newPackage != null) {
                return (GrPackageDefinition)oldPackage.replace(newPackage);
            }
            oldPackage.delete();
        }
        return null;
    }

    @Override
    public PsiType getInferredScriptReturnType() {
        return (PsiType)CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)new CachedValueProvider<PsiType>(){

            public CachedValueProvider.Result<PsiType> compute() {
                return CachedValueProvider.Result.create((Object)GroovyPsiManager.inferType(GroovyFileImpl.this, new MethodTypeInferencer(GroovyFileImpl.this)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCaches() {
        super.clearCaches();
        Object object = this.lock;
        synchronized (object) {
            this.myScriptClass = null;
            this.mySyntheticArgsParameter = null;
        }
    }

    public PsiElement getContext() {
        if (this.myContext != null) {
            return this.myContext;
        }
        return super.getContext();
    }

    protected GroovyFileImpl clone() {
        GroovyFileImpl clone = (GroovyFileImpl)super.clone();
        clone.myContext = this.myContext;
        return clone;
    }

    public void setContext(PsiElement context) {
        if (context != null) {
            this.myContext = context;
        }
    }

    public void setContextNullable(PsiElement context) {
        this.myContext = context;
    }

    @Override
    @NotNull
    public PsiClass[] getClasses() {
        PsiClass[] declaredDefs = super.getClasses();
        if (!this.isScript()) {
            if (declaredDefs == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileImpl", "getClasses"));
            }
            return declaredDefs;
        }
        GroovyScriptClass scriptClass = this.getScriptClass();
        PsiClass[] result = new PsiClass[declaredDefs.length + 1];
        result[result.length - 1] = scriptClass;
        System.arraycopy(declaredDefs, 0, result, 0, declaredDefs.length);
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileImpl", "getClasses"));
        }
        return result;
    }

    public PsiElement getOriginalElement() {
        PsiElement originalElement;
        GroovyScriptClass scriptClass = this.getScriptClass();
        if (scriptClass != null && (originalElement = scriptClass.getOriginalElement()) != scriptClass && originalElement != null) {
            return originalElement.getContainingFile();
        }
        return this;
    }

    @Override
    public String toString() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return super.toString();
        }
        return "GroovyFileImpl:" + this.getName();
    }
}

