/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.PackageEntry;
import com.intellij.psi.codeStyle.PackageEntryTable;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.reference.SoftReference;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.codeStyle.GroovyCodeStyleSettings;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTopLevelDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.GrTopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ControlFlowBuilder;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public abstract class GroovyFileBaseImpl
extends PsiFileBase
implements GroovyFileBase,
GrControlFlowOwner {
    private GrMethod[] myMethods;
    private volatile SoftReference<Instruction[]> myControlFlow;

    public void subtreeChanged() {
        super.subtreeChanged();
        this.myMethods = null;
    }

    protected GroovyFileBaseImpl(FileViewProvider viewProvider, @NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileBaseImpl", "<init>"));
        }
        super(viewProvider, language);
        this.myMethods = null;
        this.myControlFlow = null;
    }

    public GroovyFileBaseImpl(IFileElementType root, IFileElementType root1, FileViewProvider provider) {
        this(provider, root.getLanguage());
        this.init((IElementType)root, (IElementType)root1);
    }

    @NotNull
    public FileType getFileType() {
        GroovyFileType groovyFileType = GroovyFileType.GROOVY_FILE_TYPE;
        if (groovyFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileBaseImpl", "getFileType"));
        }
        return groovyFileType;
    }

    public String toString() {
        return "Groovy script";
    }

    @Override
    public GrTypeDefinition[] getTypeDefinitions() {
        StubElement stub = this.getStub();
        if (stub != null) {
            return (GrTypeDefinition[])stub.getChildrenByType(GroovyElementTypes.TYPE_DEFINITION_TYPES, GrTypeDefinition.ARRAY_FACTORY);
        }
        return (GrTypeDefinition[])this.calcTreeElement().getChildrenAsPsiElements(GroovyElementTypes.TYPE_DEFINITION_TYPES, GrTypeDefinition.ARRAY_FACTORY);
    }

    @Override
    public GrTopLevelDefinition[] getTopLevelDefinitions() {
        return (GrTopLevelDefinition[])this.findChildrenByClass(GrTopLevelDefinition.class);
    }

    @Override
    public GrMethod[] getCodeMethods() {
        StubElement stub = this.getStub();
        if (stub != null) {
            return (GrMethod[])stub.getChildrenByType((IElementType)GroovyElementTypes.METHOD_DEFINITION, GrMethod.ARRAY_FACTORY);
        }
        return (GrMethod[])this.calcTreeElement().getChildrenAsPsiElements((IElementType)GroovyElementTypes.METHOD_DEFINITION, GrMethod.ARRAY_FACTORY);
    }

    @Override
    public GrMethod[] getMethods() {
        if (this.myMethods == null) {
            GrMethod[] methods;
            ArrayList<GrMethod> result = new ArrayList<GrMethod>();
            for (GrMethod method : methods = this.getCodeMethods()) {
                GrReflectedMethod[] reflectedMethods = method.getReflectedMethods();
                if (reflectedMethods.length > 0) {
                    result.addAll(Arrays.asList(reflectedMethods));
                    continue;
                }
                result.add(method);
            }
            this.myMethods = result.toArray(new GrMethod[result.size()]);
        }
        return this.myMethods;
    }

    @Override
    public GrTopStatement[] getTopStatements() {
        return (GrTopStatement[])this.findChildrenByClass(GrTopStatement.class);
    }

    public boolean importClass(PsiClass aClass) {
        return this.addImportForClass(aClass) != null;
    }

    @Override
    public void removeImport(GrImportStatement importStatement) throws IncorrectOperationException {
        GrImportStatement after;
        GrImportStatement before = importStatement;
        while (PsiImplUtil.isWhiteSpaceOrNls(before.getPrevSibling())) {
            before = before.getPrevSibling();
        }
        if (PsiImplUtil.hasElementType(before.getPrevSibling(), GroovyTokenTypes.mSEMI)) {
            before = before.getPrevSibling();
        }
        if (PsiImplUtil.isWhiteSpaceOrNls(before.getPrevSibling())) {
            before = before.getPrevSibling();
        }
        if (PsiImplUtil.isWhiteSpaceOrNls((after = importStatement).getNextSibling())) {
            after = after.getNextSibling();
        }
        if (PsiImplUtil.hasElementType(after.getNextSibling(), GroovyTokenTypes.mSEMI)) {
            after = after.getNextSibling();
        }
        while (PsiImplUtil.isWhiteSpaceOrNls(after.getNextSibling())) {
            after = after.getNextSibling();
        }
        if (before == null) {
            before = importStatement;
        }
        PsiElement anchor_before = before.getPrevSibling();
        PsiElement anchor_after = after.getNextSibling();
        if (before == after) {
            importStatement.delete();
        } else {
            this.deleteChildRange(before, after);
        }
        if (anchor_before instanceof GrImportStatement && anchor_after instanceof GrImportStatement) {
            this.addLineFeedAfter((GrImportStatement)anchor_before);
        } else if (anchor_before != null && anchor_after != null) {
            String text = anchor_after instanceof GrTopStatement && anchor_before instanceof GrTopStatement ? "\n\n" : "\n";
            this.getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)text, anchor_after.getNode());
        }
    }

    @Override
    public void removeElements(PsiElement[] elements) throws IncorrectOperationException {
        for (PsiElement element : elements) {
            if (!element.isValid()) continue;
            if (element.getParent() != this) {
                throw new IncorrectOperationException();
            }
            this.deleteChildRange(element, element);
        }
    }

    @Override
    @NotNull
    public GrStatement[] getStatements() {
        GrStatement[] grStatementArray = (GrStatement[])this.findChildrenByClass(GrStatement.class);
        if (grStatementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileBaseImpl", "getStatements"));
        }
        return grStatementArray;
    }

    @Override
    @NotNull
    public GrStatement addStatementBefore(@NotNull GrStatement statement, @Nullable GrStatement anchor) throws IncorrectOperationException {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileBaseImpl", "addStatementBefore"));
        }
        PsiElement result = this.addBefore(statement, anchor);
        if (anchor != null) {
            this.getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", anchor.getNode());
        } else {
            this.getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", result.getNode());
        }
        GrStatement grStatement = (GrStatement)result;
        if (grStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileBaseImpl", "addStatementBefore"));
        }
        return grStatement;
    }

    @Override
    public void removeVariable(GrVariable variable) {
        PsiImplUtil.removeVariable(variable);
    }

    @Override
    public GrVariableDeclaration addVariableDeclarationBefore(GrVariableDeclaration declaration, GrStatement anchor) throws IncorrectOperationException {
        GrStatement statement = this.addStatementBefore(declaration, anchor);
        assert (statement instanceof GrVariableDeclaration);
        return (GrVariableDeclaration)statement;
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitFile(this);
    }

    @Override
    public void acceptChildren(GroovyElementVisitor visitor) {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof GroovyPsiElement)) continue;
            ((GroovyPsiElement)child).accept(visitor);
        }
    }

    @NotNull
    public PsiClass[] getClasses() {
        PsiClass[] psiClassArray = this.getTypeDefinitions();
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileBaseImpl", "getClasses"));
        }
        return psiClassArray;
    }

    public void clearCaches() {
        super.clearCaches();
        this.myControlFlow = null;
    }

    @Override
    public Instruction[] getControlFlow() {
        assert (this.isValid());
        Instruction[] result = (Instruction[])SoftReference.dereference(this.myControlFlow);
        if (result == null) {
            result = new ControlFlowBuilder(this.getProject()).buildControlFlow(this);
            this.myControlFlow = new SoftReference((Object)result);
        }
        return ControlFlowBuilder.assertValidPsi(result);
    }

    @Override
    public boolean isTopControlFlowOwner() {
        return false;
    }

    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        if (last instanceof GrTopStatement) {
            PsiImplUtil.deleteStatementTail(this, last);
        }
        super.deleteChildRange(first, last);
    }

    protected void addLineFeedBefore(GrImportStatement result) {
        GroovyCodeStyleSettings settings = (GroovyCodeStyleSettings)CodeStyleSettingsManager.getInstance((Project)this.getProject()).getCurrentSettings().getCustomSettings(GroovyCodeStyleSettings.class);
        PackageEntryTable layoutTable = settings.IMPORT_LAYOUT_TABLE;
        PackageEntry[] entries = layoutTable.getEntries();
        PsiElement prev = result.getPrevSibling();
        while (PsiImplUtil.isWhiteSpaceOrNls(prev)) {
            prev = prev.getPrevSibling();
        }
        if (PsiImplUtil.hasElementType(prev, GroovyTokenTypes.mSEMI)) {
            prev = prev.getPrevSibling();
        }
        if (PsiImplUtil.isWhiteSpaceOrNls(prev)) {
            prev = prev.getPrevSibling();
        }
        if (prev instanceof GrImportStatement) {
            int idx_before = GroovyFileBaseImpl.getPackageEntryIdx(entries, (GrImportStatement)prev);
            int idx = GroovyFileBaseImpl.getPackageEntryIdx(entries, result);
            int spaceCount = GroovyFileBaseImpl.getMaxSpaceCount(entries, idx_before, idx);
            if (PsiImplUtil.isWhiteSpaceOrNls(prev.getNextSibling()) && PsiImplUtil.hasElementType(prev.getNextSibling().getNextSibling(), GroovyTokenTypes.mSEMI)) {
                prev = prev.getNextSibling().getNextSibling();
            }
            FileASTNode node = this.getNode();
            while (PsiImplUtil.isWhiteSpaceOrNls(prev.getNextSibling())) {
                node.removeChild(prev.getNextSibling().getNode());
            }
            node.addLeaf(GroovyTokenTypes.mNLS, (CharSequence)StringUtil.repeat((String)"\n", (int)(spaceCount + 1)), result.getNode());
        }
    }

    protected void addLineFeedAfter(GrImportStatement result) {
        GroovyCodeStyleSettings settings = (GroovyCodeStyleSettings)CodeStyleSettingsManager.getInstance((Project)this.getProject()).getCurrentSettings().getCustomSettings(GroovyCodeStyleSettings.class);
        PackageEntryTable layoutTable = settings.IMPORT_LAYOUT_TABLE;
        PackageEntry[] entries = layoutTable.getEntries();
        PsiElement next = result.getNextSibling();
        if (PsiImplUtil.isWhiteSpaceOrNls(next)) {
            next = next.getNextSibling();
        }
        if (PsiImplUtil.hasElementType(next, GroovyTokenTypes.mSEMI)) {
            next = next.getNextSibling();
        }
        while (PsiImplUtil.isWhiteSpaceOrNls(next)) {
            next = next.getNextSibling();
        }
        if (next instanceof GrImportStatement) {
            int idx_after = GroovyFileBaseImpl.getPackageEntryIdx(entries, (GrImportStatement)next);
            int idx = GroovyFileBaseImpl.getPackageEntryIdx(entries, result);
            int spaceCount = GroovyFileBaseImpl.getMaxSpaceCount(entries, idx, idx_after);
            FileASTNode node = this.getNode();
            while (PsiImplUtil.isWhiteSpaceOrNls(next.getPrevSibling())) {
                node.removeChild(next.getPrevSibling().getNode());
            }
            node.addLeaf(GroovyTokenTypes.mNLS, (CharSequence)StringUtil.repeat((String)"\n", (int)(spaceCount + 1)), next.getNode());
        }
    }

    protected static int getPackageEntryIdx(PackageEntry[] entries, GrImportStatement statement) {
        GrCodeReferenceElement reference = statement.getImportReference();
        if (reference == null) {
            return -1;
        }
        String packageName = StringUtil.getPackageName((String)reference.getCanonicalText());
        boolean isStatic = statement.isStatic();
        int best = -1;
        int allOtherStatic = -1;
        int allOther = -1;
        PackageEntry bestEntry = null;
        int length = entries.length;
        for (int i = 0; i < length; ++i) {
            PackageEntry entry = entries[i];
            if (entry.isBetterMatchForPackageThan(bestEntry, packageName, isStatic)) {
                best = i;
                bestEntry = entry;
                continue;
            }
            if (entry == PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY) {
                allOtherStatic = i;
                continue;
            }
            if (entry != PackageEntry.ALL_OTHER_IMPORTS_ENTRY) continue;
            allOther = i;
        }
        if (best >= 0) {
            return best;
        }
        if (isStatic && allOtherStatic != -1) {
            return allOtherStatic;
        }
        return allOther;
    }

    private static int getMaxSpaceCount(PackageEntry[] entries, int b1, int b2) {
        int start = Math.min(b1, b2);
        int end = Math.max(b1, b2);
        if (start == -1) {
            return 0;
        }
        int max = 0;
        int cur = 0;
        for (int i = start; i < end; ++i) {
            if (entries[i] == PackageEntry.BLANK_LINE_ENTRY) {
                ++cur;
                continue;
            }
            max = Math.max(max, cur);
            cur = 0;
        }
        max = Math.max(max, cur);
        return max;
    }
}

