/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.expectedTypes;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class SupertypeConstraint
extends TypeConstraint {
    private final PsiType myDefaultType;

    protected SupertypeConstraint(@NotNull PsiType type, @NotNull PsiType defaultType) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/expectedTypes/SupertypeConstraint", "<init>"));
        }
        if (defaultType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/expectedTypes/SupertypeConstraint", "<init>"));
        }
        super(type);
        this.myDefaultType = defaultType;
    }

    @Override
    public boolean satisfied(PsiType type, @NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/expectedTypes/SupertypeConstraint", "satisfied"));
        }
        return TypesUtil.isAssignableByMethodCallConversion(type, this.getType(), context);
    }

    @Override
    @NotNull
    public PsiType getDefaultType() {
        PsiType psiType = this.myDefaultType;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/expectedTypes/SupertypeConstraint", "getDefaultType"));
        }
        return psiType;
    }

    public static SupertypeConstraint create(@NotNull PsiType type, @NotNull PsiType defaultType) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/expectedTypes/SupertypeConstraint", "create"));
        }
        if (defaultType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/expectedTypes/SupertypeConstraint", "create"));
        }
        return new SupertypeConstraint(type, defaultType);
    }

    public static SupertypeConstraint create(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/expectedTypes/SupertypeConstraint", "create"));
        }
        return new SupertypeConstraint(type, type);
    }
}

