/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.expectedTypes;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class SubtypeConstraint
extends TypeConstraint {
    private final PsiType myDefaultType;

    protected SubtypeConstraint(@NotNull PsiType type, @NotNull PsiType defaultType) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/expectedTypes/SubtypeConstraint", "<init>"));
        }
        if (defaultType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/expectedTypes/SubtypeConstraint", "<init>"));
        }
        super(type);
        this.myDefaultType = defaultType;
    }

    @Override
    public boolean satisfied(PsiType type, @NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/psi/expectedTypes/SubtypeConstraint", "satisfied"));
        }
        return TypesUtil.isAssignableByMethodCallConversion(this.getType(), type, context);
    }

    @Override
    @NotNull
    public PsiType getDefaultType() {
        PsiType psiType = this.myDefaultType;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/expectedTypes/SubtypeConstraint", "getDefaultType"));
        }
        return psiType;
    }

    public static SubtypeConstraint create(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/expectedTypes/SubtypeConstraint", "create"));
        }
        return new SubtypeConstraint(type, type);
    }

    public static SubtypeConstraint create(String fqName, PsiElement context) {
        PsiClassType type = TypesUtil.createType(fqName, context);
        return new SubtypeConstraint((PsiType)type, (PsiType)type);
    }
}

