/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.types;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.typeDefinitions.ReferenceElement;
import org.jetbrains.plugins.groovy.lang.parser.parsing.types.TypeSpec;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class TypeArguments
implements GroovyElementTypes {
    public static boolean parseTypeArguments(PsiBuilder builder, boolean expressionPossible) {
        return TypeArguments.parseTypeArguments(builder, expressionPossible, false);
    }

    public static boolean parseTypeArguments(PsiBuilder builder, boolean expressionPossible, boolean allowDiamond) {
        PsiBuilder.Marker marker = builder.mark();
        if (!ParserUtils.getToken(builder, mLT)) {
            marker.rollbackTo();
            return false;
        }
        ParserUtils.getToken(builder, mNLS);
        if (allowDiamond && ParserUtils.getToken(builder, mGT)) {
            marker.done((IElementType)TYPE_ARGUMENTS);
            return true;
        }
        if (!TypeArguments.parseArgument(builder)) {
            builder.error(GroovyBundle.message("type.argument.expected", new Object[0]));
            if (ParserUtils.getToken(builder, mGT)) {
                marker.done((IElementType)TYPE_ARGUMENTS);
                return true;
            }
            marker.rollbackTo();
            return false;
        }
        boolean hasComma = ParserUtils.lookAhead(builder, mCOMMA);
        while (ParserUtils.getToken(builder, mCOMMA)) {
            ParserUtils.getToken(builder, mNLS);
            if (TypeArguments.parseArgument(builder)) continue;
            builder.error("type.argument.expected");
        }
        PsiBuilder.Marker rb = builder.mark();
        ParserUtils.getToken(builder, mNLS);
        if (ParserUtils.getToken(builder, mGT)) {
            rb.drop();
        } else if (hasComma) {
            rb.rollbackTo();
            builder.error(GroovyBundle.message("gt.expected", new Object[0]));
        } else {
            rb.drop();
            if (expressionPossible) {
                marker.rollbackTo();
                return false;
            }
            builder.error(GroovyBundle.message("gt.expected", new Object[0]));
        }
        marker.done((IElementType)TYPE_ARGUMENTS);
        return true;
    }

    private static boolean parseArgument(PsiBuilder builder) {
        if (builder.getTokenType() == mQUESTION) {
            PsiBuilder.Marker taMarker = builder.mark();
            ParserUtils.getToken(builder, mQUESTION);
            if (ParserUtils.getToken(builder, kSUPER) || ParserUtils.getToken(builder, kEXTENDS)) {
                ParserUtils.getToken(builder, mNLS);
                TypeSpec.parse(builder, false, false);
                ParserUtils.getToken(builder, mNLS);
            }
            taMarker.done((IElementType)TYPE_ARGUMENT);
            return true;
        }
        return TypeSpec.parse(builder, false, false) != ReferenceElement.ReferenceElementResult.FAIL;
    }
}

