/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.typeDefinitions;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyElementType;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.typeDefinitions.ClassType;
import org.jetbrains.plugins.groovy.lang.parser.parsing.types.TypeArguments;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;
import org.jetbrains.plugins.groovy.lang.psi.stubs.elements.GrReferenceListElementType;

public class ReferenceElement
implements GroovyElementTypes {
    public static final String DUMMY_IDENTIFIER = "IntellijIdeaRulezzz";

    @NotNull
    public static IElementType parseReferenceList(@NotNull PsiBuilder builder, @NotNull IElementType startElement, @NotNull GrReferenceListElementType<?> clauseType, @NotNull ClassType type) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/ReferenceElement", "parseReferenceList"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/ReferenceElement", "parseReferenceList"));
        }
        if (clauseType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/ReferenceElement", "parseReferenceList"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/ReferenceElement", "parseReferenceList"));
        }
        PsiBuilder.Marker isMarker = builder.mark();
        if (!ParserUtils.getToken(builder, startElement)) {
            if (clauseType == IMPLEMENTS_CLAUSE && (type == ClassType.INTERFACE || type == ClassType.ANNOTATION) || clauseType == EXTENDS_CLAUSE && type == ClassType.ENUM || type == ClassType.ANNOTATION) {
                isMarker.rollbackTo();
                GroovyElementType groovyElementType = NONE;
                if (groovyElementType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/ReferenceElement", "parseReferenceList"));
                }
                return groovyElementType;
            }
            GrReferenceListElementType<?> grReferenceListElementType = ReferenceElement.finish(clauseType, isMarker, null);
            if (grReferenceListElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/ReferenceElement", "parseReferenceList"));
            }
            return grReferenceListElementType;
        }
        PsiBuilder.Marker space = builder.mark();
        ParserUtils.getToken(builder, mNLS);
        if (ReferenceElement.parseReferenceElement(builder) == ReferenceElementResult.FAIL) {
            GrReferenceListElementType<?> grReferenceListElementType = ReferenceElement.finish(clauseType, isMarker, space);
            if (grReferenceListElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/ReferenceElement", "parseReferenceList"));
            }
            return grReferenceListElementType;
        }
        space.drop();
        while (ParserUtils.getToken(builder, mCOMMA)) {
            space = builder.mark();
            ParserUtils.getToken(builder, mNLS);
            if (ReferenceElement.parseReferenceElement(builder) == ReferenceElementResult.FAIL) {
                GrReferenceListElementType<?> grReferenceListElementType = ReferenceElement.finish(clauseType, isMarker, space);
                if (grReferenceListElementType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/ReferenceElement", "parseReferenceList"));
                }
                return grReferenceListElementType;
            }
            space.drop();
        }
        GrReferenceListElementType<?> grReferenceListElementType = ReferenceElement.finish(clauseType, isMarker, null);
        if (grReferenceListElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/ReferenceElement", "parseReferenceList"));
        }
        return grReferenceListElementType;
    }

    @NotNull
    private static GrReferenceListElementType<?> finish(@NotNull GrReferenceListElementType<?> clauseType, @NotNull PsiBuilder.Marker isMarker, @Nullable PsiBuilder.Marker space) {
        if (clauseType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/ReferenceElement", "finish"));
        }
        if (isMarker == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/ReferenceElement", "finish"));
        }
        if (space != null) {
            space.rollbackTo();
        }
        isMarker.done(clauseType);
        GrReferenceListElementType<?> grReferenceListElementType = clauseType;
        if (grReferenceListElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/ReferenceElement", "finish"));
        }
        return grReferenceListElementType;
    }

    public static ReferenceElementResult parseForImport(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/ReferenceElement", "parseForImport"));
        }
        return ReferenceElement.parse(builder, false, false, true, false, false);
    }

    public static ReferenceElementResult parseForPackage(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/ReferenceElement", "parseForPackage"));
        }
        return ReferenceElement.parse(builder, false, false, true, false, false);
    }

    public static ReferenceElementResult parseReferenceElement(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/ReferenceElement", "parseReferenceElement"));
        }
        return ReferenceElement.parseReferenceElement(builder, false, true);
    }

    public static ReferenceElementResult parseReferenceElement(@NotNull PsiBuilder builder, boolean isUpperCase, boolean expressionPossible) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/ReferenceElement", "parseReferenceElement"));
        }
        return ReferenceElement.parse(builder, isUpperCase, true, false, false, expressionPossible);
    }

    public static ReferenceElementResult parse(@NotNull PsiBuilder builder, boolean checkUpperCase, boolean parseTypeArgs, boolean lineFeedAllowed, boolean allowDiamond, boolean expressionPossible) {
        boolean hasDots;
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/ReferenceElement", "parse"));
        }
        PsiBuilder.Marker internalTypeMarker = builder.mark();
        String lastIdentifier = builder.getTokenText();
        if (!ParserUtils.getToken(builder, TokenSets.CODE_REFERENCE_ELEMENT_NAME_TOKENS)) {
            internalTypeMarker.rollbackTo();
            return ReferenceElementResult.FAIL;
        }
        boolean hasTypeArguments = false;
        if (parseTypeArgs && TypeArguments.parseTypeArguments(builder, expressionPossible, allowDiamond)) {
            hasTypeArguments = true;
        }
        internalTypeMarker.done((IElementType)REFERENCE_ELEMENT);
        internalTypeMarker = internalTypeMarker.precede();
        boolean bl = hasDots = builder.getTokenType() == mDOT;
        while (builder.getTokenType() == mDOT) {
            if ((ParserUtils.lookAhead(builder, mDOT, mSTAR) || ParserUtils.lookAhead(builder, mDOT, mNLS, mSTAR)) && lineFeedAllowed) {
                internalTypeMarker.drop();
                return ReferenceElementResult.PATH_REF;
            }
            ParserUtils.getToken(builder, mDOT);
            if (lineFeedAllowed) {
                ParserUtils.getToken(builder, mNLS);
            }
            lastIdentifier = builder.getTokenText();
            if (!ParserUtils.getToken(builder, TokenSets.CODE_REFERENCE_ELEMENT_NAME_TOKENS)) {
                if (TokenSets.REFERENCE_NAME_PREFIXES.contains(builder.getTokenType())) {
                    internalTypeMarker.rollbackTo();
                    return ReferenceElementResult.FAIL;
                }
                builder.error(GroovyBundle.message("identifier.expected", new Object[0]));
                internalTypeMarker.done((IElementType)REFERENCE_ELEMENT);
                return ReferenceElementResult.PATH_REF;
            }
            if (parseTypeArgs && TypeArguments.parseTypeArguments(builder, expressionPossible, allowDiamond)) {
                hasTypeArguments = true;
            }
            internalTypeMarker.done((IElementType)REFERENCE_ELEMENT);
            internalTypeMarker = internalTypeMarker.precede();
        }
        if (lastIdentifier == null) {
            return ReferenceElementResult.FAIL;
        }
        char firstChar = lastIdentifier.charAt(0);
        if (checkUpperCase && (!Character.isUpperCase(firstChar) || DUMMY_IDENTIFIER.equals(lastIdentifier))) {
            internalTypeMarker.rollbackTo();
            return ReferenceElementResult.FAIL;
        }
        internalTypeMarker.drop();
        return hasTypeArguments ? ReferenceElementResult.REF_WITH_TYPE_PARAMS : (hasDots ? ReferenceElementResult.PATH_REF : ReferenceElementResult.IDENTIFIER);
    }

    public static enum ReferenceElementResult {
        IDENTIFIER,
        PATH_REF,
        REF_WITH_TYPE_PARAMS,
        FAIL;

    }
}

