/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.primary;

import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyElementType;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.blocks.OpenOrClosableBlock;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.arithmetic.PathExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class CompoundStringExpression
implements GroovyElementTypes {
    private static final Logger LOG = Logger.getInstance(CompoundStringExpression.class);
    private final PsiBuilder myBuilder;
    private final GroovyParser myParser;
    private final boolean myForRefExpr;
    private final IElementType myBegin;
    private final IElementType myContent;
    private final IElementType myEnd;
    private final IElementType mySimpleLiteral;
    private final GroovyElementType myCompoundLiteral;
    private final String myMessage;

    private CompoundStringExpression(PsiBuilder builder, GroovyParser parser, boolean forRefExpr, IElementType begin, IElementType content, IElementType end, IElementType literal, GroovyElementType compoundLiteral, String message) {
        this.myBuilder = builder;
        this.myParser = parser;
        this.myForRefExpr = forRefExpr;
        this.myBegin = begin;
        this.myContent = content;
        this.myEnd = end;
        this.mySimpleLiteral = literal;
        this.myCompoundLiteral = compoundLiteral;
        this.myMessage = message;
    }

    private boolean parse() {
        boolean hasInjection;
        PsiBuilder.Marker marker = this.myBuilder.mark();
        PsiBuilder.Marker marker2 = this.myBuilder.mark();
        LOG.assertTrue(ParserUtils.getToken(this.myBuilder, this.myBegin));
        if (this.mySimpleLiteral != null && this.myBuilder.getTokenType() == this.myEnd) {
            this.myBuilder.advanceLexer();
            this.finishSimpleLiteral(marker, marker2);
            return true;
        }
        if (this.myBuilder.getTokenType() == this.myContent) {
            PsiBuilder.Marker contentMarker = this.myBuilder.mark();
            this.myBuilder.advanceLexer();
            if (this.myBuilder.getTokenType() == mDOLLAR || this.mySimpleLiteral == null) {
                contentMarker.done((IElementType)GSTRING_CONTENT);
            } else {
                contentMarker.drop();
            }
        } else {
            this.processContent();
        }
        boolean bl = hasInjection = this.myBuilder.getTokenType() == mDOLLAR;
        while (this.myBuilder.getTokenType() == mDOLLAR) {
            this.parseInjection();
            this.processContent();
        }
        if (!ParserUtils.getToken(this.myBuilder, this.myEnd)) {
            this.myBuilder.error(this.myMessage);
        }
        if (hasInjection || this.mySimpleLiteral == null) {
            marker2.drop();
            marker.done((IElementType)this.myCompoundLiteral);
        } else {
            this.finishSimpleLiteral(marker, marker2);
        }
        return hasInjection;
    }

    private void processContent() {
        PsiBuilder.Marker marker = this.myBuilder.mark();
        if (this.myBuilder.getTokenType() == this.myContent) {
            this.myBuilder.advanceLexer();
        } else {
            this.myBuilder.mark().done(this.myContent);
        }
        marker.done((IElementType)GSTRING_CONTENT);
    }

    private void finishSimpleLiteral(PsiBuilder.Marker marker, PsiBuilder.Marker marker2) {
        marker2.done(this.mySimpleLiteral);
        if (this.myForRefExpr) {
            marker.drop();
        } else {
            marker.done((IElementType)LITERAL);
        }
    }

    private boolean parseInjection() {
        if (this.myBuilder.getTokenType() != mDOLLAR) {
            return false;
        }
        PsiBuilder.Marker injection = this.myBuilder.mark();
        ParserUtils.getToken(this.myBuilder, mDOLLAR);
        if (this.myBuilder.getTokenType() == mIDENT || this.myBuilder.getTokenType() == kTHIS) {
            PathExpression.parse(this.myBuilder, this.myParser);
        } else if (this.myBuilder.getTokenType() == mLCURLY) {
            OpenOrClosableBlock.parseClosableBlock(this.myBuilder, this.myParser);
        } else {
            ParserUtils.wrapError(this.myBuilder, GroovyBundle.message("identifier.or.block.expected", new Object[0]));
        }
        injection.done((IElementType)GSTRING_INJECTION);
        return true;
    }

    public static boolean parse(@NotNull PsiBuilder builder, @NotNull GroovyParser parser, boolean forRefExpr, @NotNull IElementType begin, @NotNull IElementType content, @NotNull IElementType end, @Nullable IElementType literal, @NotNull GroovyElementType compoundLiteral, @NotNull String message) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/primary/CompoundStringExpression", "parse"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/primary/CompoundStringExpression", "parse"));
        }
        if (begin == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/primary/CompoundStringExpression", "parse"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/primary/CompoundStringExpression", "parse"));
        }
        if (end == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/primary/CompoundStringExpression", "parse"));
        }
        if (compoundLiteral == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "7", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/primary/CompoundStringExpression", "parse"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "8", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/primary/CompoundStringExpression", "parse"));
        }
        return new CompoundStringExpression(builder, parser, forRefExpr, begin, content, end, literal, compoundLiteral, message).parse();
    }
}

